/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.zip;

import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.ContentPackUtils;
import com.whisent.kubeloader.definition.PackLoadingContext;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import com.whisent.kubeloader.impl.ContentPackBase;
import com.whisent.kubeloader.mixinjs.MixinManager;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSL;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSLParser;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class ZipContentPack
extends ContentPackBase {
    private final Path path;
    private final String resourcePrefix;
    private final String dataPrefix;

    public ZipContentPack(Path path, PackMetaData metaData) {
        super(metaData);
        this.path = path;
        this.resourcePrefix = "pack_resources/assets/";
        this.dataPrefix = "pack_resources/data/";
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    @Nullable
    protected ScriptPack createPack(PackLoadingContext context) {
        ScriptPack scriptPack;
        this.loadMixins(context);
        ScriptPack pack = ContentPackUtils.createEmptyPack(context, this.id());
        String prefix = context.folderName() + "/";
        ZipFile zipFile = new ZipFile(this.path.toFile());
        try {
            zipFile.stream().filter(e -> !e.isDirectory()).filter(e -> e.getName().endsWith(".js")).filter(e -> e.getName().startsWith(prefix)).forEach(zipEntry -> {
                ScriptFileInfo zipFileInfo = new ScriptFileInfo(pack.info, zipEntry.getName());
                ScriptSource scriptSource = info -> {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream((ZipEntry)zipEntry), StandardCharsets.UTF_8));
                    return reader.lines().toList();
                };
                context.loadFile(pack, zipFileInfo, scriptSource);
            });
            scriptPack = pack;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                return null;
            }
        }
        zipFile.close();
        return scriptPack;
    }

    public void loadMixins(PackLoadingContext context) {
        if (!context.manager().scriptType.isStartup() || UtilsJS.staticServer != null) {
            return;
        }
        String mixinFolder = "mixin_scripts/";
        try (ZipFile zipFile = new ZipFile(this.path.toFile());){
            zipFile.stream().filter(e -> !e.isDirectory()).filter(e -> e.getName().endsWith(".js")).filter(e -> e.getName().startsWith(mixinFolder)).forEach(zipEntry -> {
                try {
                    String sourceCode = new BufferedReader(new InputStreamReader(zipFile.getInputStream((ZipEntry)zipEntry), StandardCharsets.UTF_8)).lines().reduce("", (a, b) -> a + "\n" + b);
                    String targetFile = ZipContentPack.extractTargetFileFromComments(sourceCode);
                    List<MixinDSL> dsls = MixinDSLParser.parse(sourceCode);
                    String fullPath = "zip:" + this.path.toString() + "!/" + zipEntry.getName();
                    for (MixinDSL dsl : dsls) {
                        if (targetFile != null && !targetFile.isEmpty()) {
                            dsl.setTargetFile(targetFile);
                        } else {
                            dsl.setTargetFile(fullPath);
                        }
                        MixinManager.addMixinDSL(targetFile, dsl);
                    }
                    if (!dsls.isEmpty()) {
                        Kubeloader.LOGGER.info("Loaded {} mixin DSLs from ZIP entry: {}", (Object)dsls.size(), (Object)fullPath);
                    }
                }
                catch (IOException e) {
                    Kubeloader.LOGGER.error("\u52a0\u8f7dmixin\u811a\u672c\u65f6\u51fa\u9519: {}", (Object)zipEntry.getName(), (Object)e);
                }
            });
        }
        catch (IOException e2) {
            Kubeloader.LOGGER.error("\u52a0\u8f7dzip\u4e2d\u7684mixin\u811a\u672c\u65f6\u51fa\u9519: {}", (Object)this.path, (Object)e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractTargetFileFromComments(String sourceCode) {
        try (BufferedReader reader = new BufferedReader(new StringReader(sourceCode));){
            Matcher matcher;
            String line;
            String trimmedLine;
            do {
                if ((line = reader.readLine()) == null) return null;
            } while (!(trimmedLine = line.trim()).startsWith("//") || !(matcher = MixinManager.MIXIN_COMMENT_PATTERN.matcher(trimmedLine)).find());
            String string = matcher.group(1);
            return string;
        }
        catch (IOException e) {
            Kubeloader.LOGGER.error("Error extracting target file from comments", (Throwable)e);
        }
        return null;
    }

    public Set<String> getNamespaces(PackType packType) {
        String prefix = packType == PackType.CLIENT_RESOURCES ? this.resourcePrefix : this.dataPrefix;
        HashSet<String> namespaces = new HashSet<String>();
        try (ZipFile zipFile = new ZipFile(this.path.toFile());){
            zipFile.stream().filter(entry -> !entry.isDirectory()).filter(entry -> entry.getName().startsWith(prefix)).map(entry -> this.getNamespaceFromPath(entry.getName(), prefix)).forEach(namespaces::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return namespaces;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        String prefix = packType == PackType.CLIENT_RESOURCES ? this.resourcePrefix : this.dataPrefix;
        String path = prefix + location.m_135827_() + "/" + location.m_135815_();
        try (ZipFile zipFile = new ZipFile(this.path.toFile());){
            ZipEntry entry = zipFile.getEntry(path);
            if (entry == null) return null;
            IoSupplier ioSupplier = () -> zipFile.getInputStream(entry);
            return ioSupplier;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String getNamespaceFromPath(String path, String prefix) {
        String relativePath = path.substring(prefix.length());
        int firstSlash = relativePath.indexOf(47);
        if (firstSlash != -1) {
            return relativePath.substring(0, firstSlash);
        }
        return "";
    }

    public String toString() {
        return "ZipContentPack[namespace=%s]".formatted(this.metaData.id());
    }
}

