/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.zip;

import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.ContentPack;
import com.whisent.kubeloader.definition.ContentPackProvider;
import com.whisent.kubeloader.definition.ContentPackUtils;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import com.whisent.kubeloader.impl.zip.ZipContentPack;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

public class ZipContentPackProvider
implements ContentPackProvider {
    private final Path basePath;

    public ZipContentPackProvider(Path basePath) {
        this.basePath = basePath;
    }

    @Override
    @NotNull
    public @NotNull Collection<? extends @NotNull ContentPack> providePack() {
        try {
            return Files.list(this.basePath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).filter(f -> f.getName().endsWith(".zip")).map(this::safelyScanSingle).filter(Objects::nonNull).toList();
        }
        catch (IOException e) {
            Kubeloader.LOGGER.error("Error when scanning zip file for ContentPack, ignoring all zip");
            return List.of();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ContentPack safelyScanSingle(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry entry = zipFile.getEntry("contentpack.json");
            if (entry == null) {
                ContentPack contentPack = null;
                return contentPack;
            }
            if (entry.isDirectory()) {
                throw new RuntimeException(String.format("%s should be a file, but got a directory", "contentpack.json"));
            }
            PackMetaData metadata = ContentPackUtils.loadMetaDataOrThrow(zipFile.getInputStream(entry));
            ZipContentPack zipContentPack = new ZipContentPack(file.toPath(), metadata);
            return zipContentPack;
        }
        catch (Exception e) {
            Kubeloader.LOGGER.error("Error when scanning zip file: {}", (Object)file.getName(), (Object)e);
            return null;
        }
    }
}

