/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.impl.zip;

import com.whisent.kubeloader.impl.zip.ZipContentPack;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.metadata.pack.PackMetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class ZipContentPackResources
implements PackResources {
    private final String name;
    private final ZipContentPack contentPack;
    private final Path path;
    private final String resourcePrefix;
    private final String dataPrefix;
    private PackMetadataSection packMeta;

    public ZipContentPackResources(String name, ZipContentPack contentPack) {
        this.name = name;
        this.contentPack = contentPack;
        this.path = contentPack.getPath();
        this.resourcePrefix = "pack_resources/assets/";
        this.dataPrefix = "pack_resources/data/";
    }

    public String m_5542_() {
        return this.name;
    }

    public String toString() {
        return "ZipContentPackResources[" + this.name + "]";
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation resourceLocation) {
        String prefix = packType == PackType.CLIENT_RESOURCES ? this.resourcePrefix : this.dataPrefix;
        String path = prefix + resourceLocation.m_135827_() + "/" + resourceLocation.m_135815_();
        try (ZipFile zipFile = new ZipFile(this.path.toFile());){
            ZipEntry entry = zipFile.getEntry(path);
            if (entry == null) return null;
            IoSupplier ioSupplier = () -> zipFile.getInputStream(entry);
            return ioSupplier;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void m_8031_(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        String prefix = packType == PackType.CLIENT_RESOURCES ? this.resourcePrefix : this.dataPrefix;
        String searchPath = prefix + namespace + "/" + path + "/";
        try (ZipFile zipFile = new ZipFile(this.path.toFile());){
            zipFile.stream().filter(entry -> !entry.isDirectory()).filter(entry -> entry.getName().startsWith(searchPath)).forEach(entry -> {
                String fileName = entry.getName().substring(prefix.length() + namespace.length() + 1);
                Object fullPath = path.isEmpty() ? fileName : path + "/" + fileName;
                ResourceLocation location = ResourceLocation.m_214293_((String)namespace, (String)fullPath);
                if (location != null) {
                    resourceOutput.accept((Object)location, () -> zipFile.getInputStream((ZipEntry)entry));
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Set<String> m_5698_(PackType packType) {
        String prefix = packType == PackType.CLIENT_RESOURCES ? this.resourcePrefix : this.dataPrefix;
        HashSet<String> namespaces = new HashSet<String>();
        try (ZipFile zipFile = new ZipFile(this.path.toFile());){
            zipFile.stream().filter(entry -> !entry.isDirectory()).filter(entry -> entry.getName().startsWith(prefix)).map(entry -> this.getNamespaceFromPath(entry.getName(), prefix)).forEach(namespaces::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return namespaces;
    }

    private String getNamespaceFromPath(String path, String prefix) {
        String relativePath = path.substring(prefix.length());
        int firstSlash = relativePath.indexOf(47);
        if (firstSlash != -1) {
            return relativePath.substring(0, firstSlash);
        }
        return "";
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metadataSectionSerializer) {
        if (metadataSectionSerializer instanceof PackMetadataSectionSerializer) {
            if (this.packMeta == null) {
                this.packMeta = this.createDefaultPackMeta();
            }
            return (T)this.packMeta;
        }
        return null;
    }

    private PackMetadataSection createDefaultPackMeta() {
        return new PackMetadataSection((Component)Component.m_237113_((String)("Content Pack: " + this.name)), 15);
    }

    public void close() {
    }
}

