/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.item.dynamic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.whisent.kubeloader.item.dynamic.definition.DynamicItem;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class DynamicSwordItem
extends SwordItem
implements DynamicItem {
    public Map<String, Tier> enableTierMap;
    public int baseAttack;
    public float baseAttackSpeed;
    public String baseTier;

    public DynamicSwordItem(int baseAttack, float baseAttackSpeed, String baseTier, Map<String, Tier> enableTierMap) {
        super((Tier)Tiers.WOOD, 0, 0.0f, new Item.Properties());
        this.baseAttack = baseAttack;
        this.baseAttackSpeed = baseAttackSpeed;
        this.baseTier = baseTier;
        this.enableTierMap = enableTierMap;
    }

    @Override
    public Tier getTier(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        String tierName = tag.m_128461_("tool_tier");
        this.enableTierMap.get(tierName);
        if (this.enableTierMap.get(tierName) != null) {
            return this.enableTierMap.get(tierName);
        }
        return Tiers.WOOD;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            float attackBonus = stack.m_41783_().m_128451_("attack_bonus");
            float attackSpeed = stack.m_41783_().m_128457_("attack_speed");
            modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)attackBonus, AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.randomUUID(), "Weapon modifier", 0.0, AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("baseAttributes", (Tag)new CompoundTag());
        CompoundTag baseTag = tag.m_128469_("baseAttributes");
        baseTag.m_128359_("tool_tier", this.baseTier);
        baseTag.m_128405_("attack_bonus", this.baseAttack);
        baseTag.m_128350_("attack_speed", this.baseAttackSpeed);
        return stack;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getTier(stack).m_6609_();
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.getTier(stack).m_6601_();
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairItem) {
        return this.getTier(stack).m_6282_().test(repairItem);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.getTier(stack).m_6624_();
    }
}

