/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.item.dynamic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.whisent.kubeloader.item.dynamic.attributes.DynamicAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.TierSortingRegistry;
import org.jetbrains.annotations.NotNull;

public class DynamicTieredItem
extends DiggerItem
implements DynamicAttributes {
    public int baseAttack;
    public float baseAttackSpeed;
    public Map<String, Tier> enableTierMap;
    public Tier baseTier;
    public String baseTierName;
    private TagKey<Block> blocks;
    private ArrayList<Tier> tiers;
    public HashMap<String, HashMap<String, Object>> extendAttributesMap = new HashMap();
    private final UUID REACH_UUID = UUID.fromString("6E81DA22-D3A3-6861-425E-17A86AB675E2");
    private final UUID MAX_HEALTH_UUID = UUID.fromString("F0B38DBC-DE56-D4C1-C719-7C01DED7B028");
    private final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("8ECB9FE0-C171-BECB-6F18-BD417246D64C");
    private final UUID MOVEMENT_SPEED_UUID = UUID.fromString("9138D62D-343B-2095-2F02-753C71AE9244");
    private final UUID FLY_SPEED_UUID = UUID.fromString("B18E2AD3-589E-155E-C88D-B29977CD29A6");
    private final UUID LUCK_UUID = UUID.fromString("691594AC-16C4-FD27-8D31-BB15B3F8AE7B");
    private final UUID JUMP_STRENGTH_UUID = UUID.fromString("F47B240E-7A23-2A07-CB00-7BB881096511");
    private final UUID DIG_SPEED_UUID = UUID.fromString("43EAFB1E-6180-D729-DA84-9D6EE4588312");
    private final UUID ARMOR_TOUGHNESS_UUID = UUID.fromString("2EC897D4-113B-55D0-DFCE-7B51527BBA7C");
    private final UUID ARMOR_UUID = UUID.fromString("2de1b442-56aa-ba93-37d6-27216aad7c7e");
    private final UUID ENTITY_GRAVITY_UUID = UUID.fromString("F9984215-BFB6-E9BB-12E7-A3D313082F10");

    public DynamicTieredItem(int baseAttack, float baseAttackSpeed, String baseTier, Map<String, Tier> enableTierMap, HashMap<String, HashMap<String, Object>> extendAttributesMap) {
        super((float)baseAttack, baseAttackSpeed, (Tier)Tiers.WOOD, BlockTags.f_144282_, new Item.Properties());
        this.enableTierMap = enableTierMap;
        this.baseAttack = baseAttack;
        this.baseAttackSpeed = baseAttackSpeed;
        this.baseTier = enableTierMap.get(baseTier);
        this.baseTierName = baseTier;
        this.extendAttributesMap = extendAttributesMap;
    }

    public CompoundTag getDynamic(ItemStack stack) {
        return stack.m_41783_().m_128469_("KLDynamic");
    }

    public TagKey<Block> getBlocks(ItemStack stack) {
        String toolType;
        return switch (toolType = this.getDynamic(stack).m_128461_("tool_type")) {
            case "shovel" -> BlockTags.f_144283_;
            case "pickaxe" -> BlockTags.f_144282_;
            case "axe" -> BlockTags.f_144280_;
            case "hoe" -> BlockTags.f_144281_;
            default -> BlockTags.f_144282_;
        };
    }

    public Tier getTier(ItemStack stack) {
        CompoundTag tag = stack.m_41784_().m_128469_("KLDynamic");
        String tierName = tag.m_128461_("tool_tier");
        this.enableTierMap.get(tierName);
        if (this.enableTierMap.get(tierName) != null) {
            return this.enableTierMap.get(tierName);
        }
        return this.baseTier;
    }

    public Float getDigSpeed(ItemStack stack) {
        CompoundTag tag = this.getDynamic(stack);
        if (tag.m_128457_("dig_speed") == 0.0f) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf(tag.m_128457_("dig_speed"));
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41784_().m_128365_("KLDynamic", (Tag)new CompoundTag());
        CompoundTag tag = this.getDynamic(stack);
        tag.m_128359_("tool_tier", this.baseTierName);
        tag.m_128350_("max_health", 10.0f);
        tag.m_128405_("armor", 4);
        tag.m_128350_("entity_gravity", -0.01f);
        return stack;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            CompoundTag tag = this.getDynamic(stack);
            float attackBonus = this.baseAttack + tag.m_128451_("attack_bonus");
            float attackSpeed = this.baseAttackSpeed + tag.m_128457_("attack_speed");
            float armor = tag.m_128451_("armor");
            float armorToughness = tag.m_128451_("armor_toughness");
            float movementSpeed = tag.m_128457_("movement_speed");
            float luck = tag.m_128457_("luck") + 5.0f;
            float flyingSpeed = tag.m_128457_("flying_speed");
            float knockbackResistance = tag.m_128457_("knockback_resistance");
            float jumpStrength = tag.m_128457_("jump_strength");
            float maxHealth = tag.m_128457_("max_health");
            float entityGravity = tag.m_128457_("entity_gravity");
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, f_41374_, Attributes.f_22281_, Float.valueOf(attackBonus));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, f_41375_, Attributes.f_22283_, Float.valueOf(attackSpeed));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, this.ARMOR_UUID, Attributes.f_22284_, Float.valueOf(armor));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, this.ARMOR_TOUGHNESS_UUID, Attributes.f_22285_, Float.valueOf(armorToughness));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, this.MOVEMENT_SPEED_UUID, Attributes.f_22279_, Float.valueOf(movementSpeed));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, this.LUCK_UUID, Attributes.f_22286_, Float.valueOf(luck));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, this.FLY_SPEED_UUID, Attributes.f_22280_, Float.valueOf(flyingSpeed));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, this.KNOCKBACK_RESISTANCE_UUID, Attributes.f_22278_, Float.valueOf(knockbackResistance));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, this.JUMP_STRENGTH_UUID, Attributes.f_22288_, Float.valueOf(jumpStrength));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, this.MAX_HEALTH_UUID, Attributes.f_22276_, Float.valueOf(maxHealth));
            this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, this.ENTITY_GRAVITY_UUID, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), Float.valueOf(entityGravity));
            this.extendAttributesMap.forEach((arg_0, arg_1) -> this.lambda$getAttributeModifiers$0(tag, (Multimap)modifiers, arg_0, arg_1));
            return modifiers;
        }
        return modifiers;
    }

    public void putAttributes(Multimap<Attribute, AttributeModifier> modifiers, UUID uuid, Attribute attribute, Float value) {
        modifiers.put((Object)attribute, (Object)new AttributeModifier(uuid, "modifier", (double)value.floatValue(), AttributeModifier.Operation.ADDITION));
    }

    public void putExtendAttributesMap(String id, UUID uuid, Attribute attribute) {
        HashMap<String, UUID> map = new HashMap<String, UUID>();
        map.put("uuid", uuid);
        map.put("attribute", (UUID)attribute);
        this.extendAttributesMap.put(id, map);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getTier(stack).m_6609_();
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.getTier(stack).m_6601_();
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairItem) {
        return this.getTier(stack).m_6282_().test(repairItem);
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        return pState.m_204336_(this.getBlocks(pStack)) ? this.getDigSpeed(pStack).floatValue() : 1.0f;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(2, pAttacker, p_41007_ -> p_41007_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (!pLevel.f_46443_ && pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(1, pEntityLiving, p_40992_ -> p_40992_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_204336_(this.getBlocks(stack)) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.getTier(stack), (BlockState)state);
    }

    private /* synthetic */ void lambda$getAttributeModifiers$0(CompoundTag tag, Multimap modifiers, String key, HashMap value) {
        float addValue = ((Float)value.get("base")).floatValue() + tag.m_128457_(key);
        this.putAttributes((Multimap<Attribute, AttributeModifier>)modifiers, (UUID)value.get("uuid"), (Attribute)value.get("attribute"), Float.valueOf(addValue));
    }
}

