/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.item.dynamic;

import com.whisent.kubeloader.item.dynamic.DynamicTieredItem;
import com.whisent.kubeloader.item.dynamic.definition.DynamicBuilder;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;

public class DynamicTieredItemBuilder
extends ItemBuilder
implements DynamicBuilder {
    public HashMap<String, Tier> enableTierMap = new HashMap();
    public int baseAttack = 0;
    public float baseAttackSpeed = -3.0f;
    public String baseTier = "wood";
    public HashMap<String, HashMap<String, Object>> extendAttributesMap = new HashMap();

    public DynamicTieredItemBuilder(ResourceLocation i) {
        super(i);
        this.enableTierMap = this.initTierMap(this.enableTierMap);
    }

    @Override
    @Info(value="\u5411\u7269\u54c1\u6dfb\u52a0\u5141\u8bb8\u7684Tier.")
    public ItemBuilder putTier(String tierName, Tier tier) {
        this.enableTierMap.put(tierName, tier);
        return this;
    }

    @Override
    @Info(value="\u5220\u9664\u7269\u54c1\u5141\u8bb8\u7684Tier.")
    public ItemBuilder removeTier(String tierName) {
        this.enableTierMap.remove(tierName);
        return this;
    }

    @Override
    public ItemBuilder setDefaultTier(String tierName) {
        this.baseTier = tierName;
        return this;
    }

    @Override
    @Info(value="\u57fa\u7840\u653b\u51fb\u4f1a\u548cnbt\u653b\u51fb\u5171\u540c\u7ec4\u6210\u6700\u7ec8\u7684\u653b\u51fb\u529b")
    public ItemBuilder setBaseAttack(int baseAttack) {
        this.baseAttack = baseAttack;
        return this;
    }

    @Override
    @Info(value="\u57fa\u7840\u653b\u51fb\u901f\u5ea6\u4f1a\u548cnbt\u653b\u51fb\u901f\u5ea6\u5171\u540c\u7ec4\u6210\u6700\u7ec8\u7684\u653b\u51fb\u901f\u5ea6")
    public ItemBuilder setBassAttackSpeed(float bassAttackSpeed) {
        this.baseAttackSpeed = bassAttackSpeed;
        return this;
    }

    @Info(value="\u4e3a\u6b66\u5668\u6dfb\u52a0\u65b0\u7684\u5c5e\u6027nbt\nExample usage:\n```javascript\nputAttribute(nbtName,{base:1,uuid:'',attributes:''})\n```\n")
    public ItemBuilder putAttribute(String key, HashMap<String, Object> valueMap) {
        this.extendAttributesMap.put(key, valueMap);
        return this;
    }

    public Item createObject() {
        return new DynamicTieredItem(this.baseAttack, this.baseAttackSpeed, this.baseTier, this.enableTierMap, this.extendAttributesMap);
    }
}

