/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixin;

import com.whisent.kubeloader.event.kjs.ItemEntityEventJS;
import com.whisent.kubeloader.event.kjs.ItemEntityEvents;
import com.whisent.kubeloader.event.kjs.ItemEntityHurtEventJS;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemEntity.class})
public class ItemEntityMixin {
    @Shadow
    private int f_31987_;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onItemEntityTickAfterPhysics(CallbackInfo ci) {
        ItemEntity itemEntity = (ItemEntity)this;
        Vec3 pos = itemEntity.m_20182_();
        Level level = itemEntity.m_9236_();
        if (level.m_5776_()) {
            ItemEntityEvents.ITEM_ENTITY_TICK.post((ScriptTypeHolder)ScriptType.CLIENT, (Object)itemEntity.m_32055_().m_41720_(), (EventJS)new ItemEntityEventJS(itemEntity, level, pos));
        } else {
            ItemEntityEvents.ITEM_ENTITY_TICK.post((ScriptTypeHolder)ScriptType.SERVER, (Object)itemEntity.m_32055_().m_41720_(), (EventJS)new ItemEntityEventJS(itemEntity, level, pos));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        ItemEntity itemEntity = (ItemEntity)this;
        Level level = itemEntity.m_9236_();
        Vec3 pos = itemEntity.m_20182_();
        if (itemEntity.m_213877_() || itemEntity.m_6673_(source)) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (level.f_46443_) {
            cir.setReturnValue((Object)true);
            return;
        }
        ItemEntityHurtEventJS event = new ItemEntityHurtEventJS(itemEntity, level, pos, source, amount);
        EventResult result = ItemEntityEvents.ITEM_ENTITY_HURT.post((EventJS)event, (Object)itemEntity.m_32055_().m_41720_());
        if (result.interruptTrue()) {
            cir.setReturnValue((Object)false);
            return;
        }
        float finalAmount = event.amount;
        itemEntity.f_19864_ = true;
        this.f_31987_ = (int)((float)this.f_31987_ - finalAmount);
        itemEntity.m_146852_(GameEvent.f_223706_, source.m_7639_());
        if (this.f_31987_ <= 0) {
            itemEntity.m_32055_().onDestroyed(itemEntity, source);
            itemEntity.m_146870_();
        }
        cir.setReturnValue((Object)true);
    }
}

