/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixin;

import com.whisent.kubeloader.impl.mixin_interface.ScriptFileInfoInterface;
import com.whisent.kubeloader.utils.Debugger;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import dev.latvian.mods.kubejs.script.ScriptSource;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ScriptFileInfo.class}, remap=false)
public abstract class ScriptFileInfoMixin
implements ScriptFileInfoInterface {
    @Shadow
    @Final
    public ScriptPackInfo pack;
    @Unique
    private String targetPath = "";
    @Unique
    private static final Pattern MIXIN_PATTERN = Pattern.compile("^//mixin\\s*\\(\\s*value\\s*=\\s*\"([^\"]+)\"\\s*\\)");

    @Override
    @Unique
    public String kubeLoader$getTargetPath() {
        return this.targetPath;
    }

    @Override
    @Unique
    public void kubeLoader$setTargetPath(String targetPath) {
        if (Objects.equals(this.targetPath, "")) {
            this.targetPath = targetPath;
        }
    }

    @Inject(method={"preload"}, at={@At(value="INVOKE", target="Ljava/lang/String;startsWith(Ljava/lang/String;)Z", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void onProcessLine(ScriptSource source, CallbackInfo ci, int i, String tline) {
        Matcher mixinMatcher;
        if (!tline.isEmpty() && !tline.startsWith("import ") && tline.startsWith("//") && tline.contains("mixin") && (mixinMatcher = MIXIN_PATTERN.matcher(tline)).find()) {
            String mixinValue = mixinMatcher.group(1);
            Debugger.out("\u627e\u5230mixin\u6ce8\u91ca\uff1a" + mixinValue);
            this.kubeLoader$setTargetPath(mixinValue);
        }
    }
}

