/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixin;

import com.whisent.kubeloader.impl.mixin_interface.ScriptFileInfoInterface;
import com.whisent.kubeloader.mixinjs.MixinManager;
import com.whisent.kubeloader.mixinjs.ast.AstToSourceConverter;
import com.whisent.kubeloader.mixinjs.ast.JSInjector;
import com.whisent.kubeloader.mixinjs.dsl.EventProbe;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSL;
import com.whisent.kubeloader.utils.Debugger;
import dev.latvian.mods.kubejs.script.ScriptFile;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Parser;
import dev.latvian.mods.rhino.ast.AstRoot;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ScriptFile.class}, remap=false)
public class ScriptFileMixin {
    @Shadow
    @Final
    public ScriptFileInfo info;
    @Shadow
    @Final
    public ScriptPack pack;
    @Shadow
    @Final
    public ScriptSource source;

    @Inject(method={"load"}, at={@At(value="HEAD")}, cancellable=true)
    public void kubeLoader$load(CallbackInfo ci) throws Throwable {
        Debugger.out("\u52a0\u8f7d\u811a\u672c " + this.info.location);
        Debugger.out("mixin DSL Map: " + this.kubeLoader$getMixinDSL().keySet());
        if (this.kubeLoader$getMixinDSL().getOrDefault(this.info.location, null) != null) {
            String sourceCode = String.join((CharSequence)"\n", this.info.lines);
            Parser parser = new Parser(this.pack.manager.context);
            AstRoot root = parser.parse(sourceCode, this.info.file, 0);
            AstToSourceConverter converter = new AstToSourceConverter(sourceCode);
            AtomicReference<String> modifiedSourceCode = new AtomicReference<String>(sourceCode);
            this.kubeLoader$getMixinDSL().get(this.info.location).forEach(dsl -> {
                if (Objects.equals(dsl.getType(), "EventSubscription")) {
                    modifiedSourceCode.set(EventProbe.applyTo((String)modifiedSourceCode.get(), dsl));
                } else if (Objects.equals(dsl.getType(), "FunctionDeclaration")) {
                    JSInjector.injectFromDSL(root, dsl);
                    modifiedSourceCode.set(converter.convertAndFix(root, dsl.getAction()));
                }
                Debugger.out("\u4fee\u6539\u540e\u7684\u6e90\u4ee3\u7801 " + this.info.location + ":\n" + (String)modifiedSourceCode.get());
                this.pack.manager.scriptType.console.info((Object)("Apply mixin for " + this.info.location + " from " + dsl.getSourcePath()));
            });
            this.pack.manager.context.evaluateString(this.pack.scope, modifiedSourceCode.get(), this.info.location, 1, null);
            this.info.lines = UtilsJS.EMPTY_STRING_ARRAY;
            ci.cancel();
        }
    }

    private void kubeLoader$applyMixin() {
        String mixinPath = ((ScriptFileInfoInterface)this.info).kubeLoader$getTargetPath();
        if (!mixinPath.isEmpty()) {
            this.pack.manager.scriptType.console.warn((Object)"You should put mixin scripts in mixins folder!");
        }
    }

    private Map<String, List<MixinDSL>> kubeLoader$getMixinDSL() {
        return MixinManager.getMixinMap();
    }

    private void kubeLoader$addMixinDSL(String path, MixinDSL dsl) {
        this.kubeLoader$getMixinDSL().putIfAbsent(path, new ArrayList());
        if (this.kubeLoader$getMixinDSL().get(path) != null) {
            this.kubeLoader$getMixinDSL().get(path).add(dsl);
        }
    }

    private Logger getConsole() {
        return this.pack.manager.scriptType.console.logger;
    }

    private void kubeLoader$debugLog(String msg) {
    }

    private /* synthetic */ void lambda$kubeLoader$applyMixin$2(String mixinPath, MixinDSL dsl) {
        dsl.setFile((ScriptFile)this);
        dsl.setTargetFile(mixinPath);
        dsl.setSourcePath(this.info.location);
        this.kubeLoader$addMixinDSL(mixinPath, dsl);
        this.pack.manager.scriptType.console.info((Object)("Adding new mixin object for " + mixinPath));
        this.pack.manager.scriptType.console.info((Object)("  Type: " + dsl.getType() + (String)(dsl.getPriority() != 0 ? " Priority: " + dsl.getPriority() : "")));
    }

    private static /* synthetic */ int lambda$kubeLoader$applyMixin$1(MixinDSL a, MixinDSL b) {
        return Integer.compare(b.getPriority(), a.getPriority());
    }
}

