/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixin;

import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.ContentPack;
import com.whisent.kubeloader.definition.PackLoadingContext;
import com.whisent.kubeloader.definition.inject.SortablePacksHolder;
import com.whisent.kubeloader.impl.ContentPackProviders;
import com.whisent.kubeloader.impl.depends.DependencyReport;
import com.whisent.kubeloader.impl.depends.PackDependencyBuilder;
import com.whisent.kubeloader.impl.depends.PackDependencyValidator;
import com.whisent.kubeloader.impl.depends.SortableContentPack;
import com.whisent.kubeloader.impl.mixin_interface.ScriptManagerInterface;
import com.whisent.kubeloader.mixinjs.MixinManager;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSL;
import com.whisent.kubeloader.utils.topo.TopoNotSolved;
import com.whisent.kubeloader.utils.topo.TopoPreconditionFailed;
import com.whisent.kubeloader.utils.topo.TopoSort;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ScriptManager.class}, remap=false)
public abstract class ScriptManagerMixin
implements SortablePacksHolder,
ScriptManagerInterface {
    @Shadow
    @Final
    public Map<String, ScriptPack> packs;
    @Unique
    private Map<String, SortableContentPack> kubeLoader$sortablePacks;
    @Unique
    private Map<String, List<MixinDSL>> kubeLoader$mixinDSLs = new HashMap<String, List<MixinDSL>>();

    @Redirect(method={"load"}, at=@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;"))
    private Collection<ScriptPack> injectPacks(Map<String, ScriptPack> original) {
        this.getKubeLoader$mixinDSLs().clear();
        PackLoadingContext context = new PackLoadingContext((ScriptManager)this);
        List<ContentPack> packs = ContentPackProviders.getPacks();
        DependencyReport report = ScriptManagerMixin.kubeLoader$validateContentPacks(packs, context);
        if (!report.errors().isEmpty()) {
            return original.values();
        }
        Map indexed = packs.stream().collect(Collectors.toMap(ContentPack::id, Function.identity()));
        HashMap<String, SortableContentPack> sortablePacks = new HashMap<String, SortableContentPack>();
        for (ContentPack contentPack : packs) {
            Kubeloader.LOGGER.debug("\u5bfb\u627e\u5230contentPack: {}", (Object)contentPack);
            ScriptPack scriptPack = contentPack.getPack(context);
            String namespace = contentPack.id();
            List<Object> scriptPacks = "kubejs".equals(namespace) ? original.values().stream().filter(p -> !indexed.containsKey(p.info.namespace)).toList() : (scriptPack != null ? List.of(contentPack.postProcessPack(context, scriptPack)) : List.of());
            SortableContentPack sortable = new SortableContentPack(namespace, contentPack, scriptPacks);
            sortablePacks.put(namespace, sortable);
        }
        this.kubeLoader$sortablePacks = Map.copyOf(sortablePacks);
        PackDependencyBuilder dependencyBuilder = new PackDependencyBuilder();
        dependencyBuilder.build(sortablePacks.values());
        try {
            return TopoSort.sort(sortablePacks.values()).stream().map(SortableContentPack::scriptPacks).flatMap(Collection::stream).toList();
        }
        catch (TopoNotSolved | TopoPreconditionFailed e) {
            context.console().error((Object)e);
            return original.values();
        }
    }

    @Inject(method={"loadFile"}, at={@At(value="TAIL", target="Ldev/latvian/mods/kubejs/script/ScriptFileInfo;preload(Ldev/latvian/mods/kubejs/script/ScriptSource;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void kubeLoader$loadFile(ScriptPack pack, ScriptFileInfo fileInfo, ScriptSource source, CallbackInfo ci) {
    }

    @Inject(method={"loadFromDirectory"}, at={@At(value="HEAD")})
    private void injectContentPacks(CallbackInfo ci) {
        if (this.thiz().scriptType.isStartup() || UtilsJS.staticServer != null) {
            MixinManager.getMixinMap().clear();
            MixinManager.loadMixins(Kubeloader.MixinPath, "");
        }
    }

    @Override
    public Map<String, SortableContentPack> kubeLoader$sortablePacks() {
        return this.kubeLoader$sortablePacks;
    }

    @Unique
    @NotNull
    private static DependencyReport kubeLoader$validateContentPacks(List<ContentPack> packs, PackLoadingContext context) {
        PackDependencyValidator validator = new PackDependencyValidator(PackDependencyValidator.DupeHandling.ERROR);
        DependencyReport report = validator.validate(packs);
        report.infos().stream().map(Component::getString).forEach(arg_0 -> ((ConsoleJS)context.console()).info(arg_0));
        report.warnings().stream().map(Component::getString).forEach(arg_0 -> ((ConsoleJS)context.console()).warn(arg_0));
        report.errors().stream().map(Component::getString).forEach(arg_0 -> ((ConsoleJS)context.console()).error(arg_0));
        return report;
    }

    @Override
    public Map<String, List<MixinDSL>> getKubeLoader$mixinDSLs() {
        return this.kubeLoader$mixinDSLs;
    }

    public ScriptManager thiz() {
        return (ScriptManager)this;
    }
}

