/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixinjs;

import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSL;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSLParser;
import com.whisent.kubeloader.utils.Debugger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MixinManager {
    private static final Map<String, List<MixinDSL>> mixinMap = new ConcurrentHashMap<String, List<MixinDSL>>();
    public static final Pattern MIXIN_COMMENT_PATTERN = Pattern.compile("//\\s*mixin\\s*\\(\\s*value\\s*=\\s*\"([^\"]+)\"\\s*\\)");

    public static Map<String, List<MixinDSL>> getMixinMap() {
        return mixinMap;
    }

    public static void addMixinDSL(String targetPath, MixinDSL dsl) {
        mixinMap.putIfAbsent(targetPath, new ArrayList());
        if (mixinMap.get(targetPath) != null) {
            mixinMap.get(targetPath).add(dsl);
        }
    }

    public static void loadMixins(Path dir, String path) {
        if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) {
            Kubeloader.LOGGER.debug("Mixin directory does not exist or is not a directory: {}", (Object)dir);
            return;
        }
        if (!((String)path).isEmpty() && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        String pathPrefix = path;
        try {
            Iterator<Path> var8 = Files.walk(dir, 10, FileVisitOption.FOLLOW_LINKS).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList().iterator();
            while (true) {
                if (!var8.hasNext()) {
                    return;
                }
                Path file = var8.next();
                String fileName = dir.relativize(file).toString().replace(File.separatorChar, '/');
                if (!fileName.endsWith(".js") && (!fileName.endsWith(".ts") || fileName.endsWith(".d.ts"))) continue;
                String fullPath = pathPrefix + fileName;
                String sourceCode = Files.readString(file);
                String targetFile = MixinManager.extractTargetFileFromComments(sourceCode);
                Debugger.out("mixin\u8def\u5f84" + fullPath);
                Debugger.out("\u76ee\u6807\u6587\u4ef6" + targetFile);
                List<MixinDSL> dsls = MixinDSLParser.parse(sourceCode);
                for (MixinDSL dsl : dsls) {
                    if (targetFile != null && !targetFile.isEmpty()) {
                        dsl.setTargetFile(targetFile);
                    } else {
                        dsl.setTargetFile(fullPath);
                    }
                    MixinManager.addMixinDSL(targetFile, dsl);
                }
                if (dsls.isEmpty()) continue;
                Kubeloader.LOGGER.info("Loaded {} mixin DSLs from {}", (Object)dsls.size(), (Object)fullPath);
            }
        }
        catch (IOException var7) {
            Kubeloader.LOGGER.error("Error loading mixins from directory: {}", (Object)dir, (Object)var7);
            return;
        }
    }

    private static String extractTargetFileFromComments(String sourceCode) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(sourceCode));
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                String trimmedLine = line.trim();
                if (!trimmedLine.startsWith("//") || !(matcher = MIXIN_COMMENT_PATTERN.matcher(trimmedLine)).find()) continue;
                return matcher.group(1);
            }
        }
        catch (IOException e) {
            Kubeloader.LOGGER.error("Error extracting target file from comments", (Throwable)e);
        }
        return null;
    }
}

