/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixinjs.ast;

import dev.latvian.mods.rhino.Node;
import dev.latvian.mods.rhino.ast.AstNode;
import dev.latvian.mods.rhino.ast.AstRoot;
import dev.latvian.mods.rhino.ast.Block;
import dev.latvian.mods.rhino.ast.ExpressionStatement;
import dev.latvian.mods.rhino.ast.FunctionCall;
import dev.latvian.mods.rhino.ast.FunctionNode;
import dev.latvian.mods.rhino.ast.Name;
import dev.latvian.mods.rhino.ast.NumberLiteral;
import dev.latvian.mods.rhino.ast.PropertyGet;
import dev.latvian.mods.rhino.ast.Scope;
import dev.latvian.mods.rhino.ast.StringLiteral;
import dev.latvian.mods.rhino.ast.VariableDeclaration;
import dev.latvian.mods.rhino.ast.VariableInitializer;
import java.util.ArrayList;
import java.util.List;

public class AstToSourceConverter {
    private final StringBuilder sb = new StringBuilder();
    private int lastPosition = 0;
    private final String source;

    public AstToSourceConverter(String source) {
        this.source = source;
    }

    public String convert(AstRoot root) {
        this.lastPosition = 0;
        this.sb.setLength(0);
        if (this.source == null || this.source.isEmpty()) {
            this.generateNodeSource((AstNode)root);
            return this.sb.toString();
        }
        this.traverse((AstNode)root);
        if (this.lastPosition >= 0 && this.lastPosition < this.source.length()) {
            this.sb.append(this.source.substring(this.lastPosition));
        }
        return this.sb.toString();
    }

    private void traverse(AstNode node) {
        int actualEnd;
        int actualStart;
        if (node == null) {
            return;
        }
        int start = node.getAbsolutePosition();
        int end = start + node.getLength();
        if (start < 0 || end < 0) {
            this.generateNodeSource(node);
            return;
        }
        if (start > this.source.length() || end > this.source.length()) {
            return;
        }
        if (start > this.lastPosition && this.lastPosition >= 0 && (actualStart = Math.max(0, this.lastPosition)) < (actualEnd = Math.min(start, this.source.length()))) {
            this.sb.append(this.source.substring(actualStart, actualEnd));
        }
        this.lastPosition = Math.max(0, start);
        if (node instanceof AstRoot) {
            this.handleAstRoot((AstRoot)node);
        } else if (node instanceof FunctionNode) {
            this.handleFunctionNode((FunctionNode)node);
        } else if (node instanceof Block) {
            this.handleBlock((Block)node);
        } else if (node instanceof VariableDeclaration) {
            this.handleVariableDeclaration((VariableDeclaration)node);
        } else if (node instanceof ExpressionStatement) {
            this.handleExpressionStatement((ExpressionStatement)node);
        } else {
            for (AstNode child = (AstNode)node.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
                this.traverse(child);
            }
            if (this.lastPosition >= 0 && this.lastPosition < end && end <= this.source.length()) {
                this.sb.append(this.source.substring(this.lastPosition, end));
                this.lastPosition = end;
            }
        }
    }

    private void generateNodeSource(AstNode node) {
        if (node instanceof ExpressionStatement) {
            ExpressionStatement exprStmt = (ExpressionStatement)node;
            this.generateNodeSource(exprStmt.getExpression());
            if (!this.sb.toString().endsWith(";")) {
                this.sb.append(";");
            }
            this.sb.append("\n");
        } else if (node instanceof FunctionCall) {
            FunctionCall call = (FunctionCall)node;
            this.generateNodeSource(call.getTarget());
            this.sb.append("(");
            List arguments = call.getArguments();
            if (arguments != null) {
                for (int i = 0; i < arguments.size(); ++i) {
                    if (i > 0) {
                        this.sb.append(", ");
                    }
                    this.generateNodeSource((AstNode)arguments.get(i));
                }
            }
            this.sb.append(")");
        } else if (node instanceof PropertyGet) {
            PropertyGet prop = (PropertyGet)node;
            this.generateNodeSource(prop.getLeft());
            this.sb.append(".");
            this.generateNodeSource(prop.getRight());
        } else if (node instanceof Name) {
            Name name = (Name)node;
            this.sb.append(name.getIdentifier());
        } else if (node instanceof StringLiteral) {
            StringLiteral strLit = (StringLiteral)node;
            this.sb.append("\"").append(this.escapeString(strLit.getValue())).append("\"");
        } else if (node instanceof NumberLiteral) {
            NumberLiteral numLit = (NumberLiteral)node;
            this.sb.append(numLit.getValue());
        } else if (node instanceof Block) {
            Block block = (Block)node;
            this.sb.append(" {\n");
            for (Node child : block) {
                if (!(child instanceof AstNode)) continue;
                this.sb.append("    ");
                this.generateNodeSource((AstNode)child);
            }
            this.sb.append("}\n");
        } else if (node instanceof VariableDeclaration) {
            VariableDeclaration varDecl = (VariableDeclaration)node;
            switch (varDecl.getType()) {
                case 123: {
                    this.sb.append("var ");
                    break;
                }
                case 154: {
                    this.sb.append("let ");
                    break;
                }
                case 155: {
                    this.sb.append("const ");
                    break;
                }
                default: {
                    this.sb.append("var ");
                }
            }
            boolean first = true;
            for (VariableInitializer init : varDecl.getVariables()) {
                if (!first) {
                    this.sb.append(", ");
                }
                first = false;
                this.generateNodeSource((AstNode)init);
            }
            this.sb.append(";\n");
        } else if (node instanceof VariableInitializer) {
            VariableInitializer init = (VariableInitializer)node;
            this.generateNodeSource(init.getTarget());
            if (init.getInitializer() != null) {
                this.sb.append(" = ");
                this.generateNodeSource(init.getInitializer());
            }
        } else if (node instanceof AstRoot) {
            for (Node child : node) {
                if (!(child instanceof AstNode)) continue;
                this.generateNodeSource((AstNode)child);
            }
        }
    }

    private String escapeString(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private void handleAstRoot(AstRoot root) {
        for (AstNode child = (AstNode)root.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
            this.traverse(child);
        }
    }

    private void handleScope(Scope scope) {
        int actualEnd;
        int actualStart;
        int start = scope.getAbsolutePosition();
        int end = start + scope.getLength();
        if (start < 0 || end < 0 || start > this.source.length() || end > this.source.length()) {
            return;
        }
        if (start > this.lastPosition && this.lastPosition >= 0 && (actualStart = Math.max(0, this.lastPosition)) < (actualEnd = Math.min(start, this.source.length()))) {
            this.sb.append(this.source.substring(actualStart, actualEnd));
        }
        this.sb.append('{');
        this.lastPosition = Math.max(0, start + 1);
        for (AstNode child = (AstNode)scope.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
            this.traverse(child);
        }
        if (this.lastPosition >= 0 && this.lastPosition < end) {
            int actualEnd2;
            int actualStart2 = Math.max(0, this.lastPosition);
            String remaining = this.source.substring(actualStart2, actualEnd2 = Math.min(end, this.source.length()));
            if (remaining.contains("}")) {
                this.sb.append(remaining);
                this.lastPosition = actualEnd2;
            } else {
                this.sb.append('}');
                this.lastPosition = actualEnd2;
            }
        }
    }

    private void handleBlock(Block block) {
        int actualEnd;
        int actualStart;
        int start = block.getAbsolutePosition();
        int end = start + block.getLength();
        if (start < 0 || end < 0 || start > this.source.length() || end > this.source.length()) {
            this.sb.append(" {");
            for (AstNode child = (AstNode)block.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
                this.traverse(child);
            }
            this.sb.append("} ");
            return;
        }
        if (start > this.lastPosition && this.lastPosition >= 0 && (actualStart = Math.max(0, this.lastPosition)) < (actualEnd = Math.min(start, this.source.length()))) {
            this.sb.append(this.source.substring(actualStart, actualEnd));
        }
        this.sb.append('{');
        this.lastPosition = Math.max(0, start + 1);
        for (AstNode child = (AstNode)block.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
            this.traverse(child);
        }
        if (this.lastPosition >= 0 && this.lastPosition < end) {
            int actualEnd2;
            int actualStart2 = Math.max(0, this.lastPosition);
            String remaining = this.source.substring(actualStart2, actualEnd2 = Math.min(end, this.source.length()));
            if (remaining.contains("}")) {
                this.sb.append(remaining);
                this.lastPosition = actualEnd2;
            } else {
                this.sb.append('}');
                this.lastPosition = actualEnd2;
            }
        }
    }

    private void handleFunctionNode(FunctionNode func) {
        int actualEnd;
        int actualStart;
        int bodyStart;
        int actualEnd2;
        int actualStart2;
        int start = func.getAbsolutePosition();
        int end = start + func.getLength();
        if (start < 0 || end < 0 || start > this.source.length() || end > this.source.length()) {
            Name functionName = func.getFunctionName();
            if (functionName != null) {
                this.sb.append("function ").append(functionName.getIdentifier()).append("() ");
            } else {
                this.sb.append("function () ");
            }
            AstNode body = func.getBody();
            if (body != null) {
                this.traverse(body);
            }
            return;
        }
        if (start > this.lastPosition && this.lastPosition >= 0 && (actualStart2 = Math.max(0, this.lastPosition)) < (actualEnd2 = Math.min(start, this.source.length()))) {
            this.sb.append(this.source.substring(actualStart2, actualEnd2));
        }
        if ((bodyStart = this.findFunctionBodyStart(func)) > start && bodyStart <= this.source.length()) {
            this.sb.append(this.source.substring(start, bodyStart));
            this.lastPosition = bodyStart;
        } else {
            Name functionName = func.getFunctionName();
            if (functionName != null) {
                this.sb.append("function ").append(functionName.getIdentifier()).append("()");
            } else {
                this.sb.append("function ()");
            }
            this.lastPosition = start;
        }
        AstNode body = func.getBody();
        if (body != null && body instanceof Block) {
            this.handleBlockContentOnly((Block)body);
        }
        if (this.lastPosition >= 0 && this.lastPosition < end && (actualStart = Math.max(0, this.lastPosition)) < (actualEnd = Math.min(end, this.source.length()))) {
            this.sb.append(this.source.substring(actualStart, actualEnd));
            this.lastPosition = actualEnd;
        }
    }

    private void handleBlockContentOnly(Block block) {
        int actualEnd;
        int actualStart;
        int start = block.getAbsolutePosition();
        int end = start + block.getLength();
        if (start < 0 || end < 0 || start > this.source.length() || end > this.source.length()) {
            this.sb.append(" {");
            for (AstNode child = (AstNode)block.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
                if (child instanceof FunctionNode) continue;
                this.traverse(child);
            }
            this.sb.append("} ");
            return;
        }
        if (start > this.lastPosition && this.lastPosition >= 0 && (actualStart = Math.max(0, this.lastPosition)) < (actualEnd = Math.min(start, this.source.length()))) {
            this.sb.append(this.source.substring(actualStart, actualEnd));
        }
        this.sb.append('{');
        this.lastPosition = Math.max(0, start + 1);
        for (AstNode child = (AstNode)block.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
            if (child instanceof FunctionNode) continue;
            this.traverse(child);
        }
        if (this.lastPosition >= 0 && this.lastPosition < end) {
            int actualEnd2;
            int actualStart2 = Math.max(0, this.lastPosition);
            String remaining = this.source.substring(actualStart2, actualEnd2 = Math.min(end, this.source.length()));
            if (remaining.contains("}")) {
                this.sb.append(remaining);
                this.lastPosition = actualEnd2;
            } else {
                this.sb.append('}');
                this.lastPosition = actualEnd2;
            }
        }
    }

    private int findFunctionBodyStart(FunctionNode func) {
        int pos = func.getAbsolutePosition();
        if (pos < 0 || pos >= this.source.length()) {
            return func.getAbsolutePosition();
        }
        while (pos < this.source.length() && this.source.charAt(pos) != '{') {
            ++pos;
        }
        return pos < this.source.length() ? pos : func.getAbsolutePosition();
    }

    private void handleVariableDeclaration(VariableDeclaration decl) {
        int actualEnd;
        int actualStart;
        int declStart = decl.getAbsolutePosition();
        int declEnd = declStart + decl.getLength();
        if (declStart < 0 || declEnd < 0 || declStart > this.source.length() || declEnd > this.source.length()) {
            switch (decl.getType()) {
                case 123: {
                    this.sb.append("var ");
                    break;
                }
                case 154: {
                    this.sb.append("let ");
                    break;
                }
                case 155: {
                    this.sb.append("const ");
                    break;
                }
                default: {
                    this.sb.append("var ");
                }
            }
            boolean first = true;
            for (VariableInitializer varInit : decl.getVariables()) {
                if (!first) {
                    this.sb.append(", ");
                }
                first = false;
                this.generateNodeSource((AstNode)varInit);
            }
            return;
        }
        int keywordEnd = declStart;
        AstNode firstChild = (AstNode)decl.getFirstChild();
        if (firstChild != null) {
            keywordEnd = firstChild.getAbsolutePosition();
        }
        if (declStart < keywordEnd && keywordEnd <= this.source.length()) {
            this.sb.append(this.source.substring(declStart, keywordEnd));
            this.lastPosition = keywordEnd;
        }
        boolean first = true;
        for (AstNode child = (AstNode)decl.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
            if (!(child instanceof VariableInitializer)) continue;
            if (!first) {
                this.sb.append(", ");
            }
            first = false;
            this.traverse(child);
        }
        if (this.lastPosition >= 0 && this.lastPosition < declEnd && (actualStart = Math.max(0, this.lastPosition)) < (actualEnd = Math.min(declEnd, this.source.length()))) {
            this.sb.append(this.source.substring(actualStart, actualEnd));
            this.lastPosition = actualEnd;
        }
    }

    private void handleExpressionStatement(ExpressionStatement stmt) {
        int stmtStart = stmt.getAbsolutePosition();
        int stmtEnd = stmtStart + stmt.getLength();
        if (stmtStart < 0 || stmtEnd < 0 || stmtStart > this.source.length() || stmtEnd > this.source.length()) {
            this.generateNodeSource(stmt.getExpression());
            this.sb.append(";");
            return;
        }
        this.traverse(stmt.getExpression());
        if (stmtEnd > 0 && stmtEnd <= this.source.length() && this.lastPosition >= 0 && this.lastPosition < stmtEnd) {
            int actualEnd;
            int actualStart = Math.max(0, this.lastPosition);
            String trailing = this.source.substring(actualStart, actualEnd = Math.min(stmtEnd, this.source.length()));
            if (!trailing.trim().endsWith(";")) {
                this.sb.append(';');
                this.lastPosition = actualEnd;
            } else {
                this.sb.append(trailing);
                this.lastPosition = actualEnd;
            }
        }
    }

    public void printAst(AstNode root) {
        this.printAstRecursive(root, 0);
    }

    private void printAstRecursive(AstNode node, int depth) {
        if (node == null) {
            return;
        }
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            indent.append("  ");
        }
        System.out.print(indent + node.getClass().getSimpleName());
        System.out.print(" [pos=" + node.getAbsolutePosition());
        System.out.print(", len=" + node.getLength());
        if (node instanceof FunctionNode) {
            FunctionNode func = (FunctionNode)node;
            Name functionName = func.getFunctionName();
            if (functionName != null) {
                System.out.print(", name=" + functionName.getIdentifier());
            }
            System.out.print(", args=" + func.getParams());
        } else if (node instanceof VariableDeclaration) {
            VariableDeclaration var = (VariableDeclaration)node;
            System.out.print(", vars=" + var.getVariables());
        }
        System.out.println("]");
        for (AstNode child = (AstNode)node.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
            this.printAstRecursive(child, depth + 1);
        }
    }

    public List<AstNode> findFunctionNodesByName(AstNode root, String functionName) {
        ArrayList<AstNode> result = new ArrayList<AstNode>();
        this.findFunctionsRecursive(root, functionName, result);
        return result;
    }

    private void findFunctionsRecursive(AstNode node, String targetName, List<AstNode> result) {
        FunctionNode func;
        Name functionName;
        if (node == null) {
            return;
        }
        if (node instanceof FunctionNode && (functionName = (func = (FunctionNode)node).getFunctionName()) != null && targetName.equals(functionName.getIdentifier())) {
            result.add(node);
        }
        for (AstNode child = (AstNode)node.getFirstChild(); child != null; child = (AstNode)child.getNext()) {
            this.findFunctionsRecursive(child, targetName, result);
        }
    }

    public String convertAndFix(AstRoot root, String injectCode) {
        String result = this.convert(root);
        result = result.replace("var InjectCode = KubeLoader", injectCode);
        return result;
    }
}

