/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixinjs.ast;

import com.whisent.kubeloader.mixinjs.dsl.EventProbeTextProcessor;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSL;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Node;
import dev.latvian.mods.rhino.Parser;
import dev.latvian.mods.rhino.ast.AstNode;
import dev.latvian.mods.rhino.ast.AstRoot;
import dev.latvian.mods.rhino.ast.Block;
import dev.latvian.mods.rhino.ast.EmptyExpression;
import dev.latvian.mods.rhino.ast.ExpressionStatement;
import dev.latvian.mods.rhino.ast.FunctionCall;
import dev.latvian.mods.rhino.ast.FunctionNode;
import dev.latvian.mods.rhino.ast.Name;
import dev.latvian.mods.rhino.ast.PropertyGet;
import dev.latvian.mods.rhino.ast.VariableDeclaration;
import java.util.ArrayList;
import java.util.List;

public class JSInjector {
    private String te = "const InjectCode = KubeLoader";

    public static void injectFromDSL(AstRoot root, MixinDSL dsl) {
        String type = dsl.getType();
        if ("EventSubscription".equals(type)) {
            JSInjector.injectForEventSubscribe(root, dsl);
            return;
        }
        if ("EventProbe".equals(type)) {
            JSInjector.injectForEventProbe(root, dsl);
            return;
        }
        String position = dsl.getAt();
        if (position == null) {
            dsl.getFile().pack.manager.scriptType.console.error((Object)("Unknown injection position for DSL: " + dsl));
            return;
        }
        switch (position) {
            case "head": {
                JSInjector.injectAtFunctionHead(root, dsl.getTarget(), dsl.getAction());
                break;
            }
            case "tail": {
                JSInjector.injectAtFunctionTail(root, dsl.getTarget(), dsl.getAction());
                break;
            }
            default: {
                dsl.getFile().pack.manager.scriptType.console.error((Object)("Unknown injection position for DSL: " + dsl));
            }
        }
    }

    public static void injectForEventSubscribe(AstRoot root, MixinDSL dsl) {
        String targetEvent = dsl.getTarget();
        String injectCode = dsl.getAction();
        String position = dsl.getAt();
        JSInjector.injectAtEventSubscribe(root, targetEvent, injectCode, position);
    }

    public static void injectForEventProbe(AstRoot root, MixinDSL dsl) {
        String targetEvent = dsl.getTarget();
        String injectCode = dsl.getAction();
        String position = dsl.getAt();
        JSInjector.injectAtEventSubscribe(root, targetEvent, injectCode, position);
    }

    public static void injectAtEventSubscribe(AstRoot root, String eventName, String injectCode, String position) {
        List<AstNode> injectNodes;
        List<FunctionCall> targetCalls = JSInjector.findEventSubscribeCalls(root, eventName);
        if (!targetCalls.isEmpty() && !(injectNodes = JSInjector.parseCodeToNodes(injectCode)).isEmpty()) {
            for (FunctionCall targetCall : targetCalls) {
                Block targetBlock;
                AstNode callbackFunction = JSInjector.getEventCallbackFunction(targetCall);
                if (callbackFunction == null || (targetBlock = JSInjector.getTargetBlock(callbackFunction)) == null) continue;
                if ("head".equals(position)) {
                    for (int i = injectNodes.size() - 1; i >= 0; --i) {
                        AstNode nodeCopy = JSInjector.copyNode(injectNodes.get(i));
                        nodeCopy.setPosition(-1);
                        nodeCopy.setLength(0);
                        targetBlock.addChildToFront((Node)nodeCopy);
                    }
                    continue;
                }
                if (!"tail".equals(position)) continue;
                for (AstNode node : injectNodes) {
                    AstNode nodeCopy = JSInjector.copyNode(node);
                    nodeCopy.setPosition(-1);
                    nodeCopy.setLength(0);
                    targetBlock.addChildToBack((Node)nodeCopy);
                }
            }
        }
    }

    private static List<FunctionCall> findEventSubscribeCalls(AstRoot root, String eventName) {
        ArrayList<FunctionCall> calls = new ArrayList<FunctionCall>();
        for (Node child : root) {
            if (!(child instanceof AstNode)) continue;
            JSInjector.findEventSubscribeCallsRecursive((AstNode)child, eventName, calls);
        }
        return calls;
    }

    private static void findEventSubscribeCallsRecursive(AstNode node, String eventName, List<FunctionCall> calls) {
        FunctionCall call;
        AstNode target;
        String fullEventName;
        ExpressionStatement exprStmt;
        AstNode expression;
        FunctionCall call2;
        AstNode target2;
        String fullEventName2;
        if (node instanceof FunctionCall && (fullEventName2 = JSInjector.getFullEventName(target2 = (call2 = (FunctionCall)node).getTarget())) != null && eventName.equals(fullEventName2)) {
            calls.add(call2);
        }
        if (node instanceof ExpressionStatement && (expression = (exprStmt = (ExpressionStatement)node).getExpression()) instanceof FunctionCall && (fullEventName = JSInjector.getFullEventName(target = (call = (FunctionCall)expression).getTarget())) != null && eventName.equals(fullEventName)) {
            calls.add(call);
        }
        for (Node child : node) {
            if (!(child instanceof AstNode)) continue;
            JSInjector.findEventSubscribeCallsRecursive((AstNode)child, eventName, calls);
        }
    }

    private static String getFullEventName(AstNode node) {
        if (node instanceof PropertyGet) {
            PropertyGet propertyGet = (PropertyGet)node;
            AstNode left = propertyGet.getLeft();
            AstNode right = propertyGet.getRight();
            String leftName = JSInjector.getFullEventName(left);
            String rightName = JSInjector.getFullEventName(right);
            if (leftName != null && rightName != null) {
                return leftName + "." + rightName;
            }
            if (leftName != null) {
                return leftName;
            }
            if (rightName != null) {
                return rightName;
            }
        } else {
            if (node instanceof Name) {
                return ((Name)node).getIdentifier();
            }
            if (node instanceof FunctionCall) {
                FunctionCall call = (FunctionCall)node;
                return JSInjector.getFullEventName(call.getTarget());
            }
        }
        return null;
    }

    private static AstNode getEventCallbackFunction(FunctionCall call) {
        List arguments = call.getArguments();
        System.out.println("\u4e8b\u4ef6\u8c03\u7528\u53c2\u6570\u6570\u91cf: " + arguments.size());
        if (!arguments.isEmpty()) {
            AstNode callback = (AstNode)arguments.get(arguments.size() - 1);
            System.out.println("\u56de\u8c03\u51fd\u6570\u7c7b\u578b: " + callback.getClass().getSimpleName());
            if (callback instanceof FunctionNode) {
                return callback;
            }
            return callback;
        }
        return null;
    }

    private static Block getTargetBlock(AstNode node) {
        if (node instanceof Block) {
            return (Block)node;
        }
        if (node instanceof FunctionNode) {
            AstNode body = ((FunctionNode)node).getBody();
            if (body instanceof Block) {
                return (Block)body;
            }
            if (body != null) {
                System.out.println("\u51fd\u6570\u4f53\u7c7b\u578b: " + body.getClass().getSimpleName());
                Block block = new Block();
                block.addChild(body);
                return block;
            }
        }
        return null;
    }

    private static AstNode copyNode(AstNode node) {
        if (node instanceof ExpressionStatement) {
            ExpressionStatement original = (ExpressionStatement)node;
            ExpressionStatement copy = new ExpressionStatement();
            copy.setExpression(original.getExpression());
            copy.setLength(original.getLength());
            copy.setPosition(original.getPosition());
            return copy;
        }
        if (node instanceof VariableDeclaration) {
            VariableDeclaration original = (VariableDeclaration)node;
            VariableDeclaration copy = new VariableDeclaration();
            copy.setVariables(original.getVariables());
            copy.setLength(original.getLength());
            copy.setPosition(original.getPosition());
            return copy;
        }
        return node;
    }

    public static void injectAtFunctionHead(AstRoot root, String functionName, String injectCode) {
        System.out.println("\u5c1d\u8bd5\u5728\u51fd\u6570 " + functionName + " \u5f00\u5934\u6ce8\u5165\u4ee3\u7801: " + injectCode);
        FunctionNode targetFunction = JSInjector.findFunctionByName((AstNode)root, functionName);
        if (targetFunction != null) {
            System.out.println("\u627e\u5230\u76ee\u6807\u51fd\u6570: " + functionName);
            List<AstNode> injectNodes = JSInjector.parseCodeToNodes(injectCode);
            System.out.println("\u89e3\u6790\u51fa " + injectNodes.size() + " \u4e2a\u8282\u70b9");
            if (!injectNodes.isEmpty()) {
                AstNode functionBody = targetFunction.getBody();
                System.out.println("\u51fd\u6570\u4f53\u7c7b\u578b: " + functionBody.getClass().getSimpleName());
                if (functionBody instanceof Block) {
                    Block block = (Block)functionBody;
                    for (int i = injectNodes.size() - 1; i >= 0; --i) {
                        System.out.println("\u6dfb\u52a0\u8282\u70b9: " + injectNodes.get(i).getClass().getSimpleName());
                        AstNode nodeCopy = JSInjector.copyNode(injectNodes.get(i));
                        nodeCopy.setPosition(-1);
                        nodeCopy.setLength(0);
                        block.addChildToFront((Node)nodeCopy);
                    }
                    System.out.println("\u6210\u529f\u5728\u51fd\u6570 " + functionName + " \u5f00\u5934\u6ce8\u5165\u4ee3\u7801");
                } else {
                    System.out.println("\u51fd\u6570\u4f53\u4e0d\u662fBlock\u7c7b\u578b");
                }
            } else {
                System.out.println("\u6ca1\u6709\u89e3\u6790\u51fa\u4efb\u4f55\u8282\u70b9");
            }
        } else {
            System.out.println("\u672a\u627e\u5230\u51fd\u6570: " + functionName);
        }
    }

    public static void injectAtFunctionTail(AstRoot root, String functionName, String injectCode) {
        FunctionNode targetFunction = JSInjector.findFunctionByName((AstNode)root, functionName);
        if (targetFunction != null) {
            AstNode functionBody;
            List<AstNode> injectNodes = JSInjector.parseCodeToNodes(injectCode);
            if (!injectNodes.isEmpty() && (functionBody = targetFunction.getBody()) instanceof Block) {
                for (AstNode node : injectNodes) {
                    AstNode nodeCopy = JSInjector.copyNode(node);
                    nodeCopy.setPosition(-1);
                    nodeCopy.setLength(0);
                    ((Block)functionBody).addChildToBack((Node)nodeCopy);
                }
                System.out.println("\u6210\u529f\u5728\u51fd\u6570 " + functionName + " \u672b\u5c3e\u6ce8\u5165\u4ee3\u7801: " + injectCode);
            }
        } else {
            System.out.println("\u672a\u627e\u5230\u51fd\u6570: " + functionName);
        }
    }

    private static FunctionNode findFunctionByName(AstNode node, String functionName) {
        FunctionNode function;
        Name functionNameNode;
        if (node instanceof FunctionNode && (functionNameNode = (function = (FunctionNode)node).getFunctionName()) != null && functionName.equals(functionNameNode.getIdentifier())) {
            return function;
        }
        for (Node child : node) {
            FunctionNode result;
            if (!(child instanceof AstNode) || (result = JSInjector.findFunctionByName((AstNode)child, functionName)) == null) continue;
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<AstNode> parseCodeToNodes(String code) {
        ArrayList<AstNode> nodes = new ArrayList<AstNode>();
        if (code == null || code.trim().isEmpty()) {
            System.out.println("\u6ce8\u5165\u4ee3\u7801\u4e3a\u7a7a");
            return nodes;
        }
        if (code.trim().startsWith("{")) {
            try {
                Context context = Context.enter();
                Parser parser = new Parser(context);
                AstRoot root = parser.parse(code, "<inject>", 1);
                for (Node node : root) {
                    if (!(node instanceof AstNode)) continue;
                    nodes.add((AstNode)node);
                }
                System.out.println("\u6210\u529f\u89e3\u6790\u51fd\u6570\u4f53\u4ee3\u7801\uff0c\u63d0\u53d6\u51fa " + nodes.size() + " \u4e2a\u8282\u70b9");
                ArrayList<AstNode> arrayList = nodes;
                return arrayList;
            }
            catch (Exception e) {
                System.err.println("\u89e3\u6790\u51fd\u6570\u4f53\u4ee3\u7801\u5931\u8d25: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if ("const InjectCode = KubeLoader".equals(code.trim())) {
            try {
                Context context = Context.enter();
                Parser parser = new Parser(context);
                AstRoot root = parser.parse("const InjectCode = KubeLoader;", "<inject>", 1);
                for (Node node : root) {
                    if (!(node instanceof AstNode)) continue;
                    nodes.add((AstNode)node);
                }
                System.out.println("\u6210\u529f\u89e3\u6790\u5360\u4f4d\u7b26\u4ee3\u7801\uff0c\u63d0\u53d6\u51fa " + nodes.size() + " \u4e2a\u8282\u70b9");
                ArrayList<AstNode> arrayList = nodes;
                return arrayList;
            }
            catch (Exception e) {
                System.err.println("\u89e3\u6790\u5360\u4f4d\u7b26\u4ee3\u7801\u5931\u8d25: " + e.getMessage());
                e.printStackTrace();
            }
        }
        Context context = null;
        try {
            context = Context.enter();
            Parser parser = new Parser(context);
            AstRoot root = parser.parse(code, "<inject>", 1);
            for (Node node : root) {
                if (!(node instanceof AstNode)) continue;
                nodes.add((AstNode)node);
            }
            System.out.println("\u6210\u529f\u89e3\u6790\u4ee3\u7801\uff0c\u63d0\u53d6\u51fa " + nodes.size() + " \u4e2a\u8282\u70b9");
        }
        catch (Exception e) {
            System.err.println("\u76f4\u63a5\u89e3\u6790\u4ee3\u7801\u5931\u8d25: " + e.getMessage());
            try {
                AstNode body;
                String wrappedCode;
                Parser parser;
                AstRoot root;
                FunctionNode wrapperFunction;
                if (context == null) {
                    context = Context.enter();
                }
                if ((wrapperFunction = JSInjector.findFirstFunction((AstNode)(root = (parser = new Parser(context)).parse(wrappedCode = "(function() { " + code + " })", "<inject>", 1)))) != null && (body = wrapperFunction.getBody()) instanceof Block) {
                    for (Node stmtNode : body) {
                        if (!(stmtNode instanceof AstNode)) continue;
                        nodes.add((AstNode)stmtNode);
                    }
                }
                System.out.println("\u6210\u529f\u4f7f\u7528\u5305\u88c5\u51fd\u6570\u89e3\u6790\u4ee3\u7801\uff0c\u63d0\u53d6\u51fa " + nodes.size() + " \u4e2a\u8282\u70b9");
            }
            catch (Exception ex) {
                System.err.println("\u5305\u88c5\u51fd\u6570\u89e3\u6790\u4e5f\u5931\u8d25: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return nodes;
    }

    private static FunctionNode findFirstFunction(AstNode root) {
        if (root instanceof FunctionNode) {
            return (FunctionNode)root;
        }
        for (Node child : root) {
            if (!(child instanceof AstNode)) continue;
            if (child instanceof FunctionNode) {
                return (FunctionNode)child;
            }
            FunctionNode result = JSInjector.findFirstFunction((AstNode)child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String toSource(AstRoot root) {
        StringBuilder code = new StringBuilder();
        try {
            for (Node node : root) {
                if (!(node instanceof AstNode)) continue;
                AstNode astNode = (AstNode)node;
                try {
                    String nodeSource = astNode.getString();
                    code.append(nodeSource);
                    if (!(nodeSource.trim().endsWith(";") || nodeSource.trim().endsWith("}") || astNode instanceof FunctionNode || astNode instanceof EmptyExpression)) {
                        code.append(";");
                    }
                    code.append("\n");
                }
                catch (Exception e) {
                    code.append("/* \u65e0\u6cd5\u8f6c\u6362\u8282\u70b9: ").append(astNode.getClass().getSimpleName()).append(" */\n");
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u8f6c\u6362\u6e90\u4ee3\u7801\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
            return root.getString();
        }
        return code.toString();
    }

    public static String injectAndGetSource(AstRoot root, MixinDSL dsl) {
        JSInjector.injectFromDSL(root, dsl);
        return JSInjector.toSource(root);
    }

    public static String injectUsingEventProbe(String sourceCode, String eventName, String position, String injectCode) {
        System.out.println("\u4f7f\u7528EventProbe\u5904\u7406\u6e90\u4ee3\u7801\u6ce8\u5165");
        System.out.println("\u4e8b\u4ef6\u540d\u79f0: " + eventName);
        System.out.println("\u6ce8\u5165\u4f4d\u7f6e: " + position);
        System.out.println("\u6ce8\u5165\u4ee3\u7801: " + injectCode);
        return EventProbeTextProcessor.injectEventProbe(sourceCode, eventName, position, injectCode);
    }
}

