/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixinjs.dsl;

import com.whisent.kubeloader.mixinjs.dsl.EventProbeDSL;
import com.whisent.kubeloader.mixinjs.dsl.EventProbeLexer;
import java.util.ArrayList;
import java.util.List;

public class EventProbeDSLParser {
    private final List<EventProbeLexer.Token> tokens;
    private int position;

    public EventProbeDSLParser(List<EventProbeLexer.Token> tokens) {
        this.tokens = tokens;
        this.position = 0;
    }

    public static List<EventProbeDSL> parse(String source) {
        EventProbeLexer lexer = new EventProbeLexer(source);
        List<EventProbeLexer.Token> tokens = lexer.tokenize();
        EventProbeDSLParser parser = new EventProbeDSLParser(tokens);
        return parser.parse();
    }

    public List<EventProbeDSL> parse() {
        ArrayList<EventProbeDSL> result = new ArrayList<EventProbeDSL>();
        while (this.position < this.tokens.size() && this.currentToken().type != EventProbeLexer.TokenType.EOF) {
            if (this.currentToken().type == EventProbeLexer.TokenType.EVENT_PROBE_KEYWORD) {
                EventProbeDSL dsl = this.parseEventProbeDSL();
                if (dsl == null) continue;
                result.add(dsl);
                continue;
            }
            ++this.position;
        }
        return result;
    }

    private EventProbeDSL parseEventProbeDSL() {
        if (!this.match(EventProbeLexer.TokenType.EVENT_PROBE_KEYWORD)) {
            return null;
        }
        EventProbeDSL dsl = new EventProbeDSL();
        if (!this.match(EventProbeLexer.TokenType.DOT)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.IDENTIFIER) || !"on".equals(this.currentToken((int)-1).value)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.LEFT_PAREN)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.STRING_LITERAL)) {
            return null;
        }
        dsl.setEventName(this.currentToken((int)-1).value);
        if (!this.match(EventProbeLexer.TokenType.RIGHT_PAREN)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.DOT)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.IDENTIFIER) || !"at".equals(this.currentToken((int)-1).value)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.LEFT_PAREN)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.STRING_LITERAL)) {
            return null;
        }
        dsl.setPosition(this.currentToken((int)-1).value);
        if (!this.match(EventProbeLexer.TokenType.RIGHT_PAREN)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.DOT)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.IDENTIFIER) || !"inject".equals(this.currentToken((int)-1).value)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.LEFT_PAREN)) {
            return null;
        }
        String functionBody = this.parseFunctionDeclaration();
        if (functionBody == null) {
            return null;
        }
        dsl.setFunctionBody(functionBody);
        if (!this.match(EventProbeLexer.TokenType.RIGHT_PAREN)) {
            return null;
        }
        return dsl;
    }

    private String parseFunctionDeclaration() {
        if (!this.match(EventProbeLexer.TokenType.FUNCTION_KEYWORD)) {
            return null;
        }
        if (this.currentToken().type == EventProbeLexer.TokenType.IDENTIFIER) {
            this.match(EventProbeLexer.TokenType.IDENTIFIER);
        }
        if (!this.match(EventProbeLexer.TokenType.LEFT_PAREN)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.RIGHT_PAREN)) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.LEFT_BRACE)) {
            return null;
        }
        StringBuilder functionBody = new StringBuilder();
        int braceCount = 1;
        int startPos = this.position;
        while (this.position < this.tokens.size() && braceCount > 0) {
            EventProbeLexer.Token token = this.currentToken();
            if (token.type == EventProbeLexer.TokenType.LEFT_BRACE) {
                ++braceCount;
            } else if (token.type == EventProbeLexer.TokenType.RIGHT_BRACE && --braceCount == 0) break;
            ++this.position;
        }
        if (braceCount != 0) {
            return null;
        }
        if (!this.match(EventProbeLexer.TokenType.RIGHT_BRACE)) {
            return null;
        }
        return this.extractFunctionBody(startPos);
    }

    private String extractFunctionBody(int startPos) {
        if (startPos >= this.position - 1) {
            return "";
        }
        EventProbeLexer.Token startToken = this.tokens.get(startPos);
        EventProbeLexer.Token endToken = this.tokens.get(this.position - 1);
        return "/* function body */";
    }

    private boolean match(EventProbeLexer.TokenType expectedType) {
        if (this.position < this.tokens.size() && this.currentToken().type == expectedType) {
            ++this.position;
            return true;
        }
        return false;
    }

    private EventProbeLexer.Token currentToken() {
        if (this.position < this.tokens.size()) {
            return this.tokens.get(this.position);
        }
        return new EventProbeLexer.Token(EventProbeLexer.TokenType.EOF, "", this.position);
    }

    private EventProbeLexer.Token currentToken(int offset) {
        int pos = this.position + offset;
        if (pos >= 0 && pos < this.tokens.size()) {
            return this.tokens.get(pos);
        }
        return new EventProbeLexer.Token(EventProbeLexer.TokenType.EOF, "", pos);
    }
}

