/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixinjs.dsl;

import java.util.ArrayList;
import java.util.List;

public class EventProbeLexer {
    private final String input;
    private int position;

    public EventProbeLexer(String input) {
        this.input = input;
        this.position = 0;
    }

    public List<Token> tokenize() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (this.position < this.input.length()) {
            Token token = this.nextToken();
            if (token.type == TokenType.WHITESPACE) continue;
            tokens.add(token);
        }
        tokens.add(new Token(TokenType.EOF, "", this.position));
        return tokens;
    }

    private Token nextToken() {
        if (this.position >= this.input.length()) {
            return new Token(TokenType.EOF, "", this.position);
        }
        char ch = this.input.charAt(this.position);
        int startPos = this.position;
        if (this.position < this.input.length() - 1) {
            char nextCh = this.input.charAt(this.position + 1);
            if (ch == '=' && nextCh == '>') {
                this.position += 2;
                return new Token(TokenType.ARROW_OPERATOR, "=>", startPos);
            }
        }
        switch (ch) {
            case '.': {
                ++this.position;
                return new Token(TokenType.DOT, ".", startPos);
            }
            case '(': {
                ++this.position;
                return new Token(TokenType.LEFT_PAREN, "(", startPos);
            }
            case ')': {
                ++this.position;
                return new Token(TokenType.RIGHT_PAREN, ")", startPos);
            }
            case '{': {
                ++this.position;
                return new Token(TokenType.LEFT_BRACE, "{", startPos);
            }
            case '}': {
                ++this.position;
                return new Token(TokenType.RIGHT_BRACE, "}", startPos);
            }
            case ',': {
                ++this.position;
                return new Token(TokenType.COMMA, ",", startPos);
            }
            case ';': {
                ++this.position;
                return new Token(TokenType.SEMICOLON, ";", startPos);
            }
            case '=': {
                ++this.position;
                return new Token(TokenType.EQUAL, "=", startPos);
            }
            case '>': {
                ++this.position;
                return new Token(TokenType.GREATER_THAN, ">", startPos);
            }
            case '\'': {
                return this.readStringLiteral(startPos);
            }
            case '\"': {
                return this.readStringLiteral(startPos);
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return this.readWhitespace(startPos);
            }
        }
        if (Character.isLetter(ch) || ch == '_') {
            return this.readIdentifierOrKeyword(startPos);
        }
        ++this.position;
        return new Token(TokenType.UNKNOWN, String.valueOf(ch), startPos);
    }

    private Token readStringLiteral(int startPos) {
        StringBuilder sb = new StringBuilder();
        char quoteChar = this.input.charAt(startPos);
        ++this.position;
        while (this.position < this.input.length() && this.input.charAt(this.position) != quoteChar) {
            sb.append(this.input.charAt(this.position));
            ++this.position;
        }
        if (this.position < this.input.length()) {
            ++this.position;
        }
        return new Token(TokenType.STRING_LITERAL, sb.toString(), startPos);
    }

    private Token readWhitespace(int startPos) {
        StringBuilder sb = new StringBuilder();
        while (this.position < this.input.length() && (this.input.charAt(this.position) == ' ' || this.input.charAt(this.position) == '\t' || this.input.charAt(this.position) == '\r' || this.input.charAt(this.position) == '\n')) {
            sb.append(this.input.charAt(this.position));
            ++this.position;
        }
        return new Token(TokenType.WHITESPACE, sb.toString(), startPos);
    }

    private Token readIdentifierOrKeyword(int startPos) {
        StringBuilder sb = new StringBuilder();
        while (this.position < this.input.length() && (Character.isLetterOrDigit(this.input.charAt(this.position)) || this.input.charAt(this.position) == '_')) {
            sb.append(this.input.charAt(this.position));
            ++this.position;
        }
        String identifier = sb.toString();
        if ("EventProbe".equals(identifier)) {
            return new Token(TokenType.EVENT_PROBE_KEYWORD, identifier, startPos);
        }
        if ("function".equals(identifier)) {
            return new Token(TokenType.FUNCTION_KEYWORD, identifier, startPos);
        }
        return new Token(TokenType.IDENTIFIER, identifier, startPos);
    }

    public static class Token {
        public final TokenType type;
        public final String value;
        public final int position;

        public Token(TokenType type, String value, int position) {
            this.type = type;
            this.value = value;
            this.position = position;
        }

        public String toString() {
            return "Token{type=" + this.type + ", value='" + this.value + "', position=" + this.position + "}";
        }
    }

    public static enum TokenType {
        EVENT_PROBE_KEYWORD,
        DOT,
        IDENTIFIER,
        STRING_LITERAL,
        LEFT_PAREN,
        RIGHT_PAREN,
        LEFT_BRACE,
        RIGHT_BRACE,
        FUNCTION_KEYWORD,
        COMMA,
        EQUAL,
        GREATER_THAN,
        ARROW_OPERATOR,
        SEMICOLON,
        FUNCTION_BODY,
        WHITESPACE,
        EOF,
        UNKNOWN;

    }
}

