/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixinjs.dsl;

import com.whisent.kubeloader.mixinjs.dsl.EventProbeDSL;
import com.whisent.kubeloader.mixinjs.dsl.EventProbeLexer;
import com.whisent.kubeloader.utils.Debugger;
import java.util.List;

public class EventProbeTextProcessor {
    public static String injectEventProbe(String sourceCode, String eventName, int targetLocation, String position, String functionBody) {
        Debugger.out("\u5e94\u7528DSL: " + eventName + " \u5728\u4f4d\u7f6e " + targetLocation + " " + position + " \u6ce8\u5165 " + functionBody);
        EventProbeLexer lexer = new EventProbeLexer(sourceCode);
        List<EventProbeLexer.Token> tokens = lexer.tokenize();
        Debugger.out("\u8bcd\u6cd5\u5206\u6790\u5b8c\u6210\uff0c\u751f\u6210\u7684token\u6570\u91cf: " + (tokens.size() - 1));
        for (EventProbeLexer.Token token : tokens) {
            if (token.type == EventProbeLexer.TokenType.EOF) continue;
            Debugger.out("Token: " + token);
        }
        int eventStartIndex = EventProbeTextProcessor.findEventSubscription(tokens, eventName, targetLocation);
        if (eventStartIndex == -1) {
            Debugger.out("\u672a\u627e\u5230\u4e8b\u4ef6\u8ba2\u9605: " + eventName + " \u4f4d\u7f6e: " + targetLocation);
            return sourceCode;
        }
        Debugger.out("\u627e\u5230\u4e8b\u4ef6\u8ba2\u9605\uff0c\u8d77\u59cb\u4f4d\u7f6e: " + eventStartIndex);
        int leftParenIndex = EventProbeTextProcessor.findLeftParen(tokens, eventStartIndex);
        if (leftParenIndex == -1) {
            Debugger.out("\u672a\u627e\u5230\u5de6\u62ec\u53f7");
            return sourceCode;
        }
        Debugger.out("\u627e\u5230\u5de6\u62ec\u53f7\uff0c\u4f4d\u7f6e: " + leftParenIndex);
        int arrowIndex = EventProbeTextProcessor.findArrowOperator(tokens, leftParenIndex);
        if (arrowIndex == -1) {
            Debugger.out("\u672a\u627e\u5230\u7bad\u5934\u64cd\u4f5c\u7b26");
            return sourceCode;
        }
        Debugger.out("\u627e\u5230\u7bad\u5934\u64cd\u4f5c\u7b26\uff0c\u4f4d\u7f6e: " + arrowIndex);
        int braceIndex = EventProbeTextProcessor.findOpenBrace(tokens, arrowIndex);
        if (braceIndex == -1) {
            Debugger.out("\u672a\u627e\u5230\u5f00\u5927\u62ec\u53f7");
            return sourceCode;
        }
        Debugger.out("\u627e\u5230\u5f00\u5927\u62ec\u53f7\uff0c\u4f4d\u7f6e: " + braceIndex);
        int closeBraceIndex = EventProbeTextProcessor.findMatchingCloseBrace(tokens, braceIndex);
        if (closeBraceIndex == -1) {
            Debugger.out("\u672a\u627e\u5230\u5339\u914d\u7684\u95ed\u5927\u62ec\u53f7");
            return sourceCode;
        }
        Debugger.out("\u627e\u5230\u5339\u914d\u7684\u95ed\u5927\u62ec\u53f7\uff0c\u4f4d\u7f6e: " + closeBraceIndex);
        return EventProbeTextProcessor.rebuildCodeWithInjection(sourceCode, tokens, braceIndex, closeBraceIndex, position, functionBody);
    }

    public static int findEventSubscription(List<EventProbeLexer.Token> tokens, String eventName, int targetLocation) {
        if (eventName == null || eventName.isEmpty()) {
            return -1;
        }
        String[] eventParts = eventName.split("\\.");
        int foundCount = 0;
        for (int i = 0; i < tokens.size() - eventParts.length; ++i) {
            boolean match = true;
            for (int j = 0; j < eventParts.length; ++j) {
                EventProbeLexer.Token token = tokens.get(i + j * 2);
                if (token.type != EventProbeLexer.TokenType.IDENTIFIER || !eventParts[j].equals(token.value)) {
                    match = false;
                    break;
                }
                if (j >= eventParts.length - 1) continue;
                EventProbeLexer.Token dotToken = tokens.get(i + j * 2 + 1);
                if (dotToken.type == EventProbeLexer.TokenType.DOT) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (foundCount == targetLocation) {
                return i;
            }
            ++foundCount;
        }
        return -1;
    }

    public static String injectEventProbe(String sourceCode, String eventName, String position, String functionBody) {
        return EventProbeTextProcessor.injectEventProbe(sourceCode, eventName, 0, position, functionBody);
    }

    private static int findLeftParen(List<EventProbeLexer.Token> tokens, int startIndex) {
        for (int i = startIndex; i < tokens.size() - 1; ++i) {
            EventProbeLexer.Token token = tokens.get(i);
            if (token.type != EventProbeLexer.TokenType.LEFT_PAREN) continue;
            return i;
        }
        return -1;
    }

    private static int findArrowOperator(List<EventProbeLexer.Token> tokens, int startIndex) {
        for (int i = startIndex; i < tokens.size() - 1; ++i) {
            EventProbeLexer.Token token = tokens.get(i);
            if (token.type == EventProbeLexer.TokenType.ARROW_OPERATOR && "=>".equals(token.value)) {
                return i;
            }
            if (token.type != EventProbeLexer.TokenType.RIGHT_PAREN) continue;
        }
        return -1;
    }

    private static int findOpenBrace(List<EventProbeLexer.Token> tokens, int startIndex) {
        for (int i = startIndex; i < tokens.size() - 1; ++i) {
            EventProbeLexer.Token token = tokens.get(i);
            if (token.type != EventProbeLexer.TokenType.LEFT_BRACE) continue;
            return i;
        }
        return -1;
    }

    private static int findMatchingCloseBrace(List<EventProbeLexer.Token> tokens, int openBraceIndex) {
        int braceCount = 1;
        for (int i = openBraceIndex + 1; i < tokens.size() - 1; ++i) {
            EventProbeLexer.Token token = tokens.get(i);
            if (token.type == EventProbeLexer.TokenType.LEFT_BRACE) {
                ++braceCount;
                continue;
            }
            if (token.type != EventProbeLexer.TokenType.RIGHT_BRACE || --braceCount != 0) continue;
            return i;
        }
        return -1;
    }

    private static String rebuildCodeWithInjection(String sourceCode, List<EventProbeLexer.Token> tokens, int openBraceIndex, int closeBraceIndex, String position, String functionBody) {
        EventProbeLexer.Token openBraceToken = tokens.get(openBraceIndex);
        EventProbeLexer.Token closeBraceToken = tokens.get(closeBraceIndex);
        int openBraceEnd = openBraceToken.position + 1;
        int closeBraceStart = closeBraceToken.position;
        String beforeCode = sourceCode.substring(0, openBraceEnd);
        String functionBodyContent = sourceCode.substring(openBraceEnd, closeBraceStart);
        String afterCode = sourceCode.substring(closeBraceStart);
        String injectedBody = "head".equals(position) ? "\n" + functionBody + functionBodyContent : functionBodyContent + "\n" + functionBody + "\n";
        return beforeCode + injectedBody + afterCode;
    }

    public static String applyDSL(String sourceCode, EventProbeDSL dsl) {
        return EventProbeTextProcessor.injectEventProbe(sourceCode, dsl.getEventName(), dsl.getTargetLocation(), dsl.getPosition(), dsl.getFunctionBody());
    }

    public static String extractFunctionBody(String functionCode) {
        EventProbeLexer lexer = new EventProbeLexer(functionCode);
        List<EventProbeLexer.Token> tokens = lexer.tokenize();
        for (EventProbeLexer.Token token : tokens) {
            if (token.type == EventProbeLexer.TokenType.EOF) continue;
            Debugger.out("Token: " + token);
        }
        int functionIndex = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get((int)i).type != EventProbeLexer.TokenType.FUNCTION_KEYWORD) continue;
            functionIndex = i;
            break;
        }
        if (functionIndex == -1) {
            return functionCode;
        }
        int openBraceIndex = -1;
        for (int i = functionIndex; i < tokens.size(); ++i) {
            if (tokens.get((int)i).type != EventProbeLexer.TokenType.LEFT_BRACE) continue;
            openBraceIndex = i;
            break;
        }
        if (openBraceIndex == -1) {
            return functionCode;
        }
        int closeBraceIndex = EventProbeTextProcessor.findMatchingCloseBrace(tokens, openBraceIndex);
        if (closeBraceIndex == -1) {
            return functionCode;
        }
        EventProbeLexer.Token openBraceToken = tokens.get(openBraceIndex);
        EventProbeLexer.Token closeBraceToken = tokens.get(closeBraceIndex);
        int openBraceEnd = openBraceToken.position + 1;
        int closeBraceStart = closeBraceToken.position;
        String result = functionCode.substring(openBraceEnd, closeBraceStart);
        return result;
    }
}

