/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixinjs.dsl;

import java.util.ArrayList;
import java.util.List;

public class MixinDSLLexer {
    private final String input;
    private int position;

    public MixinDSLLexer(String input) {
        this.input = input;
        this.position = 0;
    }

    public List<Token> tokenize() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (this.position < this.input.length()) {
            Token token = this.nextToken();
            if (token.type == TokenType.WHITESPACE) continue;
            tokens.add(token);
        }
        tokens.add(new Token(TokenType.EOF, "", this.position));
        return tokens;
    }

    private Token nextToken() {
        if (this.position >= this.input.length()) {
            return new Token(TokenType.EOF, "", this.position);
        }
        char ch = this.input.charAt(this.position);
        int startPos = this.position++;
        switch (ch) {
            case '.': {
                return new Token(TokenType.DOT, ".", startPos);
            }
            case '(': {
                ++this.position;
                return new Token(TokenType.LEFT_PAREN, "(", startPos);
            }
            case ')': {
                ++this.position;
                return new Token(TokenType.RIGHT_PAREN, ")", startPos);
            }
            case '{': {
                ++this.position;
                return new Token(TokenType.LEFT_BRACE, "{", startPos);
            }
            case '}': {
                ++this.position;
                return new Token(TokenType.RIGHT_BRACE, "}", startPos);
            }
            case ',': {
                ++this.position;
                return new Token(TokenType.COMMA, ",", startPos);
            }
            case '\'': {
                return this.readStringLiteral('\'', startPos);
            }
            case '\"': {
                return this.readStringLiteral('\"', startPos);
            }
            case '\n': {
                ++this.position;
                return new Token(TokenType.NEWLINE, "\n", startPos);
            }
            case '\t': 
            case '\r': 
            case ' ': {
                return this.readWhitespace(startPos);
            }
            case '/': {
                if (this.position + 1 >= this.input.length()) break;
                char nextCh = this.input.charAt(this.position + 1);
                if (nextCh == '/') {
                    return this.readSingleLineComment(startPos);
                }
                if (nextCh != '*') break;
                return this.readMultiLineComment(startPos);
            }
        }
        if (Character.isDigit(ch)) {
            return this.readNumberLiteral(startPos);
        }
        if (Character.isLetter(ch) || ch == '_') {
            return this.readIdentifierOrKeyword(startPos);
        }
        ++this.position;
        return new Token(TokenType.UNKNOWN, String.valueOf(ch), startPos);
    }

    private Token readStringLiteral(char quoteChar, int startPos) {
        StringBuilder sb = new StringBuilder();
        sb.append(quoteChar);
        ++this.position;
        while (this.position < this.input.length() && this.input.charAt(this.position) != quoteChar) {
            sb.append(this.input.charAt(this.position));
            ++this.position;
        }
        if (this.position < this.input.length()) {
            sb.append(quoteChar);
            ++this.position;
        }
        String value = sb.substring(1, sb.length() - 1);
        String originalValue = sb.toString();
        return new Token(TokenType.STRING_LITERAL, value, originalValue, startPos);
    }

    private Token readSingleLineComment(int startPos) {
        StringBuilder sb = new StringBuilder();
        sb.append("//");
        this.position += 2;
        while (this.position < this.input.length() && this.input.charAt(this.position) != '\n') {
            sb.append(this.input.charAt(this.position));
            ++this.position;
        }
        return new Token(TokenType.COMMENT, sb.toString(), startPos);
    }

    private Token readMultiLineComment(int startPos) {
        StringBuilder sb = new StringBuilder();
        sb.append("/*");
        this.position += 2;
        while (this.position + 1 < this.input.length()) {
            char ch = this.input.charAt(this.position);
            sb.append(ch);
            if (ch == '*' && this.input.charAt(this.position + 1) == '/') {
                sb.append('/');
                this.position += 2;
                break;
            }
            ++this.position;
        }
        return new Token(TokenType.COMMENT, sb.toString(), startPos);
    }

    private Token readWhitespace(int startPos) {
        StringBuilder sb = new StringBuilder();
        while (this.position < this.input.length() && (this.input.charAt(this.position) == ' ' || this.input.charAt(this.position) == '\t' || this.input.charAt(this.position) == '\r')) {
            sb.append(this.input.charAt(this.position));
            ++this.position;
        }
        return new Token(TokenType.WHITESPACE, sb.toString(), startPos);
    }

    private Token readNumberLiteral(int startPos) {
        StringBuilder sb = new StringBuilder();
        while (this.position < this.input.length() && Character.isDigit(this.input.charAt(this.position))) {
            sb.append(this.input.charAt(this.position));
            ++this.position;
        }
        return new Token(TokenType.NUMBER_LITERAL, sb.toString(), startPos);
    }

    private Token readIdentifierOrKeyword(int startPos) {
        StringBuilder sb = new StringBuilder();
        while (this.position < this.input.length() && (Character.isLetterOrDigit(this.input.charAt(this.position)) || this.input.charAt(this.position) == '_')) {
            sb.append(this.input.charAt(this.position));
            ++this.position;
        }
        String identifier = sb.toString();
        if ("KLM".equals(identifier)) {
            return new Token(TokenType.MIXIN_KEYWORD, identifier, startPos);
        }
        if ("function".equals(identifier)) {
            return new Token(TokenType.FUNCTION_KEYWORD, identifier, startPos);
        }
        return new Token(TokenType.IDENTIFIER, identifier, startPos);
    }

    public static class Token {
        public final TokenType type;
        public final String value;
        public final String originalValue;
        public final int position;

        public Token(TokenType type, String value, int position) {
            this.type = type;
            this.value = value;
            this.originalValue = value;
            this.position = position;
        }

        public Token(TokenType type, String value, String originalValue, int position) {
            this.type = type;
            this.value = value;
            this.originalValue = originalValue;
            this.position = position;
        }

        public String toString() {
            return "Token{type=" + this.type + ", value='" + this.value + "', position=" + this.position + "}";
        }
    }

    public static enum TokenType {
        MIXIN_KEYWORD,
        DOT,
        IDENTIFIER,
        STRING_LITERAL,
        NUMBER_LITERAL,
        LEFT_PAREN,
        RIGHT_PAREN,
        LEFT_BRACE,
        RIGHT_BRACE,
        FUNCTION_KEYWORD,
        COMMA,
        WHITESPACE,
        NEWLINE,
        COMMENT,
        EOF,
        UNKNOWN;

    }
}

