/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.mixinjs.dsl;

import com.whisent.kubeloader.mixinjs.dsl.EventProbeTextProcessor;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSL;
import com.whisent.kubeloader.mixinjs.dsl.MixinDSLLexer;
import com.whisent.kubeloader.utils.Debugger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MixinDSLParserImpl {
    private final List<MixinDSLLexer.Token> tokens;
    private int position;

    public MixinDSLParserImpl(List<MixinDSLLexer.Token> tokens) {
        this.tokens = tokens;
        this.position = 0;
        Debugger.out("\u521b\u5efaMixinDSLParserImpl\u5b9e\u4f8b\uff0ctoken\u6570\u91cf: " + tokens.size());
    }

    public List<MixinDSL> parse() {
        Debugger.out("\u5f00\u59cb\u89e3\u6790DSL\uff0ctoken\u5217\u8868:");
        for (int i = 0; i < this.tokens.size(); ++i) {
            MixinDSLLexer.Token token = this.tokens.get(i);
            Debugger.out("  [" + i + "] " + token);
        }
        ArrayList<MixinDSL> result = new ArrayList<MixinDSL>();
        while (this.position < this.tokens.size() && this.currentToken().type != MixinDSLLexer.TokenType.EOF) {
            Debugger.out("\u5faa\u73af\u89e3\u6790\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position);
            MixinDSL dsl = this.parseMixinDSL();
            if (dsl != null) {
                Debugger.out("\u6210\u529f\u89e3\u6790\u4e00\u4e2aDSL\u5bf9\u8c61: " + dsl);
                result.add(dsl);
                continue;
            }
            Debugger.out("DSL\u89e3\u6790\u8fd4\u56denull");
        }
        return result;
    }

    private MixinDSL parseMixinDSL() {
        Debugger.out("\u5f00\u59cb\u89e3\u6790MixinDSL\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position);
        if (!this.match(MixinDSLLexer.TokenType.MIXIN_KEYWORD)) {
            Debugger.out("\u672a\u627e\u5230Mixin\u5173\u952e\u5b57\uff0c\u8df3\u8fc7");
            this.skipToNextStatement();
            return null;
        }
        Debugger.out("\u627e\u5230Mixin\u5173\u952e\u5b57");
        MixinDSL dsl = new MixinDSL();
        this.skipWhitespaceAndNewlines();
        Debugger.out("\u89e3\u6790.type()\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position);
        if (!this.match(MixinDSLLexer.TokenType.DOT)) {
            Debugger.out("\u671f\u671b'.'\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        MixinDSLLexer.Token typeToken = this.currentToken();
        Debugger.out("typeToken: " + typeToken);
        if (!this.match(MixinDSLLexer.TokenType.IDENTIFIER) || !"type".equals(typeToken.value)) {
            Debugger.out("\u671f\u671b'type'\u6807\u8bc6\u7b26\u4f46\u672a\u627e\u5230\uff0c\u5b9e\u9645\u4e3a: " + (typeToken != null ? typeToken.value : "null"));
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.LEFT_PAREN)) {
            Debugger.out("\u671f\u671b'('\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        MixinDSLLexer.Token typeValueToken = this.currentToken();
        Debugger.out("typeValueToken: " + typeValueToken);
        if (!this.match(MixinDSLLexer.TokenType.STRING_LITERAL)) {
            Debugger.out("\u671f\u671b\u5b57\u7b26\u4e32\u5b57\u9762\u91cf\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        String type = typeValueToken.value;
        Debugger.out("\u89e3\u6790\u5230\u7c7b\u578b: " + type);
        dsl.setType(type);
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.RIGHT_PAREN)) {
            Debugger.out("\u671f\u671b')'\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        Debugger.out("\u89e3\u6790.at()\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position);
        if (!this.match(MixinDSLLexer.TokenType.DOT)) {
            Debugger.out("\u671f\u671b'.'\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        MixinDSLLexer.Token atToken = this.currentToken();
        Debugger.out("atToken: " + atToken);
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.IDENTIFIER) || !"at".equals(atToken.value)) {
            Debugger.out("\u671f\u671b'at'\u6807\u8bc6\u7b26\u4f46\u672a\u627e\u5230\uff0c\u5b9e\u9645\u4e3a: " + (atToken != null ? atToken.value : "null"));
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.LEFT_PAREN)) {
            Debugger.out("\u671f\u671b'('\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        MixinDSLLexer.Token atValueToken = this.currentToken();
        Debugger.out("atValueToken: " + atValueToken);
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.STRING_LITERAL)) {
            Debugger.out("\u671f\u671b\u5b57\u7b26\u4e32\u5b57\u9762\u91cf\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        String at = atValueToken.value;
        dsl.setAt(at);
        Debugger.out("\u89e3\u6790\u5230\u4f4d\u7f6e: " + at);
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.RIGHT_PAREN)) {
            Debugger.out("\u671f\u671b')'\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        Debugger.out("\u89e3\u6790.in()\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position);
        if (!this.match(MixinDSLLexer.TokenType.DOT)) {
            Debugger.out("\u671f\u671b'.'\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        MixinDSLLexer.Token inToken = this.currentToken();
        Debugger.out("inToken: " + inToken);
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.IDENTIFIER) || !"in".equals(inToken.value)) {
            Debugger.out("\u671f\u671b'in'\u6807\u8bc6\u7b26\u4f46\u672a\u627e\u5230\uff0c\u5b9e\u9645\u4e3a: " + (inToken != null ? inToken.value : "null"));
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.LEFT_PAREN)) {
            Debugger.out("\u671f\u671b'('\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        MixinDSLLexer.Token inValueToken = this.currentToken();
        Debugger.out("inValueToken: " + inValueToken);
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.STRING_LITERAL)) {
            Debugger.out("\u671f\u671b\u5b57\u7b26\u4e32\u5b57\u9762\u91cf\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        String in = inValueToken.value;
        dsl.setTarget(in);
        Debugger.out("\u89e3\u6790\u5230\u76ee\u6807: " + in);
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.RIGHT_PAREN)) {
            Debugger.out("\u671f\u671b')'\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        Debugger.out("\u68c0\u67e5locate\u65b9\u6cd5\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position + "\uff0c\u5f53\u524dtoken\u7c7b\u578b: " + (Serializable)(this.position < this.tokens.size() ? this.currentToken().type : "EOF"));
        if (this.position < this.tokens.size() && this.currentToken().type == MixinDSLLexer.TokenType.DOT) {
            Debugger.out("\u627e\u5230\u70b9\u53f7\uff0c\u8df3\u8fc7\u70b9\u53f7");
            this.match(MixinDSLLexer.TokenType.DOT);
            this.skipWhitespaceAndNewlines();
            MixinDSLLexer.Token locateToken = this.currentToken();
            Debugger.out("locateToken\u7c7b\u578b: " + locateToken.type + "\uff0c\u503c: " + locateToken.value);
            if (locateToken.type == MixinDSLLexer.TokenType.IDENTIFIER && "locate".equals(locateToken.value)) {
                Debugger.out("\u627e\u5230locate\u65b9\u6cd5");
                ++this.position;
                this.skipWhitespaceAndNewlines();
                if (this.position >= this.tokens.size() || this.currentToken().type != MixinDSLLexer.TokenType.LEFT_PAREN) {
                    Debugger.out("\u671f\u671b'('\u4f46\u672a\u627e\u5230\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position + "\uff0c\u5f53\u524dtoken\u7c7b\u578b: " + (Serializable)(this.position < this.tokens.size() ? this.currentToken().type : "EOF"));
                    if (this.position < this.tokens.size()) {
                        Debugger.out("\u5f53\u524dtoken\u503c: " + this.currentToken().value);
                    }
                    return dsl;
                }
                ++this.position;
                this.skipWhitespaceAndNewlines();
                if (this.position >= this.tokens.size()) {
                    Debugger.out("\u610f\u5916\u5230\u8fbe\u6587\u4ef6\u672b\u5c3e");
                    return dsl;
                }
                MixinDSLLexer.Token locationValueToken = this.currentToken();
                Debugger.out("locationValueToken\u7c7b\u578b: " + locationValueToken.type + "\uff0c\u503c: " + locationValueToken.value);
                if (locationValueToken.type != MixinDSLLexer.TokenType.STRING_LITERAL && locationValueToken.type != MixinDSLLexer.TokenType.IDENTIFIER && locationValueToken.type != MixinDSLLexer.TokenType.NUMBER_LITERAL) {
                    Debugger.out("\u671f\u671b\u6570\u5b57\u6216\u5b57\u7b26\u4e32\u5b57\u9762\u91cf\u4f46\u672a\u627e\u5230\uff0c\u5b9e\u9645\u7c7b\u578b: " + locationValueToken.type);
                    return dsl;
                }
                try {
                    int location = Integer.parseInt(locationValueToken.value);
                    dsl.setTargetLocation(location);
                    Debugger.out("\u89e3\u6790\u5230\u76ee\u6807\u4f4d\u7f6e: " + location);
                }
                catch (NumberFormatException e) {
                    Debugger.out("\u65e0\u6cd5\u89e3\u6790\u76ee\u6807\u4f4d\u7f6e\u4e3a\u6570\u5b57: " + locationValueToken.value);
                    return dsl;
                }
                ++this.position;
                this.skipWhitespaceAndNewlines();
                if (this.position >= this.tokens.size() || this.currentToken().type != MixinDSLLexer.TokenType.RIGHT_PAREN) {
                    Debugger.out("\u671f\u671b')'\u4f46\u672a\u627e\u5230\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position + "\uff0c\u5f53\u524dtoken\u7c7b\u578b: " + (Serializable)(this.position < this.tokens.size() ? this.currentToken().type : "EOF"));
                    return dsl;
                }
                ++this.position;
                Debugger.out("locate\u65b9\u6cd5\u89e3\u6790\u5b8c\u6210");
            } else {
                Debugger.out("\u4e0d\u662flocate\u65b9\u6cd5\uff0c\u56de\u9000\u4f4d\u7f6e");
                --this.position;
            }
        } else {
            Debugger.out("\u672a\u627e\u5230DOT\u6216\u5df2\u5230\u8fbe\u6587\u4ef6\u672b\u5c3e");
        }
        this.skipWhitespaceAndNewlines();
        Debugger.out("\u68c0\u67e5priority\u65b9\u6cd5\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position + "\uff0c\u5f53\u524dtoken\u7c7b\u578b: " + (Serializable)(this.position < this.tokens.size() ? this.currentToken().type : "EOF"));
        if (this.position < this.tokens.size() && this.currentToken().type == MixinDSLLexer.TokenType.DOT) {
            Debugger.out("\u627e\u5230\u70b9\u53f7\uff0c\u8df3\u8fc7\u70b9\u53f7");
            this.match(MixinDSLLexer.TokenType.DOT);
            this.skipWhitespaceAndNewlines();
            MixinDSLLexer.Token priorityToken = this.currentToken();
            Debugger.out("priorityToken\u7c7b\u578b: " + priorityToken.type + "\uff0c\u503c: " + priorityToken.value);
            if (priorityToken.type == MixinDSLLexer.TokenType.IDENTIFIER && "priority".equals(priorityToken.value)) {
                Debugger.out("\u627e\u5230priority\u65b9\u6cd5");
                ++this.position;
                this.skipWhitespaceAndNewlines();
                if (this.position >= this.tokens.size() || this.currentToken().type != MixinDSLLexer.TokenType.LEFT_PAREN) {
                    Debugger.out("\u671f\u671b'('\u4f46\u672a\u627e\u5230\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position + "\uff0c\u5f53\u524dtoken\u7c7b\u578b: " + (Serializable)(this.position < this.tokens.size() ? this.currentToken().type : "EOF"));
                    if (this.position < this.tokens.size()) {
                        Debugger.out("\u5f53\u524dtoken\u503c: " + this.currentToken().value);
                    }
                    return dsl;
                }
                ++this.position;
                this.skipWhitespaceAndNewlines();
                if (this.position >= this.tokens.size()) {
                    Debugger.out("\u610f\u5916\u5230\u8fbe\u6587\u4ef6\u672b\u5c3e");
                    return dsl;
                }
                MixinDSLLexer.Token priorityValueToken = this.currentToken();
                Debugger.out("priorityValueToken\u7c7b\u578b: " + priorityValueToken.type + "\uff0c\u503c: " + priorityValueToken.value);
                if (priorityValueToken.type != MixinDSLLexer.TokenType.STRING_LITERAL && priorityValueToken.type != MixinDSLLexer.TokenType.IDENTIFIER && priorityValueToken.type != MixinDSLLexer.TokenType.NUMBER_LITERAL) {
                    Debugger.out("\u671f\u671b\u6570\u5b57\u6216\u5b57\u7b26\u4e32\u5b57\u9762\u91cf\u4f46\u672a\u627e\u5230\uff0c\u5b9e\u9645\u7c7b\u578b: " + priorityValueToken.type);
                    return dsl;
                }
                try {
                    int priority = Integer.parseInt(priorityValueToken.value);
                    dsl.setPriority(priority);
                    Debugger.out("\u89e3\u6790\u5230\u4f18\u5148\u7ea7: " + priority);
                }
                catch (NumberFormatException e) {
                    Debugger.out("\u65e0\u6cd5\u89e3\u6790\u4f18\u5148\u7ea7\u4e3a\u6570\u5b57: " + priorityValueToken.value);
                    return dsl;
                }
                ++this.position;
                this.skipWhitespaceAndNewlines();
                if (this.position >= this.tokens.size() || this.currentToken().type != MixinDSLLexer.TokenType.RIGHT_PAREN) {
                    Debugger.out("\u671f\u671b')'\u4f46\u672a\u627e\u5230\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position + "\uff0c\u5f53\u524dtoken\u7c7b\u578b: " + (Serializable)(this.position < this.tokens.size() ? this.currentToken().type : "EOF"));
                    return dsl;
                }
                ++this.position;
                Debugger.out("priority\u65b9\u6cd5\u89e3\u6790\u5b8c\u6210");
            } else {
                Debugger.out("\u4e0d\u662fpriority\u65b9\u6cd5\uff0c\u56de\u9000\u4f4d\u7f6e");
                --this.position;
            }
        } else {
            Debugger.out("\u672a\u627e\u5230DOT\u6216\u5df2\u5230\u8fbe\u6587\u4ef6\u672b\u5c3e");
        }
        Debugger.out("\u5f00\u59cb\u89e3\u6790.inject\u65b9\u6cd5\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position);
        this.skipWhitespaceAndNewlines();
        Debugger.out("\u8df3\u8fc7\u6362\u884c\u7b26\u540e\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position + "\uff0ctoken\u6570\u91cf: " + this.tokens.size());
        if (this.position >= this.tokens.size()) {
            Debugger.out("\u5df2\u5230\u8fbe\u6587\u4ef6\u672b\u5c3e\uff0c\u65e0\u6cd5\u7ee7\u7eed\u89e3\u6790");
            return dsl;
        }
        Debugger.out("\u5f53\u524d\u4f4d\u7f6etoken\u7c7b\u578b: " + this.currentToken().type + "\uff0c\u503c: " + this.currentToken().value);
        if (!this.match(MixinDSLLexer.TokenType.DOT)) {
            Debugger.out("\u671f\u671b'.'\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        MixinDSLLexer.Token injectToken = this.currentToken();
        Debugger.out("injectToken: " + injectToken);
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.IDENTIFIER) || !"inject".equals(injectToken.value)) {
            Debugger.out("\u671f\u671b'inject'\u6807\u8bc6\u7b26\u4f46\u672a\u627e\u5230\uff0c\u5b9e\u9645\u4e3a: " + (injectToken != null ? injectToken.value : "null"));
            return dsl;
        }
        this.skipWhitespaceAndNewlines();
        if (!this.match(MixinDSLLexer.TokenType.LEFT_PAREN)) {
            Debugger.out("\u671f\u671b'('\u4f46\u672a\u627e\u5230");
            return dsl;
        }
        String injectCode = this.parseInjectFunction();
        Debugger.out("\u89e3\u6790inject\u51fd\u6570\u4f53\u7ed3\u679c: " + injectCode);
        if (injectCode != null) {
            String extractedBody = EventProbeTextProcessor.extractFunctionBody(injectCode);
            Debugger.out("\u63d0\u53d6\u51fd\u6570\u4f53\u7ed3\u679c: " + extractedBody);
            dsl.setAction(extractedBody);
            Debugger.out("\u8bbe\u7f6eactionCode: " + extractedBody);
        } else {
            Debugger.out("injectCode\u4e3anull\uff0c\u65e0\u6cd5\u8bbe\u7f6eactionCode");
        }
        Debugger.out("MixinDSL\u89e3\u6790\u5b8c\u6210: " + dsl);
        return dsl;
    }

    private void skipWhitespaceAndNewlines() {
        Debugger.out("\u5f00\u59cb\u8df3\u8fc7\u7a7a\u767d\u5b57\u7b26\u548c\u6362\u884c\u7b26\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position);
        while (this.position < this.tokens.size() && (this.currentToken().type == MixinDSLLexer.TokenType.NEWLINE || this.currentToken().type == MixinDSLLexer.TokenType.WHITESPACE)) {
            Debugger.out("\u8df3\u8fc7token: " + this.currentToken().type + " \u503c: '" + this.currentToken().value + "'");
            ++this.position;
        }
        Debugger.out("\u8df3\u8fc7\u5b8c\u6210\uff0c\u65b0\u4f4d\u7f6e: " + this.position);
    }

    private String parseInjectFunction() {
        MixinDSLLexer.Token token;
        MixinDSLLexer.Token token2;
        Debugger.out("\u5f00\u59cb\u89e3\u6790inject\u51fd\u6570\u4f53\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position);
        StringBuilder functionCodeBuilder = new StringBuilder();
        boolean afterFunctionKeyword = false;
        while (this.position < this.tokens.size() && this.currentToken().type != MixinDSLLexer.TokenType.LEFT_BRACE) {
            token2 = this.currentToken();
            Debugger.out("\u6536\u96c6\u51fd\u6570\u58f0\u660e\u90e8\u5206\uff0ctoken\u7c7b\u578b: " + token2.type + " \u503c: '" + token2.value + "'");
            if (afterFunctionKeyword && token2.type == MixinDSLLexer.TokenType.IDENTIFIER) {
                functionCodeBuilder.append(" ");
                afterFunctionKeyword = false;
            }
            if (token2.type == MixinDSLLexer.TokenType.COMMENT) {
                functionCodeBuilder.append(token2.value);
            } else if (token2.type == MixinDSLLexer.TokenType.STRING_LITERAL) {
                functionCodeBuilder.append(token2.originalValue);
            } else {
                functionCodeBuilder.append(token2.value);
            }
            if (token2.type == MixinDSLLexer.TokenType.FUNCTION_KEYWORD) {
                afterFunctionKeyword = true;
            }
            Debugger.out("\u6536\u96c6\u51fd\u6570\u58f0\u660e\u90e8\u5206: " + token2.value + " \u7c7b\u578b: " + token2.type);
            ++this.position;
        }
        if (this.position >= this.tokens.size() || this.currentToken().type != MixinDSLLexer.TokenType.LEFT_BRACE) {
            Debugger.out("\u672a\u627e\u5230\u51fd\u6570\u4f53\u5f00\u59cb\u7684\u5927\u62ec\u53f7");
            return null;
        }
        token2 = this.currentToken();
        functionCodeBuilder.append(token2.value);
        Debugger.out("\u6dfb\u52a0\u5de6\u5927\u62ec\u53f7: " + token2.value);
        ++this.position;
        int braceCount = 1;
        while (this.position < this.tokens.size() && braceCount > 0) {
            token = this.currentToken();
            Debugger.out("\u89e3\u6790\u51fd\u6570\u4f53\u4e2d\u7684token\uff0c\u7c7b\u578b: " + token.type + " \u503c: '" + token.value + "' braceCount: " + braceCount);
            if (token.type == MixinDSLLexer.TokenType.COMMENT) {
                functionCodeBuilder.append(token.value);
            } else if (token.type == MixinDSLLexer.TokenType.STRING_LITERAL) {
                functionCodeBuilder.append(token.originalValue);
            } else {
                functionCodeBuilder.append(token.value);
            }
            Debugger.out("\u89e3\u6790\u51fd\u6570\u4f53\u4e2d\u7684token: " + token + " braceCount: " + braceCount);
            switch (token.type) {
                case LEFT_BRACE: {
                    Debugger.out("\u5de6\u5927\u62ec\u53f7\uff0c\u8ba1\u6570: " + ++braceCount);
                    break;
                }
                case RIGHT_BRACE: {
                    Debugger.out("\u53f3\u5927\u62ec\u53f7\uff0c\u8ba1\u6570: " + --braceCount);
                    break;
                }
                case EOF: {
                    Debugger.out("\u610f\u5916\u7684\u6587\u4ef6\u7ed3\u675f");
                    return null;
                }
            }
            if (braceCount <= 0) continue;
            ++this.position;
        }
        if (braceCount != 0) {
            Debugger.out("\u5927\u62ec\u53f7\u4e0d\u5339\u914d");
            return null;
        }
        if (this.position < this.tokens.size() && this.currentToken().type == MixinDSLLexer.TokenType.RIGHT_BRACE) {
            token = this.currentToken();
            functionCodeBuilder.append(token.value);
            Debugger.out("\u6dfb\u52a0\u53f3\u5927\u62ec\u53f7: " + token.value);
            ++this.position;
        }
        String functionCode = functionCodeBuilder.toString();
        Debugger.out("\u5b8c\u6574\u51fd\u6570\u4ee3\u7801: " + functionCode);
        String functionBody = EventProbeTextProcessor.extractFunctionBody(functionCode);
        Debugger.out("\u63d0\u53d6\u7684\u51fd\u6570\u4f53: " + functionBody);
        return functionCode;
    }

    private boolean match(MixinDSLLexer.TokenType expectedType) {
        Debugger.out("\u5c1d\u8bd5\u5339\u914d\u7c7b\u578b: " + expectedType + "\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position + "\uff0c\u5f53\u524dtoken: " + (Serializable)(this.currentToken() != null ? this.currentToken().type : "null") + "\uff0c\u503c: " + (this.currentToken() != null ? this.currentToken().value : "null"));
        if (this.position < this.tokens.size() && this.tokens.get((int)this.position).type == expectedType) {
            Debugger.out("\u5339\u914d\u6210\u529f");
            ++this.position;
            return true;
        }
        Debugger.out("\u5339\u914d\u5931\u8d25");
        return false;
    }

    private MixinDSLLexer.Token currentToken() {
        if (this.position < this.tokens.size()) {
            return this.tokens.get(this.position);
        }
        return null;
    }

    private void skipToNextStatement() {
        Debugger.out("\u8df3\u5230\u4e0b\u4e00\u4e2a\u8bed\u53e5\uff0c\u5f53\u524d\u4f4d\u7f6e: " + this.position);
        while (this.position < this.tokens.size() && this.currentToken().type != MixinDSLLexer.TokenType.MIXIN_KEYWORD && this.currentToken().type != MixinDSLLexer.TokenType.EOF) {
            ++this.position;
        }
        Debugger.out("\u8df3\u8f6c\u540e\u4f4d\u7f6e: " + this.position);
    }
}

