/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.plugin;

import com.google.common.collect.Maps;
import com.whisent.kubeloader.definition.ContentPack;
import com.whisent.kubeloader.definition.inject.SortablePacksHolder;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import com.whisent.kubeloader.impl.depends.SortableContentPack;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ContentPacksBinding {
    public static final Map<ScriptType, Map<String, Object>> TYPED_GLOBALS = new EnumMap<ScriptType, Map<String, Object>>(ScriptType.class);
    private final ScriptType type;
    private final SortablePacksHolder packsHolder;

    public ContentPacksBinding(ScriptType type, SortablePacksHolder packsHolder) {
        this.type = type;
        this.packsHolder = packsHolder;
    }

    public ScriptType type() {
        return this.type;
    }

    @Info(value="@return `true` if a ContentPack with provided `id` is present, `false` otherwise")
    public boolean isLoaded(String id) {
        return this.packsHolder.kubeLoader$sortablePacks().containsKey(id);
    }

    @Info(value="@return The metadata from ContentPack with provided `id`, or `null` if there's no such ContentPack")
    public PackMetaData getMetadata(String id) {
        SortableContentPack sortableContentPack = this.packsHolder.kubeLoader$sortablePacks().get(id);
        return Optional.ofNullable(sortableContentPack).map(SortableContentPack::pack).map(ContentPack::getMetaData).orElse(null);
    }

    @Info(value="ContentPack id -> ContentPack metadata")
    public Map<String, PackMetaData> getAllMetadata() {
        return Collections.unmodifiableMap(Maps.transformValues(this.packsHolder.kubeLoader$sortablePacks(), s -> s.pack().getMetaData()));
    }

    @Info(value="Put value into ContentPack shared data for **current** script type\n\n@see {@link type} Current script type\n@see {@link getAllSharedFor} View ContentPack shared data for another script type.")
    public void putShared(String id, Object o) {
        TYPED_GLOBALS.get(this.type).put(id, o);
    }

    @Info(value="Get ContentPack shared data for **current** script type\n\n@see {@link type} Current script type\n@see {@link getAlSharedFor} View ContentPack shared data for another script type.")
    public Object getShared(String id) {
        return this.getShared(this.type, id);
    }

    @Info(value="Get ContentPack shared data for specified script type\n\n@see {@link type} Current script type\n@see {@link getAlSharedFor} View ContentPack shared data for another script type.")
    public Object getShared(ScriptType type, String id) {
        return this.getAllSharedFor(type).get(id);
    }

    @Info(value="View all ContentPack shared data for **current** script type\n\nThe return value is **immutable**, which means you can't put value into it\n\n@see {@link type} Current script type\n@see {@link getAllSharedFor} View ContentPack shared data for another script type.")
    public Map<String, Object> getAllSharedForCurrent() {
        return this.getAllSharedFor(this.type);
    }

    @Info(value="View all ContentPack shared data for specified script type.\n\nThe return value is **immutable**, which means you can't put value into it\n\n@see {@link getAllSharedForCurrent} View all ContentPack shared data for **current** script type\n@see {@link putShared} Put value into ContentPack shared data for **current** script type")
    public Map<String, Object> getAllSharedFor(ScriptType type) {
        return Collections.unmodifiableMap(TYPED_GLOBALS.get(type));
    }

    static {
        for (ScriptType scriptType : ScriptType.values()) {
            TYPED_GLOBALS.put(scriptType, new HashMap());
        }
    }
}

