/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Function;

public class CodecUtil {
    public static <T extends Enum<T>> Codec<T> createEnumStringCodec(Class<T> type) {
        return CodecUtil.createEnumStringCodec(type, true);
    }

    public static <T extends Enum<T>> Codec<T> createEnumStringCodec(Class<T> type, boolean ignoreCase) {
        HashMap<String, Enum> indexedValues = new HashMap<String, Enum>();
        for (Enum value : (Enum[])type.getEnumConstants()) {
            String name2 = value.name();
            if (ignoreCase) {
                name2 = name2.toLowerCase(Locale.ROOT);
            }
            indexedValues.put(name2, value);
        }
        return Codec.STRING.comapFlatMap(CodecUtil.wrapUnsafeFn(name -> {
            if (name == null) {
                throw new NullPointerException("Name is null");
            }
            Enum result = (Enum)indexedValues.get(ignoreCase ? name.toLowerCase(Locale.ROOT) : name);
            if (result == null) {
                throw new IllegalArgumentException("No enum constant " + type.getCanonicalName() + "." + name);
            }
            return result;
        }), Enum::name);
    }

    public static <I, O> Function<I, DataResult<O>> wrapUnsafeFn(UnsafeFunction<I, O> function) {
        return function;
    }

    public static interface UnsafeFunction<I, O>
    extends Function<I, DataResult<O>> {
        public O applyUnsafe(I var1) throws Exception;

        @Override
        default public DataResult<O> apply(I i) {
            try {
                return DataResult.success(this.applyUnsafe(i));
            }
            catch (Exception e) {
                return DataResult.error(e::toString);
            }
        }
    }
}

