/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.utils;

import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PerformanceUtil {
    private final ConsoleJS console;
    private final Map<String, Long> timers = new ConcurrentHashMap<String, Long>();
    private final Map<String, Integer> callCounts = new ConcurrentHashMap<String, Integer>();

    public PerformanceUtil(ScriptType type) {
        this.console = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ScriptType.CLIENT -> ConsoleJS.CLIENT;
            case ScriptType.SERVER -> ConsoleJS.SERVER;
            case ScriptType.STARTUP -> ConsoleJS.STARTUP;
        };
    }

    public long getNanoTime() {
        return System.nanoTime();
    }

    public void start(String label) {
        this.timers.put(label, System.nanoTime());
        this.callCounts.merge(label, 1, Integer::sum);
    }

    public double end(String label) {
        Long start = this.timers.get(label);
        if (start == null) {
            return -1.0;
        }
        long end = System.nanoTime();
        double ms = (double)(end - start) / 1000000.0;
        this.timers.remove(label);
        return ms;
    }

    public int getCallCount(String label) {
        return this.callCounts.getOrDefault(label, 0);
    }

    public void reset(String label) {
        this.timers.remove(label);
        this.callCounts.remove(label);
    }

    public void resetAll() {
        this.timers.clear();
        this.callCounts.clear();
    }

    public void log(String label) {
        double duration = this.end(label);
        int count = this.getCallCount(label);
        if (duration >= 0.0) {
            this.console.log(new Object[]{String.format("Timer: %s | Time: %.4f ms | Calls: %d", label, duration, count)});
        } else {
            this.console.log(new Object[]{"No timer started for: " + label});
        }
    }
}

