/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.utils.mod_gen;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import com.whisent.kubeloader.definition.meta.PackMetaDataBuilder;
import com.whisent.kubeloader.definition.meta.dependency.DependencyType;
import com.whisent.kubeloader.definition.meta.dependency.PackDependency;
import com.whisent.kubeloader.definition.meta.dependency.PackDependencyBuilder;
import com.whisent.kubeloader.utils.Debugger;
import dev.latvian.mods.kubejs.typings.Info;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class ContentPackGenerator {
    public static PackMetaDataBuilder createMetaData(String packId) {
        return PackMetaDataBuilder.create(packId);
    }

    public static PackDependencyBuilder createDependency(DependencyType type, String id) {
        return PackDependencyBuilder.create(type, id);
    }

    @Info(value="You should use /kl pack <packid> command to generate it, rather than calling this method directly.")
    public static void generateContentPack(PackMetaData metaData) throws IOException {
        String packId = metaData.id();
        Path packDir = Kubeloader.PackPath.resolve(packId);
        Files.createDirectories(packDir, new FileAttribute[0]);
        List<String> dirs = List.of("server_scripts", "client_scripts", "startup_scripts", "common_scripts", "assets", "data");
        dirs.forEach(dir -> {
            try {
                Files.createDirectories(packDir.resolve((String)dir), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        JsonElement jsonElement = (JsonElement)PackMetaData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)metaData).resultOrPartial(s -> {
            throw new IllegalStateException("Failed to serialize PackMetaData: " + s);
        }).orElseThrow(() -> new RuntimeException("Failed to serialize PackMetaData"));
        String jsonString = Kubeloader.GSON.newBuilder().setPrettyPrinting().create().toJson(jsonElement) + "\n";
        Files.writeString(packDir.resolve("contentpack.json"), (CharSequence)jsonString, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Info(value="You should use /kl pack <packid> command to generate it, rather than calling this method directly.")
    public static void generateContentPack(PackMetaData metaData, ServerPlayer player) throws IOException {
        String packId = metaData.id();
        Path packDir = Kubeloader.PackPath.resolve(packId);
        ContentPackGenerator.sendPlayerMessage(player, (Component)Component.m_237110_((String)"chat.kubeloader.contentpack.start", (Object[])new Object[]{packId}).m_130940_(ChatFormatting.GOLD));
        try {
            Files.createDirectories(packDir, new FileAttribute[0]);
            ContentPackGenerator.sendPlayerMessage(player, (Component)Component.m_237115_((String)"chat.kubeloader.contentpack.root_created").m_130940_(ChatFormatting.GREEN));
            List<String> dirs = List.of("server_scripts", "client_scripts", "startup_scripts", "mixins", "assets", "data");
            for (String dir : dirs) {
                try {
                    Files.createDirectories(packDir.resolve(dir), new FileAttribute[0]);
                    ContentPackGenerator.sendPlayerMessage(player, (Component)Component.m_237110_((String)"chat.kubeloader.contentpack.dir_created", (Object[])new Object[]{dir}).m_130940_(ChatFormatting.AQUA));
                }
                catch (IOException e) {
                    MutableComponent errorMsg = Component.m_237110_((String)"chat.kubeloader.contentpack.dir_failed", (Object[])new Object[]{dir}).m_130940_(ChatFormatting.RED);
                    ContentPackGenerator.sendPlayerMessage(player, (Component)errorMsg);
                    throw new IOException("Failed to create directory: " + packDir.resolve(dir), e);
                }
            }
            ContentPackGenerator.sendPlayerMessage(player, (Component)Component.m_237115_((String)"chat.kubeloader.contentpack.serializing").m_130940_(ChatFormatting.YELLOW));
            JsonElement jsonElement = (JsonElement)PackMetaData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)metaData).resultOrPartial(s -> {
                throw new IllegalStateException("Failed to serialize PackMetaData: " + s);
            }).orElseThrow(() -> new RuntimeException("Failed to serialize PackMetaData"));
            String jsonString = Kubeloader.GSON.newBuilder().setPrettyPrinting().create().toJson(jsonElement) + "\n";
            Path metaFile = packDir.resolve("contentpack.json");
            Files.writeString(metaFile, (CharSequence)jsonString, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            ContentPackGenerator.sendPlayerMessage(player, (Component)Component.m_237110_((String)"chat.kubeloader.contentpack.meta_written", (Object[])new Object[]{"contentpack.json"}).m_130940_(ChatFormatting.GREEN));
            MutableComponent successMsg = Component.m_237110_((String)"chat.kubeloader.contentpack.success", (Object[])new Object[]{packId}).m_130940_(ChatFormatting.LIGHT_PURPLE);
            ContentPackGenerator.sendPlayerMessage(player, (Component)successMsg);
            Kubeloader.LOGGER.info("\u5185\u5bb9\u5305\u751f\u6210\u6210\u529f: {}", (Object)packId);
            Debugger.out("\u5185\u5bb9\u5305\u751f\u6210\u5b8c\u6210\uff01ID: " + packId);
            Debugger.out("\u76ee\u5f55\u4f4d\u7f6e: " + packDir.toAbsolutePath());
        }
        catch (Exception e) {
            MutableComponent errorMsg = Component.m_237110_((String)"chat.kubeloader.contentpack.failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED);
            ContentPackGenerator.sendPlayerMessage(player, (Component)errorMsg);
            Kubeloader.LOGGER.error("\u751f\u6210\u5185\u5bb9\u5305\u5931\u8d25 (\u7528\u6237: {}, packId: {})", (Object)player.m_7755_().getString(), (Object)packId, (Object)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Failed to generate content pack: " + packId, e);
        }
    }

    private static void sendPlayerMessage(ServerPlayer player, Component message) {
        player.m_213846_(message);
    }

    public static void fastGenerateContentPack(String packId, List<String> authors) throws IOException {
        PackDependency dependency = PackDependencyBuilder.create(DependencyType.REQUIRED, "kubejs").build();
        PackMetaData metaData = PackMetaDataBuilder.create(packId).withAuthors(authors).withVersion("1.0.0").withDescription("This is a default content pack generated by KubeLoader").addDependency(dependency).build();
        ContentPackGenerator.generateContentPack(metaData);
    }

    public static void fastGenerateContentPack(String packId, List<String> authors, ServerPlayer player) throws IOException {
        PackMetaData metaData;
        try {
            PackDependency dependency = PackDependencyBuilder.create(DependencyType.REQUIRED, "kubejs").build();
            metaData = PackMetaDataBuilder.create(packId).withAuthors(authors).withVersion("1.0.0").withDescription("This is a default content pack generated by KubeLoader").addDependency(dependency).build();
        }
        catch (Exception e) {
            MutableComponent error = Component.m_237113_((String)("Failed to create PackMetaData : " + e.getMessage())).m_130940_(ChatFormatting.RED);
            ContentPackGenerator.sendPlayerMessage(player, (Component)error);
            throw new IOException("Failed to create PackMetaData for: " + packId, e);
        }
        ContentPackGenerator.generateContentPack(metaData, player);
    }
}

