/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.utils.mod_gen;

public class ModDependency {
    public final String id;
    public final boolean mandatory;
    public final String versionRange;
    public final String ordering;
    public final String side;

    private ModDependency(Builder builder) {
        this.id = builder.id;
        this.mandatory = builder.mandatory;
        this.versionRange = builder.versionRange;
        this.ordering = builder.ordering;
        this.side = builder.side;
    }

    public static Builder create(String modId) {
        return new Builder().withId(modId);
    }

    public String toTomlString(String modId) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[[dependencies.%s]]%n", modId));
        sb.append(String.format("    modId=\"%s\"%n", this.id));
        sb.append(String.format("    mandatory=%s%n", this.mandatory));
        if (this.versionRange != null && !this.versionRange.isEmpty()) {
            sb.append(String.format("    versionRange=\"%s\"%n", this.versionRange));
        }
        if (this.ordering != null && !this.ordering.isEmpty()) {
            sb.append(String.format("    ordering=\"%s\"%n", this.ordering));
        }
        if (this.side != null && !this.side.isEmpty()) {
            sb.append(String.format("    side=\"%s\"%n", this.side));
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("ModDependency{id='%s', mandatory=%s, versionRange='%s', ordering='%s', side='%s'}", this.id, this.mandatory, this.versionRange, this.ordering, this.side);
    }

    public static class Builder {
        private String id;
        private boolean mandatory = true;
        private String versionRange;
        private String ordering;
        private String side;

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withMandatory(boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        public Builder withVersionRange(String versionRange) {
            this.versionRange = versionRange;
            return this;
        }

        public Builder withOrdering(String ordering) {
            this.ordering = ordering;
            return this;
        }

        public Builder withSide(String side) {
            this.side = side;
            return this;
        }

        public ModDependency build() {
            if (this.id == null || this.id.isEmpty()) {
                throw new IllegalStateException("ModDependency ID is required.");
            }
            return new ModDependency(this);
        }
    }
}

