/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.utils.mod_gen;

import com.whisent.kubeloader.Kubeloader;
import com.whisent.kubeloader.definition.meta.PackMetaData;
import com.whisent.kubeloader.files.FileIO;
import com.whisent.kubeloader.utils.mod_gen.ContentPackModInfo;
import com.whisent.kubeloader.utils.mod_gen.ModDependency;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.typings.Info;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class PackModGenerator {
    @Info(value="You should use /kl mod <modid> command to generate it, rather than calling this method directly.")
    public static void generateMod(ContentPackModInfo packInfo) throws IOException {
        String modId = packInfo.id;
        Path outputDir = KubeJSPaths.LOCAL_CACHE.resolve(modId + "-generated");
        PackModGenerator.createDirectoryStructure(outputDir, modId);
        PackModGenerator.generateModsToml(outputDir, packInfo);
        PackModGenerator.generateDefaultResources(outputDir, modId);
        PackModGenerator.generateDefaultScripts(outputDir, modId);
        PackModGenerator.generatePackMcmeta(outputDir, modId, 15);
        Path jarFile = KubeJSPaths.EXPORT.resolve(modId + "-" + packInfo.version + ".jar");
        PackModGenerator.createJar(outputDir, jarFile);
        PackModGenerator.cleanCache(outputDir);
    }

    @Info(value="You should use /kl mod <modid> command to generate it, rather than calling this method directly.")
    public static void generateMod(ContentPackModInfo packInfo, ServerPlayer player) throws IOException {
        String modId = packInfo.id;
        Path outputDir = KubeJSPaths.LOCAL_CACHE.resolve(modId + "-generated");
        PackModGenerator.sendPlayerMessage(player, (Component)Component.m_237110_((String)"chat.kubeloader.mod.start", (Object[])new Object[]{modId}).m_130940_(ChatFormatting.GOLD));
        try {
            PackModGenerator.createDirectoryStructure(outputDir, modId);
            PackModGenerator.sendPlayerMessage(player, (Component)Component.m_237115_((String)"chat.kubeloader.mod.dir_created").m_130940_(ChatFormatting.GREEN));
            PackModGenerator.generateModsToml(outputDir, packInfo);
            PackModGenerator.sendPlayerMessage(player, (Component)Component.m_237115_((String)"chat.kubeloader.mod.mods_toml_done").m_130940_(ChatFormatting.GREEN));
            PackModGenerator.generateDefaultResources(outputDir, modId);
            PackModGenerator.sendPlayerMessage(player, (Component)Component.m_237115_((String)"chat.kubeloader.mod.resources_copied").m_130940_(ChatFormatting.GREEN));
            PackModGenerator.generateDefaultScripts(outputDir, modId);
            PackModGenerator.sendPlayerMessage(player, (Component)Component.m_237115_((String)"chat.kubeloader.mod.scripts_copied").m_130940_(ChatFormatting.GREEN));
            PackModGenerator.generatePackMcmeta(outputDir, modId, 15);
            PackModGenerator.sendPlayerMessage(player, (Component)Component.m_237115_((String)"chat.kubeloader.mod.mcmeta_done").m_130940_(ChatFormatting.GREEN));
            Path jarFile = KubeJSPaths.EXPORT.resolve(modId + "-" + packInfo.version + ".jar");
            PackModGenerator.createJar(outputDir, jarFile);
            PackModGenerator.sendPlayerMessage(player, (Component)Component.m_237110_((String)"chat.kubeloader.mod.jar_created", (Object[])new Object[]{jarFile.getFileName().toString()}).m_130940_(ChatFormatting.AQUA));
            PackModGenerator.cleanCache(outputDir);
            PackModGenerator.sendPlayerMessage(player, (Component)Component.m_237115_((String)"chat.kubeloader.mod.cleanup_done").m_130940_(ChatFormatting.GRAY));
            MutableComponent successMsg = Component.m_237115_((String)"chat.kubeloader.mod.success").m_130940_(ChatFormatting.LIGHT_PURPLE);
            PackModGenerator.sendPlayerMessage(player, (Component)successMsg);
            Kubeloader.LOGGER.info("Mod generated: {} -> {}", (Object)modId, (Object)jarFile.getFileName());
        }
        catch (IOException e) {
            MutableComponent errorMsg = Component.m_237110_((String)"chat.kubeloader.mod.failed", (Object[])new Object[]{e.getMessage()}).m_130940_(ChatFormatting.RED);
            PackModGenerator.sendPlayerMessage(player, (Component)errorMsg);
            Kubeloader.LOGGER.error("Mod \u751f\u6210\u5931\u8d25 (ModId: {})", (Object)modId, (Object)e);
            throw e;
        }
    }

    private static void sendPlayerMessage(ServerPlayer player, Component message) {
        player.m_213846_(message);
    }

    private static void createDirectoryStructure(Path outputDir, String modId) throws IOException {
        Files.createDirectories(outputDir.resolve("META-INF"), new FileAttribute[0]);
        Files.createDirectories(outputDir.resolve("contentpacks"), new FileAttribute[0]);
    }

    private static void generateModsToml(Path outputDir, ContentPackModInfo info) throws IOException {
        Path tomlPath = outputDir.resolve("META-INF/mods.toml");
        if (!Files.exists(outputDir.resolve("META-INF"), new LinkOption[0])) {
            Files.createDirectories(outputDir.resolve("META-INF"), new FileAttribute[0]);
        }
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(tomlPath, new OpenOption[0]));){
            writer.println("modLoader=\"lowcodefml\"");
            writer.println("loaderVersion=\"" + info.forge_version + "\"");
            writer.println("license=\"" + info.license + "\"");
            if (info.issuePage != null) {
                writer.println("issueTrackerURL=\"" + info.issuePage + "\"");
            }
            if (info.homepage != null) {
                writer.println("displayURL=\"" + info.homepage + "\"");
            }
            writer.println();
            writer.println("[[mods]]");
            writer.println("  modId=\"" + info.id + "\"");
            writer.println("  version=\"" + info.version + "\"");
            writer.println("  displayName=\"" + info.name + "\"");
            writer.println("  authors=\"" + Arrays.toString(info.authors) + "\"");
            writer.println("  description='''" + info.description + "'''");
            writer.println();
            for (ModDependency dep : info.modDependencies) {
                writer.println(dep.toTomlString(info.id));
            }
        }
    }

    private static void generateDefaultResources(Path baseDir, String modId) throws IOException {
        Path packDir = Kubeloader.PackPath.resolve(modId);
        if (Files.exists(packDir.resolve("assets"), new LinkOption[0])) {
            FileIO.copyAndReplaceAllFiles(packDir.resolve("assets"), baseDir.resolve("assets"));
        }
        if (Files.exists(packDir.resolve("data"), new LinkOption[0])) {
            FileIO.copyAndReplaceAllFiles(packDir.resolve("data"), baseDir.resolve("data"));
        }
    }

    private static void cleanCache(Path targetDir) throws IOException {
        FileIO.deleteAllContents(targetDir);
        Files.delete(targetDir);
    }

    private static void generateDefaultScripts(Path baseDir, String modId) throws IOException {
        List<Object> pathsToCopy;
        Path outputDir = baseDir.resolve("contentpacks");
        Path packDir = Kubeloader.PackPath.resolve(modId);
        String[] EXCLUDED_DIRS = new String[]{"assets", "data"};
        try (Stream<Path> stream = Files.walk(packDir, 1, new FileVisitOption[0]);){
            pathsToCopy = stream.filter(path -> !path.equals(packDir)).filter(path -> {
                Path relPath = packDir.relativize((Path)path);
                return Arrays.stream(EXCLUDED_DIRS).noneMatch(exclude -> relPath.equals(Paths.get(exclude, new String[0])));
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            pathsToCopy = List.of();
        }
        for (Path source : pathsToCopy) {
            try {
                Path relPath = packDir.relativize(source);
                Path target = outputDir.resolve(relPath);
                if (Files.isDirectory(source, new LinkOption[0])) {
                    FileIO.copyAndReplaceAllFiles(source, target);
                    continue;
                }
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                FileIO.copy(source, target);
            }
            catch (IOException e) {
                throw new IOException("Failed to copy: " + source + " -> " + outputDir.resolve(packDir.relativize(source)), e);
            }
        }
    }

    public static void generatePackMcmeta(Path outputDir, String modid, int packFormat) throws IOException {
        Files.createDirectories(outputDir, new FileAttribute[0]);
        Path mcmetaPath = outputDir.resolve("pack.mcmeta");
        String jsonContent = String.format("{\n  \"pack\": {\n    \"description\": \"%s\",\n    \"pack_format\": %d\n  }\n}", modid + " resources", packFormat);
        Files.write(mcmetaPath, jsonContent.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static void createJar(Path sourceDir, Path jarFile) throws IOException {
        try (JarOutputStream jos = new JarOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));
             Stream<Path> stream = Files.walk(sourceDir, new FileVisitOption[0]);){
            stream.filter(path -> !path.equals(sourceDir)).forEach(path -> {
                try {
                    Object entryName = sourceDir.relativize((Path)path).toString().replace("\\", "/");
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        entryName = (String)entryName + "/";
                    }
                    JarEntry entry = new JarEntry((String)entryName);
                    entry.setTime(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
                    jos.putNextEntry(entry);
                    if (Files.isRegularFile(path, new LinkOption[0])) {
                        Files.copy(path, jos);
                    }
                    jos.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to add " + path, e);
                }
            });
        }
    }

    public static void fastGenerateMod(String packId) throws IOException {
        ContentPackModInfo info = ContentPackModInfo.createPackInfo(packId).fromMetaData(packId).build();
        PackModGenerator.generateMod(info);
    }

    public static ContentPackModInfo.Builder createModInfo(String packId) {
        return new ContentPackModInfo.Builder();
    }

    public static ContentPackModInfo.Builder createModInfo(String packId, PackMetaData metaData) {
        return new ContentPackModInfo.Builder().fromMetaData(metaData);
    }

    public static ModDependency.Builder createModDependency(String modId) {
        return ModDependency.create(modId);
    }
}

