/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.utils.topo;

import com.whisent.kubeloader.utils.topo.TopoSortable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TopoNotSolved
extends RuntimeException {
    public final Collection<Map.Entry<Integer, Set<Integer>>> unsolved;
    private final List<? extends TopoSortable<?>> sortables;

    public TopoNotSolved(Collection<Map.Entry<Integer, Set<Integer>>> unsolved, List<? extends TopoSortable<?>> sortables) {
        this.unsolved = unsolved;
        this.sortables = sortables;
    }

    public TopoSortable<?> getFromIndex(int index) {
        return this.sortables.get(index);
    }

    public String getFullMessage() {
        ArrayList<Object> lines = new ArrayList<Object>(this.unsolved.size() + 1);
        lines.add(this.getMessage());
        for (Map.Entry<Integer, Set<Integer>> entry : this.unsolved) {
            TopoSortable<?> sortable = this.getFromIndex(entry.getKey());
            List<TopoSortable> dependencies = entry.getValue().stream().map(this::getFromIndex).toList();
            lines.add(sortable + " requires: " + dependencies);
        }
        return String.join((CharSequence)"\n", lines);
    }

    @Override
    public String getMessage() {
        String sortableInString = this.unsolved.stream().map(Map.Entry::getKey).map(this.sortables::get).map(Object::toString).collect(Collectors.joining(", "));
        return String.format("there are %s unsolved sortables: %s", this.unsolved.size(), sortableInString);
    }
}

