/*
 * Decompiled with CFR 0.152.
 */
package com.whisent.kubeloader.utils.topo;

import com.whisent.kubeloader.utils.topo.TopoNotSolved;
import com.whisent.kubeloader.utils.topo.TopoPreconditionFailed;
import com.whisent.kubeloader.utils.topo.TopoSortable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class TopoSort {
    public static <T extends TopoSortable<T>> List<T> sort(Collection<T> input) throws TopoNotSolved, TopoPreconditionFailed {
        List<Object> list;
        if (input instanceof List) {
            List l = (List)input;
            list = l;
        } else {
            list = new ArrayList<T>(input);
        }
        return TopoSort.sort(list);
    }

    private static <T extends TopoSortable<T>> HashMap<T, Integer> indexSortables(Collection<T> input) throws TopoPreconditionFailed {
        HashMap<TopoSortable, Integer> toIndexes = new HashMap<TopoSortable, Integer>();
        int i = 0;
        for (TopoSortable sortable : input) {
            Integer old = toIndexes.put(sortable, i++);
            if (old == null) continue;
            throw new TopoPreconditionFailed("values in index %s and %s are same values", i, old);
        }
        return toIndexes;
    }

    public static <T extends TopoSortable<T>> List<T> sort(List<T> input) throws TopoNotSolved, TopoPreconditionFailed {
        HashMap<T, Integer> indexes = TopoSort.indexSortables(input);
        TreeMap requiredBy = new TreeMap();
        TreeMap<Integer, Set<Integer>> requires = new TreeMap<Integer, Set<Integer>>();
        for (Map.Entry<T, Integer> entry : indexes.entrySet()) {
            TopoSortable topoSortable = (TopoSortable)entry.getKey();
            Integer index = entry.getValue();
            TreeSet<Integer> dependencyIndexes = new TreeSet<Integer>();
            for (TopoSortable dependency : topoSortable.getTopoDependencies()) {
                Integer depIndex = indexes.get(dependency);
                if (depIndex == null) {
                    throw new TopoPreconditionFailed("%s (dependency of %s) not in input", dependency, topoSortable);
                }
                if (depIndex.equals(index)) {
                    throw new TopoPreconditionFailed("%s claimed itself as its dependency", topoSortable);
                }
                dependencyIndexes.add(depIndex);
                requiredBy.computeIfAbsent(depIndex, k -> new TreeSet()).add(index);
            }
            requires.put(index, dependencyIndexes);
        }
        ArrayList<Integer> avaliables = new ArrayList<Integer>();
        for (Map.Entry<T, Integer> entry : indexes.entrySet()) {
            int dependencyCount = ((TopoSortable)entry.getKey()).getTopoDependencies().size();
            Integer index = entry.getValue();
            if (dependencyCount != 0) continue;
            avaliables.add(index);
        }
        ArrayList<TopoSortable> arrayList = new ArrayList<TopoSortable>();
        while (!avaliables.isEmpty()) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (Integer free : avaliables) {
                arrayList.add((TopoSortable)input.get(free));
                Set dependents = requiredBy.getOrDefault(free, Collections.emptySet());
                for (Integer dependent : dependents) {
                    Set<Integer> require = requires.get(dependent);
                    require.remove(free);
                    if (!require.isEmpty()) continue;
                    arrayList2.add(dependent);
                }
            }
            avaliables = arrayList2;
        }
        TopoSort.validateResult(requires, input);
        return arrayList;
    }

    private static <T extends TopoSortable<T>> void validateResult(Map<Integer, Set<Integer>> requires, List<T> input) throws TopoNotSolved {
        for (Set<Integer> require : requires.values()) {
            if (require.isEmpty()) continue;
            List<Map.Entry<Integer, Set<Integer>>> unsolved = requires.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).toList();
            throw new TopoNotSolved(unsolved, input);
        }
    }

    public static <T extends TopoSortable<T>> List<T> sortDense(List<T> input) throws TopoNotSolved, TopoPreconditionFailed {
        int size = input.size();
        HashMap<T, Integer> indexed = TopoSort.indexSortables(input);
        boolean[][] dependencies = new boolean[size][size];
        int[] dependencyCounts = new int[size];
        for (Map.Entry<T, Integer> e : indexed.entrySet()) {
            TopoSortable sortable = (TopoSortable)e.getKey();
            Integer index = e.getValue();
            for (TopoSortable dependency : sortable.getTopoDependencies()) {
                Integer depIndex = indexed.get(dependency);
                if (depIndex == null) {
                    throw new TopoPreconditionFailed("%s (dependency of %s) not in input", dependency, sortable);
                }
                if (depIndex.equals(index)) {
                    throw new TopoPreconditionFailed("%s claimed itself as its dependency", sortable);
                }
                dependencies[index.intValue()][depIndex.intValue()] = true;
            }
            dependencyCounts[index.intValue()] = sortable.getTopoDependencies().size();
        }
        ArrayList<Integer> avaliables = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            if (dependencyCounts[i] != 0) continue;
            avaliables.add(i);
        }
        ArrayList<TopoSortable> sorted = new ArrayList<TopoSortable>();
        while (!avaliables.isEmpty()) {
            ArrayList<Integer> newlyFree = new ArrayList<Integer>();
            for (Integer free : avaliables) {
                sorted.add((TopoSortable)input.get(free));
                for (int i = 0; i < size; ++i) {
                    if (!dependencies[i][free]) continue;
                    dependencies[i][free.intValue()] = false;
                    int n = i;
                    dependencyCounts[n] = dependencyCounts[n] - 1;
                    int newCount = dependencyCounts[n];
                    if (newCount != 0) continue;
                    newlyFree.add(i);
                }
            }
            avaliables = newlyFree;
        }
        for (int dependencyCount : dependencyCounts) {
            if (dependencyCount == 0) continue;
            throw TopoSort.denseNotSolved(dependencies, input);
        }
        return sorted;
    }

    private static TopoNotSolved denseNotSolved(boolean[][] dependencies, List<? extends TopoSortable<?>> input) {
        HashMap<Integer, Set> notSolved = new HashMap<Integer, Set>();
        int size = dependencies.length;
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                if (!dependencies[row][col]) continue;
                notSolved.computeIfAbsent(row, k -> new TreeSet()).add(col);
            }
        }
        return new TopoNotSolved(notSolved.entrySet(), input);
    }
}

