/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.acidisland.listeners;

import com.earth2me.essentials.Essentials;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import world.bentobox.acidisland.AcidIsland;
import world.bentobox.acidisland.events.AcidEvent;
import world.bentobox.acidisland.events.AcidRainEvent;
import world.bentobox.acidisland.events.EntityDamageByAcidEvent;
import world.bentobox.acidisland.world.AcidTask;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AcidEffect
implements Listener {
    private final AcidIsland addon;
    private final Map<Player, Long> burningPlayers;
    private final Map<Player, Long> wetPlayers;
    private Essentials essentials;
    private boolean essentialsCheck;
    private static final List<PotionEffectType> EFFECTS = !AcidEffect.inTest() ? List.of(PotionEffectType.BLINDNESS, PotionEffectType.NAUSEA, PotionEffectType.HUNGER, PotionEffectType.SLOWNESS, PotionEffectType.MINING_FATIGUE, PotionEffectType.WEAKNESS, PotionEffectType.POISON, PotionEffectType.DARKNESS, PotionEffectType.UNLUCK) : List.of();
    private static final List<PotionEffectType> IMMUNE_EFFECTS = !AcidEffect.inTest() ? List.of(PotionEffectType.WATER_BREATHING, PotionEffectType.CONDUIT_POWER) : List.of();

    private static boolean inTest() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(e -> e.getClassName().endsWith("Test"));
    }

    public AcidEffect(AcidIsland addon) {
        this.addon = addon;
        this.burningPlayers = new HashMap<Player, Long>();
        this.wetPlayers = new HashMap<Player, Long>();
        new AcidTask(addon);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeath(PlayerDeathEvent e) {
        this.burningPlayers.remove(e.getEntity());
        this.wetPlayers.remove(e.getEntity());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSeaBounce(PlayerMoveEvent e) {
        Player player = e.getPlayer();
        if (!player.getGameMode().equals((Object)GameMode.CREATIVE) && !player.getGameMode().equals((Object)GameMode.SPECTATOR) && player.getWorld().equals((Object)this.addon.getOverWorld()) && player.getLocation().getBlockY() < player.getWorld().getMinHeight()) {
            player.setVelocity(new Vector(player.getVelocity().getX(), 1.0, player.getVelocity().getZ()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        final Player player = e.getPlayer();
        if (this.addon.getSettings().getAcidRainDamage() == 0 && this.addon.getSettings().getAcidDamage() == 0 || player.isDead() || player.getGameMode().equals((Object)GameMode.CREATIVE) || player.getGameMode().equals((Object)GameMode.SPECTATOR) || this.addon.getPlayers().isInTeleport(player.getUniqueId()) || !Util.sameWorld((World)this.addon.getOverWorld(), (World)player.getWorld()) || !player.isOp() && player.hasPermission("acidisland.mod.noburn") || player.isOp() && !this.addon.getSettings().isAcidDamageOp()) {
            return;
        }
        if ((double)this.addon.getSettings().getAcidRainDamage() > 0.0 && this.addon.getOverWorld().hasStorm()) {
            if (this.isSafeFromRain(player)) {
                this.wetPlayers.remove(player);
            } else if (!this.wetPlayers.containsKey(player)) {
                this.wetPlayers.put(player, System.currentTimeMillis() + this.addon.getSettings().getAcidDamageDelay() * 1000L);
                new BukkitRunnable(){

                    public void run() {
                        if (AcidEffect.this.checkForRain(player)) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)this.addon.getPlugin(), 0L, 20L);
            }
        }
        if (this.burningPlayers.containsKey(player) || this.isSafeFromAcid(player)) {
            return;
        }
        this.burningPlayers.put(player, System.currentTimeMillis() + this.addon.getSettings().getAcidDamageDelay() * 1000L);
        new BukkitRunnable(){

            public void run() {
                if (AcidEffect.this.continuouslyHurtPlayer(player)) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.addon.getPlugin(), 0L, 20L);
    }

    protected boolean checkForRain(Player player) {
        if (!this.addon.getOverWorld().hasStorm() || player.isDead() || this.isSafeFromRain(player) || (double)this.addon.getSettings().getAcidRainDamage() <= 0.0) {
            this.wetPlayers.remove(player);
            return true;
        }
        if (this.wetPlayers.containsKey(player) && this.wetPlayers.get(player) < System.currentTimeMillis()) {
            double protection = (double)this.addon.getSettings().getAcidRainDamage() * AcidEffect.getDamageReduced((LivingEntity)player);
            User user = User.getInstance((Player)player);
            double percent = (double)(100 - Math.max(0, Math.min(100, user.getPermissionValue("acidisland.protection.rain", 0)))) / 100.0;
            double totalDamage = Math.max(0.0, (double)this.addon.getSettings().getAcidRainDamage() - protection) * percent;
            AcidRainEvent event = new AcidRainEvent(player, totalDamage, protection, this.addon.getSettings().getAcidRainEffects());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                event.getPotionEffects().stream().filter(EFFECTS::contains).forEach(t -> player.addPotionEffect(new PotionEffect(t, this.addon.getSettings().getRainEffectDuation() * 20, 1)));
                if (event.getRainDamage() > 0.0) {
                    EntityDamageByAcidEvent e = new EntityDamageByAcidEvent((Entity)player, event.getRainDamage(), EntityDamageByAcidEvent.Acid.RAIN);
                    Bukkit.getPluginManager().callEvent((Event)e);
                    if (!e.isCancelled()) {
                        player.damage(event.getRainDamage());
                        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_CREEPER_PRIMED, 3.0f, 3.0f);
                    }
                }
            }
        }
        return false;
    }

    protected boolean continuouslyHurtPlayer(Player player) {
        if (player.isDead() || this.isSafeFromAcid(player)) {
            this.burningPlayers.remove(player);
            return true;
        }
        if (this.burningPlayers.containsKey(player) && this.burningPlayers.get(player) < System.currentTimeMillis()) {
            double protection = (double)this.addon.getSettings().getAcidDamage() * AcidEffect.getDamageReduced((LivingEntity)player);
            User user = User.getInstance((Player)player);
            double percent = (double)(100 - Math.max(0, Math.min(100, user.getPermissionValue("acidisland.protection.acid", 0)))) / 100.0;
            double totalDamage = Math.max(0.0, (double)this.addon.getSettings().getAcidDamage() - protection) * percent;
            AcidEvent event = new AcidEvent(player, totalDamage, protection, this.addon.getSettings().getAcidEffects());
            this.addon.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                event.getPotionEffects().stream().filter(EFFECTS::contains).forEach(t -> player.addPotionEffect(new PotionEffect(t, this.addon.getSettings().getAcidEffectDuation() * 20, 1)));
                if (event.getTotalDamage() > 0.0) {
                    EntityDamageByAcidEvent e = new EntityDamageByAcidEvent((Entity)player, event.getTotalDamage(), EntityDamageByAcidEvent.Acid.WATER);
                    Bukkit.getPluginManager().callEvent((Event)e);
                    if (!e.isCancelled()) {
                        player.damage(event.getTotalDamage());
                        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_CREEPER_PRIMED, 3.0f, 3.0f);
                    }
                }
            }
        }
        return false;
    }

    private boolean isSafeFromRain(Player player) {
        block4: {
            block3: {
                if (this.isEssentialsGodMode(player) || player.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) || player.getGameMode() != GameMode.SURVIVAL || player.getWorld().getEnvironment().equals((Object)World.Environment.THE_END) || this.addon.getSettings().isHelmetProtection() && player.getInventory().getHelmet() != null && player.getInventory().getHelmet().getType().name().contains("HELMET") || !this.addon.getSettings().isAcidDamageSnow() && player.getLocation().getBlock().getTemperature() < 0.1 || player.getLocation().getBlock().getHumidity() == 0.0) break block3;
                if (!player.getActivePotionEffects().stream().map(PotionEffect::getType).anyMatch(IMMUNE_EFFECTS::contains) && (!this.addon.getPlugin().getIWM().getIvSettings(player.getWorld()).contains(EntityDamageEvent.DamageCause.CUSTOM.name()) || this.addon.getIslands().userIsOnIsland(player.getWorld(), User.getInstance((Player)player)))) break block4;
            }
            return true;
        }
        for (int y = player.getLocation().getBlockY() + 2; y < player.getLocation().getWorld().getMaxHeight(); ++y) {
            if (player.getLocation().getWorld().getBlockAt(player.getLocation().getBlockX(), y, player.getLocation().getBlockZ()).getType().equals((Object)Material.AIR)) continue;
            return true;
        }
        return false;
    }

    boolean isSafeFromAcid(Player player) {
        if (this.isEssentialsGodMode(player) || player.getGameMode() != GameMode.SURVIVAL || this.addon.getPlugin().getIWM().getIvSettings(player.getWorld()).contains(EntityDamageEvent.DamageCause.CUSTOM.name()) && !this.addon.getIslands().userIsOnIsland(player.getWorld(), User.getInstance((Player)player))) {
            return true;
        }
        if (!(player.getLocation().getBlock().getType().equals((Object)Material.WATER) || player.getLocation().getBlock().getType().equals((Object)Material.BUBBLE_COLUMN) || player.getLocation().getBlock().getType().equals((Object)Material.SNOW) && this.addon.getSettings().isAcidDamageSnow() || player.getLocation().getBlock().getRelative(BlockFace.UP).getType().equals((Object)Material.WATER))) {
            return true;
        }
        if (player.getVehicle() != null && (player.getVehicle().getType().getKey().getKey().contains("boat") || player.getVehicle().getType().getKey().getKey().contains("raft"))) {
            return true;
        }
        if (this.addon.getSettings().isFullArmorProtection() && Arrays.stream(player.getInventory().getArmorContents()).allMatch(i -> i != null && !i.getType().equals((Object)Material.AIR))) {
            return true;
        }
        return player.getActivePotionEffects().stream().map(PotionEffect::getType).anyMatch(IMMUNE_EFFECTS::contains);
    }

    private boolean isEssentialsGodMode(Player player) {
        if (!this.essentialsCheck && this.essentials == null) {
            this.essentials = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
            this.essentialsCheck = true;
        }
        return this.essentials != null && this.essentials.getUser(player).isGodModeEnabled();
    }

    public static double getDamageReduced(LivingEntity le) {
        double red = le.getAttribute(Attribute.ARMOR).getValue() * 0.04;
        EntityEquipment inv = le.getEquipment();
        ItemStack boots = inv.getBoots();
        ItemStack helmet = inv.getHelmet();
        ItemStack chest = inv.getChestplate();
        ItemStack pants = inv.getLeggings();
        if (helmet != null && helmet.getType().name().contains("HELMET") && AcidEffect.damage(helmet)) {
            le.getWorld().playSound(le.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            inv.setHelmet(null);
        }
        if (boots != null && AcidEffect.damage(boots)) {
            le.getWorld().playSound(le.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            inv.setBoots(null);
        }
        if (pants != null && AcidEffect.damage(pants)) {
            le.getWorld().playSound(le.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            inv.setLeggings(null);
        }
        if (chest != null && AcidEffect.damage(chest)) {
            le.getWorld().playSound(le.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            inv.setChestplate(null);
        }
        return red;
    }

    private static boolean damage(ItemStack item) {
        ItemMeta im = item.getItemMeta();
        if (im instanceof Damageable) {
            Damageable d = (Damageable)im;
            if (!im.isUnbreakable()) {
                d.setDamage(d.getDamage() + 1);
                item.setItemMeta((ItemMeta)d);
                return d.getDamage() >= item.getType().getMaxDurability();
            }
        }
        return false;
    }
}

