/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.pigmod.fluid;

import net.mcreator.pigmod.init.PigModModBlocks;
import net.mcreator.pigmod.init.PigModModFluidTypes;
import net.mcreator.pigmod.init.PigModModFluids;
import net.mcreator.pigmod.init.PigModModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class MilkFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)PigModModFluidTypes.MILK_TYPE.get(), () -> (Fluid)PigModModFluids.MILK.get(), () -> (Fluid)PigModModFluids.FLOWING_MILK.get()).explosionResistance(100.0f).tickRate(7).bucket(() -> (Item)PigModModItems.MILK_BUCKET.get()).block(() -> (LiquidBlock)PigModModBlocks.MILK.get());

    private MilkFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.FALLING_WATER;
    }

    public static class Flowing
    extends MilkFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends MilkFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

