/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.client.renderer.entity;

import com.jusipat.astikorcartsredux.client.renderer.entity.DrawnRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import tfcastikorcarts.client.TFCAstikorCartsModelLayers;
import tfcastikorcarts.client.renderer.entity.model.TFCAnimalCartModel;
import tfcastikorcarts.common.entities.carts.TFCAnimalCartEntity;
import tfcastikorcarts.util.AstikorHelpers;

public class TFCAnimalCartRenderer
extends DrawnRenderer<TFCAnimalCartEntity, TFCAnimalCartModel> {
    public TFCAnimalCartRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (EntityModel)new TFCAnimalCartModel(renderManager.bakeLayer(TFCAstikorCartsModelLayers.ANIMAL_CART)));
        this.shadowRadius = 1.0f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(TFCAnimalCartEntity entity) {
        return AstikorHelpers.identifier("textures/entity/animal_cart/" + entity.getTFCWoodType().getSerializedName() + ".png");
    }

    protected void renderContents(TFCAnimalCartEntity entity, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        if (entity.getBannerColor() != null) {
            stack.pushPose();
            ((TFCAnimalCartModel)this.model).getBody().translateAndRotate(stack);
            stack.translate(0.0, -0.6, 1.56);
            this.renderBanner(entity, stack, source, delta, packedLight, entity.getBannerColor(), entity.getBannerPattern());
            stack.popPose();
        }
    }
}

