/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.client.renderer.entity;

import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.client.renderer.entity.CargoRenderUtil;
import com.jusipat.astikorcartsredux.client.renderer.entity.DrawnRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import tfcastikorcarts.client.TFCAstikorCartsModelLayers;
import tfcastikorcarts.client.renderer.entity.model.TFCHandCartModel;
import tfcastikorcarts.common.AstikorTags;
import tfcastikorcarts.common.entities.carts.TFCHandCartEntity;
import tfcastikorcarts.util.AstikorHelpers;

public class TFCHandCartRenderer
extends DrawnRenderer<TFCHandCartEntity, TFCHandCartModel> {
    public final HumanoidModel<LivingEntity> leggings;
    public final HumanoidModel<LivingEntity> armor;
    public final TextureAtlas armorTrimAtlas;

    public TFCHandCartRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (EntityModel)new TFCHandCartModel(renderManager.bakeLayer(TFCAstikorCartsModelLayers.HAND_CART)));
        this.leggings = new HumanoidModel(renderManager.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
        this.armor = new HumanoidModel(renderManager.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR));
        this.armorTrimAtlas = renderManager.getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
        this.shadowRadius = 1.0f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(TFCHandCartEntity entity) {
        return AstikorHelpers.identifier("textures/entity/hand_cart/" + entity.getTFCWoodType().getSerializedName() + ".png");
    }

    protected void renderContents(TFCHandCartEntity entity, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        ItemStack s;
        NonNullList<ItemStack> cargo = entity.getCargo();
        Contents contents = Contents.SUPPLIES;
        Iterator it = cargo.iterator();
        block0: while (it.hasNext()) {
            s = (ItemStack)it.next();
            if (s.isEmpty()) continue;
            for (Contents c : Contents.values()) {
                if (!c.predicate.test((ItemStack)s)) continue;
                contents = c;
                break block0;
            }
        }
        while (contents != Contents.SUPPLIES && it.hasNext()) {
            s = (ItemStack)it.next();
            if (s.isEmpty() || contents.predicate.test((ItemStack)s)) continue;
            contents = Contents.SUPPLIES;
            if (contents.predicate.test((ItemStack)s)) continue;
            contents = Contents.NONE;
        }
        stack.pushPose();
        ((TFCHandCartModel)this.model).getBody().translateAndRotate(stack);
        if (contents.renderer != null) {
            contents.renderer.render(this, entity, stack, source, packedLight, cargo);
        }
        stack.popPose();
    }

    public void renderFlowers(TFCHandCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        ((TFCHandCartModel)this.model).getFlowerBasket().render(stack, source.getBuffer(((TFCHandCartModel)this.model).renderType(this.getTextureLocation(entity))), packedLight, OverlayTexture.NO_OVERLAY);
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer renderer = dispatcher.getModelRenderer();
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (!(itemStack.getItem() instanceof BlockItem)) continue;
            int ix = i % 2;
            int iz = i / 2;
            BlockState defaultState = ((BlockItem)itemStack.getItem()).getBlock().defaultBlockState();
            BlockState state = defaultState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) ? (BlockState)defaultState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER) : defaultState;
            BakedModel model = dispatcher.getBlockModel(state);
            int rgb = Minecraft.getInstance().getBlockColors().getColor(state, null, null, 0);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            stack.pushPose();
            stack.translate(0.0, -0.7, -0.0625);
            stack.scale(0.65f, 0.65f, 0.65f);
            stack.translate((double)ix, 0.5, (double)iz - 1.0);
            stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            renderer.renderModel(stack.last(), source.getBuffer(RenderType.cutout()), state, model, r, g, b, packedLight, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
            stack.popPose();
        }
    }

    public void renderWheel(TFCHandCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        stack.pushPose();
        stack.translate(0.91, 0.05, -0.15);
        ModelPart wheel = ((TFCHandCartModel)this.model).getWheel();
        wheel.xRot = 0.9f;
        wheel.zRot = 0.9424779f;
        wheel.render(stack, source.getBuffer(((TFCHandCartModel)this.model).renderType(this.getTextureLocation(entity))), packedLight, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }

    public void renderPaintings(TFCHandCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        VertexConsumer buf = source.getBuffer(RenderType.entitySolid((ResourceLocation)Minecraft.getInstance().getPaintingTextures().getBackSprite().atlasLocation()));
        Random rng = new Random(entity.getUUID().getMostSignificantBits() ^ entity.getUUID().getLeastSignificantBits());
        stack.pushPose();
        stack.translate(0.0, -0.15625, 0.0);
        stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        RegistryAccess registryAccess = entity.level().registryAccess();
        ObjectArrayList variants = new ObjectArrayList();
        registryAccess.registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE).forEach(arg_0 -> TFCHandCartRenderer.lambda$renderPaintings$0((ObjectList)variants, arg_0));
        ObjectLists.shuffle((ObjectList)variants, (Random)rng);
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (itemStack.isEmpty()) continue;
            CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
            Optional<Object> paintingVariant = Optional.empty();
            if (!customData.isEmpty()) {
                paintingVariant = customData.read((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (MapDecoder)Painting.VARIANT_MAP_CODEC).result().map(Holder::value);
            }
            if (paintingVariant.isEmpty() || ((PaintingVariant)paintingVariant.get()).area() > 1) {
                if (variants.isEmpty()) continue;
                paintingVariant = Optional.of((PaintingVariant)variants.get(i % variants.size()));
            }
            stack.pushPose();
            stack.translate(0.0, 0.03, -0.0625 * (double)i + (double)1.0E-4f);
            stack.mulPose(Axis.ZP.rotation(rng.nextFloat() * (float)Math.PI * 0.2f));
            CargoRenderUtil.renderPainting((PaintingVariant)((PaintingVariant)paintingVariant.get()), (PoseStack)stack, (VertexConsumer)buf, (int)packedLight);
            stack.popPose();
        }
        stack.popPose();
    }

    public void renderSupplies(TFCHandCartEntity entity, PoseStack stack, MultiBufferSource source, int packedLight, NonNullList<ItemStack> cargo) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        Random rng = new Random();
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (itemStack.isEmpty()) continue;
            int ix = i % 2;
            int iz = i / 2;
            if (i < cargo.size() - 2 && ((ItemStack)cargo.get(i + 2)).is(ItemTags.BEDS) || i >= 2 && ((ItemStack)cargo.get(i - 2)).is(ItemTags.BEDS)) continue;
            double x = (double)((ix * 2 - 1) * 4) / 16.0;
            double z = (double)((iz * 2 - 1) * 5) / 16.0;
            BakedModel model = renderer.getModel(itemStack, entity.level(), null, i);
            stack.pushPose();
            if (model.isGui3d() && itemStack.getItem() != Items.TRIDENT && ((Boolean)AstikorCartsReduxConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                stack.translate(x, -0.46, z);
                stack.scale(0.5f, 0.5f, 0.5f);
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                if (itemStack.getItem() == Items.SHIELD) {
                    stack.scale(1.2f, 1.2f, 1.2f);
                    stack.mulPose(Axis.YP.rotationDegrees(ix == 0 ? -90.0f : 90.0f));
                    stack.translate(0.5, 0.8, -0.05);
                    stack.mulPose(Axis.XP.rotationDegrees(-22.5f));
                } else if (iz < 1 && itemStack.is(ItemTags.BEDS)) {
                    stack.translate(0.0, 0.0, 1.0);
                } else if (!model.isCustomRenderer()) {
                    stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                }
                renderer.render(itemStack, ItemDisplayContext.NONE, false, stack, source, packedLight, OverlayTexture.NO_OVERLAY, model);
            } else {
                rng.setSeed(32L * (long)i + (long)Objects.hashCode(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem())));
                stack.translate(x, -0.15 + ((ix + iz) % 2 == 0 ? 0.0 : 1.0E-4), z);
                if (ArmorItem.class.equals(itemStack.getItem().getClass()) && ((Boolean)AstikorCartsReduxConfig.getClient().renderSupplyGear.get()).booleanValue()) {
                    stack.scale(0.9f, 0.9f, 0.9f);
                    this.renderArmor(stack, source, packedLight, itemStack, ix);
                } else {
                    stack.scale(0.6f, 0.6f, 0.6f);
                    stack.mulPose(Axis.YP.rotation(rng.nextFloat() * (float)Math.PI));
                    stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    int copies = Math.min(itemStack.getCount(), (itemStack.getCount() - 1) / 16 + 2);
                    renderer.render(itemStack, ItemDisplayContext.FIXED, false, stack, source, packedLight, OverlayTexture.NO_OVERLAY, model);
                    for (int n = 1; n < copies; ++n) {
                        stack.pushPose();
                        stack.mulPose(Axis.ZP.rotation(rng.nextFloat() * (float)Math.PI));
                        stack.translate((double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), -0.1 * (double)n);
                        renderer.render(itemStack, ItemDisplayContext.FIXED, false, stack, source, packedLight, OverlayTexture.NO_OVERLAY, model);
                        stack.popPose();
                    }
                }
            }
            stack.popPose();
        }
    }

    public EquipmentSlot getEquipmentSlotForItem(ItemStack itemStack) {
        Equipable equipable = Equipable.get((ItemStack)itemStack);
        if (equipable != null) {
            return equipable.getEquipmentSlot();
        }
        return EquipmentSlot.MAINHAND;
    }

    public void renderArmor(PoseStack stack, MultiBufferSource source, int packedLight, ItemStack itemStack, int ix) {
        Item item = itemStack.getItem();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item;
        EquipmentSlot slot = this.getEquipmentSlotForItem(itemStack);
        HumanoidModel<LivingEntity> m = slot == EquipmentSlot.LEGS ? this.leggings : this.armor;
        stack.mulPose(Axis.YP.rotation(ix == 0 ? 1.5707964f : -1.5707964f));
        m.setAllVisible(false);
        m.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        m.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        m.crouching = false;
        m.swimAmount = 0.0f;
        m.young = false;
        switch (slot) {
            case HEAD: {
                stack.translate(0.0, 0.1, 0.0);
                m.head.xRot = 0.2f;
                m.hat.copyFrom(m.head);
                m.head.visible = true;
                m.hat.visible = true;
                break;
            }
            case CHEST: {
                stack.translate(0.0, -0.4, -0.15);
                m.leftArm.xRot = -0.15f;
                m.rightArm.xRot = -0.15f;
                m.body.xRot = 0.9f;
                m.body.visible = true;
                m.rightArm.visible = true;
                m.leftArm.visible = true;
                break;
            }
            case LEGS: {
                stack.translate(0.0, -0.7, -0.15);
                m.body.xRot = 0.0f;
                m.rightLeg.xRot = 1.2f;
                m.leftLeg.xRot = 1.2f;
                m.rightLeg.yRot = -0.3f;
                m.leftLeg.yRot = 0.3f;
                m.body.visible = true;
                m.rightLeg.visible = true;
                m.leftLeg.visible = true;
                break;
            }
            case FEET: {
                stack.translate(0.0, -1.15, -0.1);
                m.rightLeg.xRot = 0.0f;
                m.leftLeg.xRot = 0.0f;
                m.rightLeg.yRot = -0.1f;
                m.leftLeg.yRot = 0.0f;
                m.rightLeg.visible = true;
                m.leftLeg.visible = true;
            }
        }
        stack.scale(0.75f, 0.75f, 0.75f);
        ArmorMaterial material = (ArmorMaterial)armorItem.getMaterial().value();
        int rgb = itemStack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)itemStack, (int)-6265536)) : -1;
        boolean usesInnerModel = slot == EquipmentSlot.LEGS;
        for (ArmorMaterial.Layer layer : material.layers()) {
            int k = layer.dyeable() ? rgb : -1;
            VertexConsumer vertexConsumer = source.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)layer.texture(usesInnerModel)));
            m.renderToBuffer(stack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, k);
        }
        ArmorTrim armorTrim = (ArmorTrim)itemStack.get(DataComponents.TRIM);
        if (armorTrim != null) {
            TextureAtlasSprite textureAtlasSprite = this.armorTrimAtlas.getSprite(usesInnerModel ? armorTrim.innerTexture(armorItem.getMaterial()) : armorTrim.outerTexture(armorItem.getMaterial()));
            VertexConsumer vertexConsumer = textureAtlasSprite.wrap(source.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)armorTrim.pattern().value()).decal())));
            m.renderToBuffer(stack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, rgb);
        }
        if (itemStack.hasFoil()) {
            m.renderToBuffer(stack, source.getBuffer(RenderType.armorEntityGlint()), packedLight, OverlayTexture.NO_OVERLAY, rgb);
        }
    }

    private static /* synthetic */ void lambda$renderPaintings$0(ObjectList variants, Holder variantHolder) {
        if (((PaintingVariant)variantHolder.value()).area() == 1) {
            variants.add((Object)((PaintingVariant)variantHolder.value()));
        }
    }

    public static enum Contents {
        FLOWERS(s -> s.getItem() instanceof BlockItem && s.is(ItemTags.FLOWERS) && (Boolean)AstikorCartsReduxConfig.getClient().renderSupplyFlowers.get() != false, TFCHandCartRenderer::renderFlowers),
        PAINTINGS(s -> s.getItem() instanceof HangingEntityItem && (Boolean)AstikorCartsReduxConfig.getClient().renderSupplyPaintings.get() != false, TFCHandCartRenderer::renderPaintings),
        WHEEL(s -> s.is(AstikorTags.Items.CART_WHEEL) && (Boolean)AstikorCartsReduxConfig.getClient().renderSupplyWheel.get() != false, TFCHandCartRenderer::renderWheel),
        SUPPLIES(s -> (Boolean)AstikorCartsReduxConfig.getClient().renderSupplies.get(), TFCHandCartRenderer::renderSupplies),
        NONE(s -> true, null);

        public final Predicate<? super ItemStack> predicate;
        public final ContentsRenderer renderer;

        private Contents(Predicate<? super ItemStack> predicate, ContentsRenderer renderer) {
            this.predicate = predicate;
            this.renderer = renderer;
        }
    }

    @FunctionalInterface
    public static interface ContentsRenderer {
        public void render(TFCHandCartRenderer var1, TFCHandCartEntity var2, PoseStack var3, MultiBufferSource var4, int var5, NonNullList<ItemStack> var6);
    }
}

