/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.client.renderer.entity;

import com.jusipat.astikorcartsredux.client.renderer.entity.DrawnRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tfcastikorcarts.client.TFCAstikorCartsModelLayers;
import tfcastikorcarts.client.renderer.entity.model.TFCPlowModel;
import tfcastikorcarts.common.entities.carts.TFCPlowEntity;
import tfcastikorcarts.util.AstikorHelpers;

public class TFCPlowRenderer
extends DrawnRenderer<TFCPlowEntity, TFCPlowModel> {
    public TFCPlowRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (EntityModel)new TFCPlowModel(renderManager.bakeLayer(TFCAstikorCartsModelLayers.PLOW)));
        this.shadowRadius = 1.0f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(TFCPlowEntity entity) {
        return AstikorHelpers.identifier("textures/entity/plow/" + entity.getTFCWoodType().getSerializedName() + ".png");
    }

    protected void renderContents(TFCPlowEntity entity, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        for (int i = 0; i < entity.getItemStacks().size(); ++i) {
            ItemStack itemStack = entity.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            this.attach(((TFCPlowModel)this.model).getBody(), ((TFCPlowModel)this.model).getShaft(i), s -> {
                s.mulPose(Axis.XP.rotationDegrees(-90.0f));
                s.mulPose(Axis.YP.rotationDegrees(90.0f));
                s.translate(-0.25, 0.0625, 0.0);
                if (itemStack.getItem() instanceof BlockItem) {
                    s.translate(0.0, -0.1, 0.0);
                    s.mulPose(Axis.ZP.rotationDegrees(180.0f));
                }
                Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, s, source, entity.level(), 0);
            }, stack);
        }
    }
}

