/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.client.renderer.entity.model;

import com.jusipat.astikorcartsredux.client.renderer.entity.model.CartModel;
import com.jusipat.astikorcartsredux.client.renderer.entity.model.EasyMeshBuilder;
import com.jusipat.astikorcartsredux.entity.AbstractDrawnEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import tfcastikorcarts.common.entities.carts.TFCPlowEntity;

public class TFCPlowModel
extends CartModel<TFCPlowEntity> {
    public final ModelPart[] plowShaftUpper = new ModelPart[3];
    public final ModelPart[] plowShaftLower = new ModelPart[3];

    public TFCPlowModel(ModelPart root) {
        super(root);
        ModelPart parts = root.getChild("body").getChild("parts");
        for (int i = 0; i < this.plowShaftUpper.length; ++i) {
            this.plowShaftUpper[i] = parts.getChild("plow_shaft_upper_" + i);
            this.plowShaftLower[i] = this.plowShaftUpper[i].getChild("plow_shaft_lower_" + i);
        }
    }

    public ModelPart getShaft(int original) {
        return this.plowShaftLower[original];
    }

    public void setupAnim(TFCPlowEntity entity, float delta, float limbSwingAmount, float ageInTicks, float netHeadYaw, float pitch) {
        super.setupAnim((AbstractDrawnEntity)entity, delta, limbSwingAmount, ageInTicks, netHeadYaw, pitch);
        for (ModelPart renderer : this.plowShaftUpper) {
            renderer.xRot = (float)(entity.getPlowing() ? 0.7853981633974483 - Math.toRadians(pitch) : 1.2566370614359172);
        }
    }

    public static LayerDefinition createLayer() {
        MeshDefinition def = TFCPlowModel.createDefinition((float)9.0f, (float)25.0f);
        EasyMeshBuilder axis = new EasyMeshBuilder("axis", 0, 0);
        axis.addBox(-12.5f, -1.0f, -1.0f, 25.0f, 2.0f, 2.0f);
        EasyMeshBuilder[] triangle = new EasyMeshBuilder[3];
        triangle[0] = new EasyMeshBuilder("triangle_0", 0, 4);
        triangle[0].addBox(-7.5f, -9.0f, 0.0f, 15.0f, 2.0f, 2.0f);
        triangle[1] = new EasyMeshBuilder("triangle_1", 0, 11);
        triangle[1].addBox(-5.0f, -9.0f, 0.5f, 2.0f, 14.0f, 2.0f);
        triangle[1].zRot = -0.175f;
        triangle[2] = new EasyMeshBuilder("triangle_2", 0, 11);
        triangle[2].mirror(true);
        triangle[2].addBox(3.0f, -9.0f, 0.5f, 2.0f, 14.0f, 2.0f);
        triangle[2].zRot = 0.175f;
        EasyMeshBuilder shaft = new EasyMeshBuilder("shaft", 0, 8);
        shaft.zRot = -0.07f;
        shaft.addBox(0.0f, 0.0f, -8.0f, 20.0f, 2.0f, 1.0f);
        shaft.addBox(0.0f, 0.0f, 7.0f, 20.0f, 2.0f, 1.0f);
        EasyMeshBuilder shaftConnector = new EasyMeshBuilder("shaftConnector", 0, 27);
        shaftConnector.zRot = -0.26f;
        shaftConnector.addBox(-16.0f, 0.0f, -8.0f, 16.0f, 2.0f, 1.0f);
        shaftConnector.addBox(-16.0f, 0.0f, 7.0f, 16.0f, 2.0f, 1.0f);
        EasyMeshBuilder shafts = new EasyMeshBuilder("shafts");
        shafts.setRotationPoint(0.0f, 0.0f, -14.0f);
        shafts.yRot = 1.5707964f;
        shafts.addChild(shaft);
        shafts.addChild(shaftConnector);
        EasyMeshBuilder[] plowShaftUpper = new EasyMeshBuilder[3];
        EasyMeshBuilder[] plowShaftLower = new EasyMeshBuilder[3];
        for (int i = 0; i < plowShaftUpper.length; ++i) {
            plowShaftUpper[i] = new EasyMeshBuilder("plow_shaft_upper_" + i, 56, 0);
            plowShaftUpper[i].addBox(-1.0f, -2.0f, -2.0f, 2.0f, 30.0f, 2.0f);
            plowShaftUpper[i].setRotationPoint(-3.0f + (float)(3 * i), -7.0f, 0.0f);
            plowShaftUpper[i].yRot = -0.523599f + 0.5235988f * (float)i;
            plowShaftLower[i] = new EasyMeshBuilder("plow_shaft_lower_" + i, 42, 4);
            plowShaftLower[i].addBox(-1.0f, -0.7f, -0.7f, 2.0f, 10.0f, 2.0f);
            plowShaftLower[i].setRotationPoint(0.0f, 28.0f, -1.0f);
            plowShaftLower[i].xRot = 0.7853982f;
            plowShaftUpper[i].addChild(plowShaftLower[i]);
        }
        EasyMeshBuilder plowHandle = new EasyMeshBuilder("plow_handle", 50, 4);
        plowHandle.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 18.0f, 1.0f);
        plowHandle.setRotationPoint(0.0f, 33.0f, 5.0f);
        plowHandle.xRot = 1.5707964f;
        plowShaftUpper[1].addChild(plowHandle);
        EasyMeshBuilder plowHandleGrip = new EasyMeshBuilder("plow_handle_grip", 50, 23);
        plowHandleGrip.addBox(-0.5f, 0.0f, -1.0f, 1.0f, 5.0f, 1.0f);
        plowHandleGrip.setRotationPoint(0.0f, 32.8f, 21.0f);
        plowHandleGrip.xRot = 0.7853982f;
        plowShaftUpper[1].addChild(plowHandleGrip);
        EasyMeshBuilder parts = new EasyMeshBuilder("parts");
        parts.setRotationPoint(0.0f, -5.0f, -1.0f);
        parts.addChild(shafts);
        parts.addChild(triangle[0]);
        parts.addChild(triangle[1]);
        parts.addChild(triangle[2]);
        parts.addChild(plowShaftUpper[0]);
        parts.addChild(plowShaftUpper[1]);
        parts.addChild(plowShaftUpper[2]);
        EasyMeshBuilder body = TFCPlowModel.createBody((int)9);
        body.addChild(axis);
        body.addChild(parts);
        body.build(def.getRoot());
        return LayerDefinition.create((MeshDefinition)def, (int)64, (int)64);
    }
}

