/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import tfcastikorcarts.common.container.DynamicGridContainer;
import tfcastikorcarts.util.AstikorHelpers;

public class DynamicGridScreen
extends AbstractContainerScreen<DynamicGridContainer> {
    public static final ResourceLocation BACKGROUND = AstikorHelpers.identifier("textures/gui/inventory_grid.png");
    public static final ResourceLocation SLOT_TEXTURE = AstikorHelpers.identifier("textures/gui/inventory_slot.png");
    public static final ResourceLocation PLAYER_INVENTORY = AstikorHelpers.identifier("textures/gui/player_inventory.png");
    public static final int SLOT_SIZE = 18;
    public static final int MARGIN = 7;
    public static final int PLAYER_SLOTS_WIDTH = 162;
    public static final int PLAYER_TEX_WIDTH = 184;
    public static final int PLAYER_TEX_HEIGHT = 90;
    public static final int BACKGROUND_TEX_SIZE = 64;
    public static final int MIN_GRID_WIDTH_SLOTS = 9;

    public DynamicGridScreen(DynamicGridContainer menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.imageWidth = 14 + Math.max(menu.getWidth() * 18, 162);
        this.imageHeight = 112 + menu.getHeight() * 18;
    }

    protected void init() {
        super.init();
        this.titleLabelX = 8;
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int corner = 7;
        int rightU = 64 - corner;
        int bottomV = 64 - corner;
        int tileW = 64 - 2 * corner;
        int tileH = 64 - 2 * corner;
        int actualWidthSlots = ((DynamicGridContainer)this.menu).getWidth();
        int slotAreaWidth = actualWidthSlots * 18;
        int minSlotAreaWidth = 162;
        int displaySlotAreaWidth = Math.max(slotAreaWidth, minSlotAreaWidth);
        int baseBgWidth = 14 + displaySlotAreaWidth;
        int bgGridW = baseBgWidth + 8;
        int bgGridX = (this.imageWidth - bgGridW) / 2 + this.leftPos - 1;
        int actualGridH = ((DynamicGridContainer)this.menu).getHeight() > 0 ? ((DynamicGridContainer)this.menu).getHeight() * 18 : 0;
        int bgGridH = 18 + actualGridH + 5;
        if (actualGridH == 0) {
            bgGridH = Math.max(bgGridH, 43);
        }
        this.drawNineSlice(graphics, bgGridX, this.topPos, bgGridW, bgGridH, corner, rightU, bottomV, tileW, tileH);
        for (Slot slot : ((DynamicGridContainer)this.menu).slots) {
            if (slot.container != ((DynamicGridContainer)this.menu).getContainer()) continue;
            graphics.blit(SLOT_TEXTURE, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        int playerStartX = (this.imageWidth - 162) / 2;
        int playerTexX = this.leftPos + playerStartX - 11;
        int invY = 18 + ((DynamicGridContainer)this.menu).getHeight() * 18 + 12;
        graphics.blit(PLAYER_INVENTORY, playerTexX - 1, this.topPos + invY - 8, 0.0f, 0.0f, 184, 90, 184, 90);
    }

    public void drawNineSlice(GuiGraphics graphics, int x, int y, int w, int h, int corner, int rightU, int bottomV, int tileW, int tileH) {
        int bh;
        int ty;
        int edgeWidth = w - 2 * corner;
        int edgeHeight = h - 2 * corner;
        graphics.blit(BACKGROUND, x, y, 0.0f, 0.0f, corner, corner, 64, 64);
        graphics.blit(BACKGROUND, x + w - corner, y, (float)rightU, 0.0f, corner, corner, 64, 64);
        graphics.blit(BACKGROUND, x, y + h - corner, 0.0f, (float)bottomV, corner, corner, 64, 64);
        graphics.blit(BACKGROUND, x + w - corner, y + h - corner, (float)rightU, (float)bottomV, corner, corner, 64, 64);
        for (int tx = 0; tx < edgeWidth; tx += tileW) {
            int bw = Math.min(tileW, edgeWidth - tx);
            graphics.blit(BACKGROUND, x + corner + tx, y, (float)corner, 0.0f, bw, corner, 64, 64);
            graphics.blit(BACKGROUND, x + corner + tx, y + h - corner, (float)corner, (float)bottomV, bw, corner, 64, 64);
        }
        for (ty = 0; ty < edgeHeight; ty += tileH) {
            bh = Math.min(tileH, edgeHeight - ty);
            graphics.blit(BACKGROUND, x, y + corner + ty, 0.0f, (float)corner, corner, bh, 64, 64);
            graphics.blit(BACKGROUND, x + w - corner, y + corner + ty, (float)rightU, (float)corner, corner, bh, 64, 64);
        }
        for (ty = 0; ty < edgeHeight; ty += tileH) {
            bh = Math.min(tileH, edgeHeight - ty);
            for (int tx = 0; tx < edgeWidth; tx += tileW) {
                int bw = Math.min(tileW, edgeWidth - tx);
                graphics.blit(BACKGROUND, x + corner + tx, y + corner + ty, (float)corner, (float)corner, bw, bh, 64, 64);
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}

