/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common;

import java.util.Locale;
import java.util.function.Supplier;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import tfcastikorcarts.common.entities.carts.TFCAnimalCartEntity;
import tfcastikorcarts.common.entities.carts.TFCHandCartEntity;
import tfcastikorcarts.common.entities.carts.TFCPlowEntity;
import tfcastikorcarts.common.entities.carts.TFCReaperEntity;
import tfcastikorcarts.common.entities.carts.TFCSeedDrillEntity;
import tfcastikorcarts.common.entities.carts.TFCSupplyCartEntity;
import tfcastikorcarts.common.items.AstikorItems;
import tfcastikorcarts.config.TFCAstikorCartsConfig;

public enum CartType {
    ANIMAL_CART("animal_cart", 1.3f, 1.4f, TFCAnimalCartEntity::new),
    HAND_CART("hand_cart", 1.3f, 1.1f, TFCAstikorCartsConfig.COMMON.handCartInventoryWidth.get(), TFCAstikorCartsConfig.COMMON.handCartInventoryHeight.get(), TFCHandCartEntity::new),
    PLOW("plow", 1.3f, 1.4f, TFCPlowEntity::new),
    REAPER("reaper", 1.3f, 1.4f, TFCReaperEntity::new),
    SEED_DRILL("seed_drill", 1.3f, 1.4f, 9, 1, TFCSeedDrillEntity::new),
    SUPPLY_CART("supply_cart", 1.5f, 1.4f, TFCAstikorCartsConfig.COMMON.supplyCartInventoryWidth.get(), TFCAstikorCartsConfig.COMMON.supplyCartInventoryHeight.get(), TFCSupplyCartEntity::new);

    public final String serializedName = this.name().toLowerCase(Locale.ROOT);
    public final float width;
    public final float height;
    private final Supplier<Integer> containerWidth;
    private final Supplier<Integer> containerHeight;
    public final CartEntityFactory<?> factory;

    private CartType(String id, float width, float height, CartEntityFactory<?> factory) {
        this(id, width, height, () -> 0, () -> 0, factory);
    }

    private CartType(String id, float width, float height, int containerWidth, int containerHeight, CartEntityFactory<?> factory) {
        this(id, width, height, () -> containerWidth, () -> containerHeight, factory);
    }

    private CartType(String id, float width, float height, Supplier<Integer> containerWidth, Supplier<Integer> containerHeight, CartEntityFactory<?> factory) {
        this.width = width;
        this.height = height;
        this.containerWidth = containerWidth;
        this.containerHeight = containerHeight;
        this.factory = factory;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int getContainerWidth() {
        return this.containerWidth.get();
    }

    public int getContainerHeight() {
        return this.containerHeight.get();
    }

    public int getContainerSize() {
        return this.containerWidth.get() * this.containerHeight.get();
    }

    public Item getItem(RegistryWood wood) {
        return (Item)AstikorItems.CART_ITEMS.get((Object)this).get(wood).get();
    }

    public <E extends Entity> EntityType.Builder<E> build(RegistryWood wood) {
        int trackingRange = 10;
        return EntityType.Builder.of((type, level) -> this.factory.create(type, level, this, wood), (MobCategory)MobCategory.MISC).sized(this.width, this.height).clientTrackingRange(10);
    }

    @FunctionalInterface
    public static interface CartEntityFactory<E extends Entity> {
        public E create(EntityType<E> var1, Level var2, CartType var3, RegistryWood var4);
    }
}

