/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.util.WoodRegistryHelper;

public class AstikorEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"tfcastikorcarts");
    public static final Map<CartType, Map<RegistryWood, Id<?>>> CART_ENTITIES = Arrays.stream(CartType.values()).collect(Collectors.toMap(type -> type, type -> WoodRegistryHelper.getAllWoodValues().stream().collect(Collectors.toMap(wood -> wood, wood -> AstikorEntities.register(type.getSerializedName() + "/" + wood.getSerializedName(), type.build((RegistryWood)wood))))));

    public static <E extends Entity> Id<E> register(String name, EntityType.Builder<E> builder) {
        return AstikorEntities.register(name, builder, true);
    }

    public static <E extends Entity> Id<E> register(String name, EntityType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return new Id(ENTITIES.register(id, () -> {
            if (!serialize) {
                builder.noSave();
            }
            return builder.build("tfcastikorcarts:" + id);
        }));
    }

    public record Id<T extends Entity>(DeferredHolder<EntityType<?>, EntityType<T>> holder) implements RegistryHolder<EntityType<?>, EntityType<T>>
    {
    }
}

