/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities.carts;

import com.google.common.collect.ImmutableList;
import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import com.jusipat.astikorcartsredux.container.SeedDrillMenu;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.entities.carts.TFCAbstractDrawnInventoryEntity;

public class TFCSeedDrillEntity
extends TFCAbstractDrawnInventoryEntity {
    public static final int SLOT_COUNT = 9;
    public static final ImmutableList<EntityDataAccessor<ItemStack>> SEEDS = ImmutableList.of((Object)SynchedEntityData.defineId(TFCSeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCSeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCSeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCSeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCSeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCSeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCSeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCSeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK), (Object)SynchedEntityData.defineId(TFCSeedDrillEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK));

    public TFCSeedDrillEntity(EntityType<? extends Entity> entityType, Level level, CartType cartType, RegistryWood wood) {
        super(entityType, level, cartType, wood, 9);
        this.spacing = 1.3;
        this.affectedByCargo = false;
    }

    public AstikorCartsReduxConfig.CartConfig getConfig() {
        return AstikorCartsReduxConfig.get().seedDrill;
    }

    public void plant() {
        for (int j = 0; j < 9; ++j) {
            ItemStack stack = this.getStackInSlot(j);
            double x = this.getX() + Math.sin(Math.toRadians((double)this.getYRot() - 90.0));
            double z = this.getZ() - Math.cos(Math.toRadians((double)this.getYRot() - 90.0));
            BlockPos blockPos = new BlockPos((int)Math.round(x - 0.5), (int)Math.round(this.getY() - 0.75), (int)Math.round(z - 0.5));
            if (this.tryPlaceCrop(stack, blockPos.above(), this.level(), j)) break;
            x = this.getX();
            z = this.getZ();
            blockPos = new BlockPos((int)Math.round(x - 0.5), (int)Math.round(this.getY() - 0.75), (int)Math.round(z - 0.5));
            if (this.tryPlaceCrop(stack, blockPos.above(), this.level(), j)) break;
            x = this.getX() + (double)Mth.sin((float)((float)Math.toRadians(this.getYRot() + 90.0f)));
            z = this.getZ() + (double)Mth.cos((float)((float)Math.toRadians(this.getYRot() + 90.0f)));
            blockPos = new BlockPos((int)Math.round(x - 0.5), (int)Math.round(this.getY() - 0.75), (int)Math.round(z - 0.5));
            if (this.tryPlaceCrop(stack, blockPos.above(), this.level(), j)) break;
        }
    }

    public boolean tryPlaceCrop(ItemStack stack, BlockPos pos, Level level, int slot) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            Block block = item2.getBlock();
            if (level.getBlockState(pos).isAir() && block.defaultBlockState().canSurvive((LevelReader)level, pos)) {
                level.setBlockAndUpdate(pos, block.defaultBlockState());
                stack.shrink(1);
                this.onContentsChanged(slot);
                return true;
            }
        }
        return false;
    }

    @Override
    public void pulledTick() {
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        if (!(this.level().isClientSide || this.xo == this.getX() && this.zo == this.getZ())) {
            this.plant();
        }
    }

    @Override
    public void onContentsChanged(int slot) {
        this.updateSlot(slot);
    }

    public void updateSlot(int slot) {
        if (!this.level().isClientSide) {
            if (((ItemStack)this.getItemStacks().get(slot)).isEmpty()) {
                this.entityData.set((EntityDataAccessor)SEEDS.get(slot), (Object)ItemStack.EMPTY);
            } else {
                this.entityData.set((EntityDataAccessor)SEEDS.get(slot), (Object)((ItemStack)this.getItemStacks().get(slot)));
            }
        }
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.entityData.get((EntityDataAccessor)SEEDS.get(i));
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        for (EntityDataAccessor param : SEEDS) {
            builder.define(param, (Object)ItemStack.EMPTY);
        }
    }

    @Override
    public InteractionResult onInteractNotOpen(Player player, InteractionHand hand) {
        return InteractionResult.SUCCESS;
    }

    @Override
    public AbstractContainerMenu createMenuLootUnpacked(int i, Inventory inventory, Player player) {
        return new SeedDrillMenu(i, inventory, (Container)this);
    }

    @Override
    public void saveInventory(CompoundTag compound) {
        ContainerHelper.saveAllItems((CompoundTag)compound, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    public void readInventory(CompoundTag compound) {
        ContainerHelper.loadAllItems((CompoundTag)compound, this.getItemStacks(), (HolderLookup.Provider)this.registryAccess());
    }
}

