/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.entities.carts;

import com.jusipat.astikorcartsredux.AstikorCartsReduxConfig;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import tfcastikorcarts.common.AstikorTags;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.container.ContainerTypes;
import tfcastikorcarts.common.container.DynamicGridContainer;
import tfcastikorcarts.common.entities.carts.TFCAbstractCargoCart;

public class TFCSupplyCartEntity
extends TFCAbstractCargoCart {
    public TFCSupplyCartEntity(EntityType<? extends Entity> entityType, Level level, CartType cartType, RegistryWood wood) {
        super(entityType, level, cartType, wood, ContainerTypes.supplyCartWidth().get() * ContainerTypes.supplyCartHeight().get());
    }

    public AstikorCartsReduxConfig.CartConfig getConfig() {
        return AstikorCartsReduxConfig.get().supplyCart;
    }

    public float getPassengersRidingOffsetY(EntityDimensions entityDimensions, float f) {
        return (entityDimensions.height() - 0.5625f) * f;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        Vec3 forward = this.getLookAngle().scale(-0.68);
        return new Vec3(forward.x, (double)this.getPassengersRidingOffsetY(entityDimensions, f) + forward.y, forward.z);
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        super.positionRider(passenger, moveFunction);
        if (this.hasPassenger(passenger)) {
            passenger.setYBodyRot(this.getYRot() + 180.0f);
            float f2 = Mth.wrapDegrees((float)(passenger.getYRot() - this.getYRot() + 180.0f));
            float f1 = Mth.clamp((float)f2, (float)-105.0f, (float)105.0f);
            passenger.yRotO += f1 - f2;
            passenger.setYRot(passenger.getYRot() + (f1 - f2));
            passenger.setYHeadRot(passenger.getYRot());
        }
    }

    @Override
    public InteractionResult onInteractNotOpen(Player player, InteractionHand hand) {
        InteractionResult bannerResult = this.useBanner(player, hand);
        if (bannerResult.consumesAction()) {
            return bannerResult;
        }
        if (this.isVehicle()) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public AbstractContainerMenu createMenuLootUnpacked(int windowId, Inventory inventory, Player player) {
        return DynamicGridContainer.create((MenuType)ContainerTypes.SUPPLY_CART_INVENTORY.get(), windowId, inventory, (Container)this, ContainerTypes.supplyCartWidth().get(), ContainerTypes.supplyCartHeight().get(), AstikorTags.Items.SUPPLY_CART_ITEM_WHITELIST, AstikorTags.Items.SUPPLY_CART_ITEM_BLACKLIST);
    }
}

