/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.items;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.items.TFCCartItem;
import tfcastikorcarts.util.WoodRegistryHelper;

public class AstikorItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"tfcastikorcarts");
    public static final Map<RegistryWood, ItemId> WHEELS = WoodRegistryHelper.getAllWoodValues().stream().collect(Collectors.toMap(wood -> wood, wood -> AstikorItems.register("wheel/" + wood.getSerializedName(), new Item.Properties().stacksTo(1))));
    public static final Map<CartType, Map<RegistryWood, ItemId>> CART_ITEMS = Arrays.stream(CartType.values()).collect(Collectors.toMap(type -> type, type -> WoodRegistryHelper.getAllWoodValues().stream().collect(Collectors.toMap(wood -> wood, wood -> AstikorItems.register(type.getSerializedName() + "/" + wood.getSerializedName(), () -> new TFCCartItem((RegistryWood)wood, (CartType)((Object)type), new Item.Properties().stacksTo(1)))))));

    public static ItemId register(String name) {
        return AstikorItems.register(name, () -> new Item(new Item.Properties()));
    }

    public static ItemId register(String name, Item.Properties properties) {
        return new ItemId((DeferredHolder<Item, Item>)ITEMS.register(name.toLowerCase(Locale.ROOT), () -> new Item(properties)));
    }

    public static ItemId register(String name, Supplier<Item> item) {
        return new ItemId((DeferredHolder<Item, Item>)ITEMS.register(name.toLowerCase(Locale.ROOT), item));
    }

    public record ItemId(DeferredHolder<Item, Item> holder) implements RegistryHolder<Item, Item>,
    ItemLike
    {
        public Item asItem() {
            return (Item)this.get();
        }
    }
}

