/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.config;

import java.util.function.Supplier;
import net.dries007.tfc.common.component.size.Size;
import net.dries007.tfc.config.BaseConfig;
import tfcastikorcarts.config.TFCAConfigBuilder;

public class TFCACCommonConfig
extends BaseConfig {
    public final Supplier<Double> maxAnimalSize;
    public final Supplier<Integer> maxPassengerCount;
    public final Supplier<Size> maxItemSize;
    public final Supplier<Boolean> canPushIntoPlayers;
    public final Supplier<Boolean> canCarryWaterEntities;
    public final Supplier<Double> pullingDistanceModifier;
    public final Supplier<Boolean> toggleFoodSpeed;
    public final Supplier<Double> exhaustedThreshold;
    public final Supplier<Double> overburdenedThreshold;
    public final Supplier<Double> pinnedThreshold;
    public final Supplier<Integer> handCartInventoryHeight;
    public final Supplier<Integer> handCartInventoryWidth;
    public final Supplier<Integer> supplyCartInventoryHeight;
    public final Supplier<Integer> supplyCartInventoryWidth;

    TFCACCommonConfig(TFCAConfigBuilder builder) {
        builder.push("general");
        this.maxAnimalSize = builder.comment("Max animal size that the animal cart can carry.").define("maxAnimalSize", 3.0, 0.0, Double.MAX_VALUE);
        this.maxPassengerCount = builder.comment("Amount of animals the animal cart can carry.").define("maxPassengerCount", 2, 0, Integer.MAX_VALUE);
        this.maxItemSize = builder.comment("The largest (inclusive) size of an item that is allowed in a supply cart.").define("maxItemSize", Size.VERY_LARGE);
        this.canPushIntoPlayers = builder.comment("Can the animal cart pick up players by pushing it into them?").define("canPushIntoPlayers", true);
        this.canCarryWaterEntities = builder.comment("Can the animal cart pick up water animals?").define("canCarryWaterEntities", true);
        this.pullingDistanceModifier = builder.comment("Pulling distance modifier for carts. Higher => farther/greater break tolerance.").define("pullingDistanceModifier", 2.0, Double.MIN_VALUE, Double.MAX_VALUE);
        this.toggleFoodSpeed = builder.comment("Should the player's average nutrient level and thirst affect the pulling speed of carts?").define("toggleFoodSpeed", true);
        builder.pop();
        builder.push("cartInventories");
        builder.comment("Item weight is now estimated in kilograms based on size and density. For example, a VERY_HEAVY HUGE item may weigh ~280 kg. If the threshold is 800, the player can carry up to ~3 such items before becoming pinned.");
        this.exhaustedThreshold = builder.comment("Mass threshold (in kg) at which the player pulling a cart becomes exhausted. Higher values allow heavier cargo before exhaustion.").define("exhaustedThreshold", 400.0, 0.0, Double.MAX_VALUE);
        this.overburdenedThreshold = builder.comment("Mass threshold (in kg) at which the player pulling a cart becomes overburdened. Higher values allow heavier cargo before overburdening.").define("overburdenedThreshold", 1000.0, 0.0, Double.MAX_VALUE);
        this.pinnedThreshold = builder.comment("Mass threshold (in kg) at which the player pulling a cart becomes pinned and immobilized. Higher values allow heavier cargo before being pinned.").define("pinnedThreshold", 2000.0, 0.0, Double.MAX_VALUE);
        this.handCartInventoryHeight = builder.comment("Number of rows in the Hand Cart inventory").define("handCartInventoryHeight", 2, 1, Integer.MAX_VALUE);
        this.handCartInventoryWidth = builder.comment("Number of columns in the Hand Cart inventory").define("handCartInventoryWidth", 5, 1, Integer.MAX_VALUE);
        this.supplyCartInventoryHeight = builder.comment("Number of rows in the Supply Cart inventory").define("supplyCartInventoryHeight", 5, 1, Integer.MAX_VALUE);
        this.supplyCartInventoryWidth = builder.comment("Number of columns in the Supply Cart inventory").define("supplyCartInventoryWidth", 9, 1, Integer.MAX_VALUE);
        builder.pop();
    }
}

