/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.util;

import java.util.EnumMap;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.component.size.Size;
import net.dries007.tfc.common.component.size.Weight;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import tfcastikorcarts.TFCAstikorCarts;
import tfcastikorcarts.config.TFCAstikorCartsConfig;

public class AstikorHelpers {
    public static final double DENSITY_WOOD = 700.0;
    public static final double DENSITY_STONE = 2600.0;
    public static final double DENSITY_IRON = 7870.0;
    public static final double DENSITY_MEAT = 1050.0;
    public static final double FIXED_VOLUME = 0.008;
    public static final EnumMap<Size, Double> SIZE_TO_VOLUME = new EnumMap(Size.class);
    public static final EnumMap<Weight, Double> WEIGHT_TO_DENSITY;

    public static ResourceLocation identifier(String name) {
        return AstikorHelpers.resourceLocation("tfcastikorcarts", name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.parse((String)name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
    }

    public static boolean isTagEmpty(TagKey<Item> tag) {
        return BuiltInRegistries.ITEM.getTag(tag).map(holders -> holders.size() == 0).orElse(true);
    }

    public static void debugTag(TagKey<Item> tag) {
        BuiltInRegistries.ITEM.getTag(tag).ifPresentOrElse(holders -> {
            TFCAstikorCarts.LOGGER.info("Tag {} has {} entries:", (Object)tag.location(), (Object)holders.size());
            for (Holder holder : holders) {
                TFCAstikorCarts.LOGGER.info(" - {}", holder.value());
            }
        }, () -> TFCAstikorCarts.LOGGER.info("Tag {} not found", (Object)tag.location()));
    }

    public static boolean isValidSize(ItemStack stack) {
        return ItemSizeManager.get((ItemStack)stack).getSize(stack).isEqualOrSmallerThan(TFCAstikorCartsConfig.COMMON.maxItemSize.get());
    }

    public static float getWeightFactor(Weight weight, Size size) {
        return weight.ordinal() * size.ordinal();
    }

    public static double getEstimatedMassKg(AABB box) {
        double width = box.getXsize();
        double height = box.getYsize();
        double depth = box.getZsize();
        double volume = width * height * depth;
        double MEAT_DENSITY = 1050.0;
        return volume * 1050.0;
    }

    public static double getEstimatedMassKg(Size size, Weight weight, int count) {
        double volume = SIZE_TO_VOLUME.getOrDefault(size, 0.008);
        double density = WEIGHT_TO_DENSITY.getOrDefault(weight, 1050.0);
        return volume * density * (double)count;
    }

    public static double getEstimatedMassKg(ItemStack stack, Size size, Weight weight) {
        return AstikorHelpers.getEstimatedMassKg(size, weight, stack.getCount());
    }

    public static String toProperCase(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String[] parts = input.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String word = parts[i];
            if (!word.isEmpty()) {
                result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
            }
            if (i >= parts.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public static String toLangKey(ResourceLocation input) {
        return input.getNamespace() + "." + input.getPath().replace('/', '.');
    }

    public static String toLangKey(Item item) {
        return AstikorHelpers.toLangKey(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static String toLangKey(EntityType<?> entityType) {
        return AstikorHelpers.toLangKey(BuiltInRegistries.ENTITY_TYPE.getKey(entityType));
    }

    static {
        SIZE_TO_VOLUME.put(Size.TINY, 1.0E-4);
        SIZE_TO_VOLUME.put(Size.VERY_SMALL, 5.0E-4);
        SIZE_TO_VOLUME.put(Size.SMALL, 0.001);
        SIZE_TO_VOLUME.put(Size.NORMAL, 0.008);
        SIZE_TO_VOLUME.put(Size.LARGE, 0.03);
        SIZE_TO_VOLUME.put(Size.VERY_LARGE, 0.1);
        SIZE_TO_VOLUME.put(Size.HUGE, 0.5);
        WEIGHT_TO_DENSITY = new EnumMap(Weight.class);
        WEIGHT_TO_DENSITY.put(Weight.VERY_LIGHT, 300.0);
        WEIGHT_TO_DENSITY.put(Weight.LIGHT, 700.0);
        WEIGHT_TO_DENSITY.put(Weight.MEDIUM, 1050.0);
        WEIGHT_TO_DENSITY.put(Weight.HEAVY, 2600.0);
        WEIGHT_TO_DENSITY.put(Weight.VERY_HEAVY, 7870.0);
    }
}

