/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.util;

import java.util.List;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.util.AstikorHelpers;

public class DynamicLangHelper {
    public static Component getDisplayName(RegistryWood wood, CartType type) {
        String woodName = AstikorHelpers.toProperCase(wood.getSerializedName());
        return Component.literal((String)(woodName + " " + AstikorHelpers.toProperCase(type.getSerializedName())));
    }

    public static void addTooltips(CartType type, RegistryWood wood, ItemStack stack, List<Component> tooltip) {
        switch (type) {
            case SUPPLY_CART: {
                tooltip.add((Component)Component.literal((String)("This cart can hold up to " + type.getContainerSize() + " stacks of items")));
                tooltip.add((Component)Component.literal((String)"It has one seat and can be decorated with a banner"));
                break;
            }
            case HAND_CART: {
                tooltip.add((Component)Component.literal((String)("This cart can hold up to " + type.getContainerSize() + " stacks of items")));
                tooltip.add((Component)Component.literal((String)"It can only be pulled by the player"));
                break;
            }
            case ANIMAL_CART: {
                tooltip.add((Component)Component.literal((String)"This cart has two seats for animals or players and can be decorated with a banner"));
                tooltip.add((Component)Component.literal((String)"It can also be controlled from the front seat"));
                break;
            }
            case PLOW: {
                tooltip.add((Component)Component.literal((String)"This contraption can clear and till the surrounding ground, make dirt paths or strip logs"));
                tooltip.add((Component)Component.literal((String)"It needs the respective tools to work and can be toggled by right-clicking"));
                break;
            }
            case SEED_DRILL: {
                tooltip.add((Component)Component.literal((String)"This contraption plants seeds on farmland"));
                tooltip.add((Component)Component.literal((String)"It has room for 9 stacks of seeds"));
                break;
            }
            case REAPER: {
                tooltip.add((Component)Component.literal((String)"This contraption can harvest crops"));
                tooltip.add((Component)Component.literal((String)"Only works if the player is sitting on it"));
            }
        }
    }
}

