/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import tfcastikorcarts.TFCAstikorCarts;
import tfcastikorcarts.util.AstikorHelpers;

public class WoodRegistryHelper {
    public static final Map<Class<? extends RegistryWood>, List<RegistryWood>> WOOD_TYPES = new HashMap<Class<? extends RegistryWood>, List<RegistryWood>>();

    public static void discoverRegistryWoodEnums() {
        ModList.get().getMods().stream().forEach(mod -> {
            Path modFile = ModList.get().getModFileById(mod.getModId()).getFile().getFilePath();
            try (JarFile jar = new JarFile(modFile.toFile());){
                jar.stream().filter(e -> e.getName().endsWith(".class")).forEach(entry -> {
                    String className = entry.getName().replace('/', '.').replace(".class", "");
                    try {
                        String lowerName = className.toLowerCase();
                        if (lowerName.contains("mixin") || className.toLowerCase(Locale.ROOT).contains("client")) {
                            return;
                        }
                        Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                        if (clazz.isEnum() && RegistryWood.class.isAssignableFrom(clazz)) {
                            RegistryWood[] constants = (RegistryWood[])clazz.getEnumConstants();
                            WOOD_TYPES.put(clazz, Arrays.asList(constants));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        });
        for (Map.Entry<Class<? extends RegistryWood>, List<RegistryWood>> entry : WOOD_TYPES.entrySet()) {
            Class<? extends RegistryWood> clazz = entry.getKey();
            List<RegistryWood> woods = entry.getValue();
            String woodNames = woods.stream().map(StringRepresentable::getSerializedName).sorted().collect(Collectors.joining(", "));
            TFCAstikorCarts.LOGGER.debug("Found wood types in {}: {}", (Object)clazz.getName(), (Object)woodNames);
        }
    }

    public static Block getWoodBlock(RegistryWood wood, TagKey<Block> tag) {
        return WoodRegistryHelper.getWoodBlock(wood, tag, null, false);
    }

    public static Block getWoodBlock(RegistryWood wood, TagKey<Block> tag, String filter, boolean whitelist) {
        String woodName = wood.getSerializedName();
        Block bestMatch = null;
        int bestLen = Integer.MAX_VALUE;
        for (Block block : BuiltInRegistries.BLOCK) {
            int len;
            String path;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            if ("minecraft".equals(id.getNamespace()) || !WoodRegistryHelper.containsWholeWord(path = id.getPath(), woodName)) continue;
            if (filter != null && !filter.isEmpty()) {
                boolean hasFilter = WoodRegistryHelper.containsWholeWord(path, filter);
                if (whitelist && !hasFilter || !whitelist && hasFilter) continue;
            }
            if ((len = path.length()) >= bestLen) continue;
            bestLen = len;
            bestMatch = block;
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        return (Block)((TFCBlocks.Id)((Map)TFCBlocks.WOODS.get(Wood.OAK)).get(Wood.BlockType.LOG)).get();
    }

    public static boolean containsWholeWord(String path, String word) {
        if (word == null || word.isEmpty()) {
            return true;
        }
        String regex = "(^|[_/])" + Pattern.quote(word) + "([_/]|$)";
        return Pattern.compile(regex).matcher(path).find();
    }

    public static List<RegistryWood> getAllWoodValues() {
        return WOOD_TYPES.values().parallelStream().flatMap(Collection::stream).toList();
    }

    public static boolean matchesAnyWood(String input) {
        return WoodRegistryHelper.getAllWoodValues().parallelStream().anyMatch(wood -> wood.getSerializedName().equalsIgnoreCase(input));
    }

    public static RegistryWood getWoodValue(String input) {
        return WoodRegistryHelper.getAllWoodValues().parallelStream().filter(wood -> wood.getSerializedName().equalsIgnoreCase(input)).findFirst().orElse(null);
    }

    public static Map<Class<? extends RegistryWood>, List<RegistryWood>> getWoodEnumMap() {
        return Collections.unmodifiableMap(WOOD_TYPES);
    }

    public static ResourceLocation getBlockResource(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return AstikorHelpers.resourceLocation(id.getNamespace(), "block/" + id.getPath());
    }
}

