/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts;

import com.jusipat.astikorcartsredux.entity.ai.goal.AvoidCartGoal;
import com.jusipat.astikorcartsredux.util.GoalAdder;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.PathfinderMob;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import tfcastikorcarts.TFCAstikorCarts;
import tfcastikorcarts.common.DatapackGeneratorHandler;
import tfcastikorcarts.common.entities.carts.TFCPlowEntity;
import tfcastikorcarts.common.entities.carts.TFCSupplyCartEntity;

public class EventHandler {
    public static final GoalAdder<PathfinderMob> PATHFINDER_GOAL_ADDER = GoalAdder.mobGoal(PathfinderMob.class).add(3, mob -> new AvoidCartGoal(mob, TFCSupplyCartEntity.class, 3.0f, 0.5)).add(3, mob -> new AvoidCartGoal(mob, TFCPlowEntity.class, 3.0f, 0.5)).build();

    public static void init(IEventBus setupBus) {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(EventHandler::onEntityJoinWorld);
    }

    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        PATHFINDER_GOAL_ADDER.onEntityJoinWorld(event.getEntity());
    }

    public static void onAddPackFinders(AddPackFindersEvent event) {
        DatapackGeneratorHandler.initDatapack();
        event.addRepositorySource(consumer -> {
            PackSelectionConfig selection;
            Pack.ResourcesSupplier supplier;
            PackLocationInfo info = new PackLocationInfo("TFC Astikor Carts Data", (Component)Component.literal((String)"TFC Astikor Carts Data"), PackSource.BUILT_IN, Optional.empty());
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)(supplier = new Pack.ResourcesSupplier(){

                public PackResources openPrimary(PackLocationInfo location) {
                    return new PathPackResources(location, DatapackGeneratorHandler.DATA_PACK_PATH);
                }

                public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
                    return new PathPackResources(location, DatapackGeneratorHandler.DATA_PACK_PATH);
                }
            }), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)(selection = new PackSelectionConfig(true, Pack.Position.TOP, false)));
            if (pack != null) {
                consumer.accept(pack);
                TFCAstikorCarts.LOGGER.info("Registered built-in generated data pack");
            }
        });
    }
}

