/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;
import tfcastikorcarts.TFCAstikorCarts;
import tfcastikorcarts.common.items.AstikorItems;
import tfcastikorcarts.util.AstikorHelpers;
import tfcregistryapi.util.WoodRegistryHelper;

public class AssetGeneratorHandler {
    public static final String RESOURCE_PACK_NAME = "TFC Astikor Carts Assets";
    public static Path RESOURCE_PACK_PATH = FMLPaths.CONFIGDIR.get().resolve("tfcastikorcarts").resolve("TFC Astikor Carts Assets");
    public static final Set<String> generatedAssets = new HashSet<String>();
    public static boolean generated = false;

    public static void initResourcePack() {
        try {
            Files.createDirectories(RESOURCE_PACK_PATH, new FileAttribute[0]);
            Path packMetaPath = RESOURCE_PACK_PATH.resolve("pack.mcmeta");
            if (!Files.exists(packMetaPath, new LinkOption[0])) {
                Files.writeString(packMetaPath, (CharSequence)"{\n    \"pack\": {\n        \"description\": \"Auto-generated TFC AstikorCarts assets\",\n        \"pack_format\": %d\n    }\n}\n".formatted(34), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            TFCAstikorCarts.LOGGER.error("Failed to generate metadata for the resource pack!", (Throwable)e);
        }
    }

    public static void generateAllLang() {
        LinkedHashMap<String, String> langEntries = new LinkedHashMap<String, String>();
        AstikorItems.WHEELS.forEach((wood, itemId) -> {
            String key = "item.tfcastikorcarts.wheel." + wood.getSerializedName();
            String value = AssetGeneratorHandler.capitalize(wood.getSerializedName()) + " Wheel";
            langEntries.put(key, value);
        });
        AstikorItems.CART_ITEMS.forEach((type, map) -> map.forEach((wood, itemId) -> {
            String key = "item.tfcastikorcarts." + type.getSerializedName() + "." + wood.getSerializedName();
            String value = AssetGeneratorHandler.capitalize(wood.getSerializedName()) + " " + AssetGeneratorHandler.capitalize(type.getSerializedName().replace("_", " "));
            langEntries.put(key, value);
        }));
        AssetGeneratorHandler.generateLangFile(langEntries);
    }

    public static void generateLangFile(Map<String, String> entries) {
        Path langPath = RESOURCE_PACK_PATH.resolve("assets/tfcastikorcarts/lang/en_us.json");
        try {
            Files.createDirectories(langPath.getParent(), new FileAttribute[0]);
            StringBuilder sb = new StringBuilder();
            sb.append("{\n");
            int i = 0;
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                sb.append("  \"").append(entry.getKey()).append("\": \"").append(entry.getValue().replace("\"", "\\\"")).append("\"");
                if (i < entries.size() - 1) {
                    sb.append(",");
                }
                sb.append("\n");
                ++i;
            }
            sb.append("}\n");
            Files.writeString(langPath, (CharSequence)sb.toString(), new OpenOption[0]);
        }
        catch (Exception e) {
            TFCAstikorCarts.LOGGER.error("Failed to generate lang files!", (Throwable)e);
        }
    }

    public static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1).replace("_", " ");
    }

    public static void generateItemModel(String name) {
        Path modelPath = RESOURCE_PACK_PATH.resolve("assets/tfcastikorcarts/models/item/" + name + ".json");
        try {
            Files.createDirectories(modelPath.getParent(), new FileAttribute[0]);
            String json = "{\n    \"parent\": \"item/generated\",\n    \"textures\": {\n        \"layer0\": \"tfcastikorcarts:item/%s\"\n    }\n}\n".formatted(name);
            Files.writeString(modelPath, (CharSequence)json, new OpenOption[0]);
        }
        catch (Exception e) {
            TFCAstikorCarts.LOGGER.error("Failed to generate model files!", (Throwable)e);
        }
    }

    public static void generateAllTextures() {
        if (generated) {
            return;
        }
        AstikorItems.WHEELS.forEach((wood, itemId) -> {
            ResourceLocation plankTex = AssetGeneratorHandler.getBlockResource(WoodRegistryHelper.getWoodBlock((RegistryWood)wood, (TagKey)BlockTags.PLANKS, (String)"planks", (boolean)true));
            int avgColor = AssetGeneratorHandler.getAverageColor(plankTex);
            ResourceLocation baseTex = AstikorHelpers.identifier("textures/item/base_textures/wheel.png");
            String name = "wheel/" + wood.getSerializedName();
            AssetGeneratorHandler.generateAndSaveTexture(name, baseTex, avgColor, null);
            AssetGeneratorHandler.generateItemModel(name);
        });
        AstikorItems.CART_ITEMS.forEach((type, map) -> map.forEach((wood, itemId) -> {
            ResourceLocation plankTex = AssetGeneratorHandler.getBlockResource(WoodRegistryHelper.getWoodBlock((RegistryWood)wood, (TagKey)BlockTags.PLANKS, (String)"planks", (boolean)true));
            int avgColor = AssetGeneratorHandler.getAverageColor(plankTex);
            ResourceLocation baseTex = AstikorHelpers.identifier("textures/item/base_textures/" + type.getSerializedName() + ".png");
            ResourceLocation overlayTex = !type.hasOverlay() ? null : AstikorHelpers.identifier("textures/item/base_textures/" + type.getSerializedName() + "_overlay.png");
            String name = type.getSerializedName() + "/" + wood.getSerializedName();
            AssetGeneratorHandler.generateAndSaveTexture(name, baseTex, avgColor, overlayTex);
            AssetGeneratorHandler.generateItemModel(name);
        }));
        generated = true;
    }

    public static ResourceLocation getBlockResource(Block block) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
        return AstikorHelpers.resourceLocation(id.getNamespace(), "textures/block/" + id.getPath() + ".png");
    }

    public static void generateAndSaveTexture(String name, ResourceLocation baseTex, int tintColor, @Nullable ResourceLocation overlayTex) {
        if (!Minecraft.getInstance().getResourceManager().getResource(baseTex).isPresent()) {
            TFCAstikorCarts.LOGGER.error("Failed to generate texture! Resource was not present!");
            return;
        }
        try (InputStream baseStream = Minecraft.getInstance().getResourceManager().getResourceOrThrow(baseTex).open();
             NativeImage baseImage = NativeImage.read((InputStream)baseStream);){
            NativeImage tinted = AssetGeneratorHandler.recolorTemplateTexture(baseImage, tintColor);
            if (overlayTex != null) {
                try (InputStream overlayStream = Minecraft.getInstance().getResourceManager().getResourceOrThrow(overlayTex).open();
                     NativeImage overlayImage = NativeImage.read((InputStream)overlayStream);){
                    tinted = AssetGeneratorHandler.overlayTexture(tinted, overlayImage);
                }
            }
            Path outPath = RESOURCE_PACK_PATH.resolve("assets/tfcastikorcarts/textures/item/" + name + ".png");
            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
            tinted.writeToFile(outPath);
            tinted.close();
            generatedAssets.add(name);
        }
        catch (Exception e) {
            TFCAstikorCarts.LOGGER.error("Failed to generate texture files!", (Throwable)e);
        }
    }

    public static int getAverageColor(ResourceLocation textureLocation) {
        int color;
        block14: {
            color = -5592406;
            try {
                Optional resourceOpt = Minecraft.getInstance().getResourceManager().getResource(textureLocation);
                if (!resourceOpt.isPresent()) break block14;
                try (InputStream stream = ((Resource)resourceOpt.get()).open();
                     NativeImage image = NativeImage.read((InputStream)stream);){
                    color = AssetGeneratorHandler.extractAverageColor(image);
                }
            }
            catch (Exception e) {
                TFCAstikorCarts.LOGGER.warn("Failed to get average color for '{}'. Defaulting to gray!", (Object)textureLocation.toString());
            }
        }
        TFCAstikorCarts.LOGGER.info("Average color for '{}' is: '{}'", (Object)textureLocation.toString(), (Object)color);
        return color;
    }

    public static NativeImage overlayTexture(NativeImage base, NativeImage overlay) {
        if (base.getWidth() != overlay.getWidth() || base.getHeight() != overlay.getHeight()) {
            throw new IllegalArgumentException("Overlay and base must have same dimensions");
        }
        NativeImage result = new NativeImage(base.getWidth(), base.getHeight(), true);
        for (int y = 0; y < base.getHeight(); ++y) {
            for (int x = 0; x < base.getWidth(); ++x) {
                int basePixel = base.getPixelRGBA(x, y);
                int overlayPixel = overlay.getPixelRGBA(x, y);
                int overlayAlpha = overlayPixel >> 24 & 0xFF;
                result.setPixelRGBA(x, y, overlayAlpha > 0 ? overlayPixel : basePixel);
            }
        }
        return result;
    }

    public static int extractAverageColor(NativeImage image) {
        int totalR = 0;
        int totalG = 0;
        int totalB = 0;
        int pixelCount = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int color = image.getPixelRGBA(x, y);
                int alpha = color >> 24 & 0xFF;
                if (alpha < 128) continue;
                int r = color & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color >> 16 & 0xFF;
                totalR += r;
                totalG += g;
                totalB += b;
                ++pixelCount;
            }
        }
        if (pixelCount == 0) {
            return -5592406;
        }
        return 0xFF000000 | totalR / pixelCount << 16 | totalG / pixelCount << 8 | totalB / pixelCount;
    }

    public static NativeImage recolorTemplateTexture(NativeImage template, int targetColor) {
        int templateColor = AssetGeneratorHandler.extractAverageColor(template);
        NativeImage result = new NativeImage(template.getWidth(), template.getHeight(), true);
        int targetR = targetColor >> 16 & 0xFF;
        int targetG = targetColor >> 8 & 0xFF;
        int targetB = targetColor & 0xFF;
        int templateR = templateColor >> 16 & 0xFF;
        int templateG = templateColor >> 8 & 0xFF;
        int templateB = templateColor & 0xFF;
        float templateBrightness = (float)(templateR + templateG + templateB) / 3.0f;
        for (int y = 0; y < template.getHeight(); ++y) {
            for (int x = 0; x < template.getWidth(); ++x) {
                int pixel = template.getPixelRGBA(x, y);
                int alpha = pixel >> 24 & 0xFF;
                if (alpha < 128) {
                    result.setPixelRGBA(x, y, pixel);
                    continue;
                }
                int origR = pixel & 0xFF;
                int origG = pixel >> 8 & 0xFF;
                int origB = pixel >> 16 & 0xFF;
                float pixelBrightness = (float)(origR + origG + origB) / 3.0f;
                float brightnessFactor = templateBrightness > 0.0f ? pixelBrightness / templateBrightness : 1.0f;
                int newR = Math.min(255, (int)((float)targetR * brightnessFactor));
                int newG = Math.min(255, (int)((float)targetG * brightnessFactor));
                int newB = Math.min(255, (int)((float)targetB * brightnessFactor));
                int newPixel = alpha << 24 | newB << 16 | newG << 8 | newR;
                result.setPixelRGBA(x, y, newPixel);
            }
        }
        return result;
    }

    public static void exportPackToDisk(Pack pack, Path exportPath) {
        try (PackResources resources = pack.open();){
            Files.createDirectories(exportPath, new FileAttribute[0]);
            try (InputStream metaStream = (InputStream)resources.getRootResource(new String[]{"pack.mcmeta"}).get();){
                Files.copy(metaStream, exportPath.resolve("pack.mcmeta"), StandardCopyOption.REPLACE_EXISTING);
            }
            for (String namespace : resources.getNamespaces(PackType.CLIENT_RESOURCES)) {
                resources.listResources(PackType.CLIENT_RESOURCES, namespace, "", (loc, supplier) -> {
                    try (InputStream stream = (InputStream)supplier.get();){
                        Path out = exportPath.resolve("assets").resolve(loc.getNamespace()).resolve(loc.getPath());
                        Files.createDirectories(out.getParent(), new FileAttribute[0]);
                        Files.copy(stream, out, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            TFCAstikorCarts.LOGGER.info("Exported pack '{}' to {}", (Object)pack.getId(), (Object)exportPath.toAbsolutePath());
        }
        catch (Exception e) {
            TFCAstikorCarts.LOGGER.error("Failed to export pack", (Throwable)e);
        }
    }
}

