/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.client;

import com.jusipat.astikorcartsredux.client.renderer.texture.AssembledTexture;
import com.jusipat.astikorcartsredux.client.renderer.texture.AssembledTextureFactory;
import com.jusipat.astikorcartsredux.client.renderer.texture.Material;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import tfcastikorcarts.TFCAstikorCarts;
import tfcastikorcarts.client.AssetGeneratorHandler;
import tfcastikorcarts.client.TFCAstikorCartsModelLayers;
import tfcastikorcarts.client.renderer.entity.model.TFCAnimalCartModel;
import tfcastikorcarts.client.renderer.entity.model.TFCHandCartModel;
import tfcastikorcarts.client.renderer.entity.model.TFCPlowModel;
import tfcastikorcarts.client.renderer.entity.model.TFCReaperModel;
import tfcastikorcarts.client.renderer.entity.model.TFCSeedDrillModel;
import tfcastikorcarts.client.renderer.entity.model.TFCSupplyCartModel;
import tfcastikorcarts.client.screen.DynamicGridScreen;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.container.ContainerTypes;
import tfcastikorcarts.common.entities.AstikorEntities;
import tfcastikorcarts.util.AstikorHelpers;
import tfcregistryapi.util.WoodRegistryHelper;

public class ClientEventHandler {
    public static void init(ModContainer mod, IEventBus bus) {
        bus.addListener(ClientEventHandler::registerMenuScreens);
        bus.addListener(ClientEventHandler::registerEntityRenderers);
        bus.addListener(ClientEventHandler::registerLayerDefinitions);
        bus.addListener(ClientEventHandler::registerAssembledTextures);
    }

    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)ContainerTypes.HAND_CART_INVENTORY.get(), DynamicGridScreen::new);
        event.register((MenuType)ContainerTypes.SUPPLY_CART_INVENTORY.get(), DynamicGridScreen::new);
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        for (CartType cartType : CartType.values()) {
            for (AstikorEntities.Id<?> id : AstikorEntities.CART_ENTITIES.get((Object)cartType).values()) {
                event.registerEntityRenderer((EntityType)id.get(), TFCAstikorCartsModelLayers.getRenderer(cartType));
            }
        }
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(TFCAstikorCartsModelLayers.PLOW, TFCPlowModel::createLayer);
        event.registerLayerDefinition(TFCAstikorCartsModelLayers.ANIMAL_CART, TFCAnimalCartModel::createLayer);
        event.registerLayerDefinition(TFCAstikorCartsModelLayers.SUPPLY_CART, TFCSupplyCartModel::createLayer);
        event.registerLayerDefinition(TFCAstikorCartsModelLayers.HAND_CART, TFCHandCartModel::createLayer);
        event.registerLayerDefinition(TFCAstikorCartsModelLayers.SEED_DRILL, TFCSeedDrillModel::createLayer);
        event.registerLayerDefinition(TFCAstikorCartsModelLayers.REAPER, TFCReaperModel::createLayer);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            AssetGeneratorHandler.generateAllTextures();
            AssetGeneratorHandler.generateAllLang();
            Minecraft.getInstance().reloadResourcePacks();
        });
    }

    public static void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            AssetGeneratorHandler.initResourcePack();
            event.addRepositorySource(consumer -> {
                PackSelectionConfig selection;
                Pack.ResourcesSupplier supplier;
                PackLocationInfo info = new PackLocationInfo("TFC Astikor Carts Assets", (Component)Component.literal((String)"TFC Astikor Carts Assets"), PackSource.BUILT_IN, Optional.empty());
                Pack pack = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)(supplier = new Pack.ResourcesSupplier(){

                    public PackResources openPrimary(PackLocationInfo location) {
                        return new PathPackResources(location, AssetGeneratorHandler.RESOURCE_PACK_PATH);
                    }

                    public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
                        return new PathPackResources(location, AssetGeneratorHandler.RESOURCE_PACK_PATH);
                    }
                }), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)(selection = new PackSelectionConfig(true, Pack.Position.TOP, false)));
                if (pack != null) {
                    consumer.accept(pack);
                    TFCAstikorCarts.LOGGER.info("Registered built-in generated resource pack");
                }
            });
        }
    }

    public static void registerAssembledTextures(TextureAtlasStitchedEvent event) {
        if (!event.getAtlas().location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            return;
        }
        AssembledTextureFactory factory = new AssembledTextureFactory();
        Material composterSide = new Material(AstikorHelpers.resourceLocation("minecraft", "block/composter_side"), 16).fill(16, 47, 44, 5, Material.R0, -2, 1).fill(16, 54, 38, 5, Material.R0, -2, -6);
        Material composterTop = new Material(AstikorHelpers.resourceLocation("minecraft", "block/composter_top"), 16).fill(18, 45, 10, 2, Material.R0, -2, 3).fill(28, 45, 10, 2, Material.R0, 10, 3).fill(18, 52, 8, 2, Material.R0, 0, -4).fill(26, 52, 9, 2, Material.R0, 11, -4);
        Material stone = new Material(WoodRegistryHelper.getBlockResource((Block)((Block)((TFCBlocks.Id)((Map)TFCBlocks.ROCK_BLOCKS.get(Rock.ANDESITE)).get(Rock.BlockType.RAW)).get())), 16).fill(62, 55, 2, 9);
        Material dirt = new Material(WoodRegistryHelper.getBlockResource((Block)((Block)((TFCBlocks.Id)((Map)TFCBlocks.SOIL.get(SoilBlockType.DIRT)).get(SoilBlockType.Variant.ARIDISOL)).get())), 16).fill(0, 45, 16, 17);
        WoodRegistryHelper.getAllWoodValues().stream().forEach(wood -> {
            ResourceLocation log = WoodRegistryHelper.getBlockResource((Block)WoodRegistryHelper.getWoodBlock((RegistryWood)wood, (TagKey)BlockTags.LOGS, (String)"log", (boolean)true));
            ResourceLocation planks = WoodRegistryHelper.getBlockResource((Block)WoodRegistryHelper.getWoodBlock((RegistryWood)wood, (TagKey)BlockTags.PLANKS, (String)"planks", (boolean)true));
            ResourceLocation stripped_log = WoodRegistryHelper.getBlockResource((Block)WoodRegistryHelper.getWoodBlock((RegistryWood)wood, (TagKey)BlockTags.LOGS, (String)"stripped_log", (boolean)true));
            factory.add(new AssembledTexture(AstikorHelpers.identifier("textures/entity/animal_cart/" + wood.getSerializedName() + ".png"), 64, 64).add(new Material(planks, 16).fill(0, 0, 60, 38, Material.R0, 0, 2).fill(0, 28, 20, 33, Material.R90, 4, -2).fill(12, 30, 8, 31, Material.R270, 0, 4)).add(new Material(stripped_log, 16).fill(54, 54, 10, 10, Material.R0, 0, 2)).add(new Material(log, 16).fill(0, 21, 60, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(stone)).add(new AssembledTexture(AstikorHelpers.identifier("textures/entity/plow/" + wood.getSerializedName() + ".png"), 64, 64).add(new Material(planks, 16).fill(0, 0, 64, 32, Material.R90).fill(0, 8, 42, 3, Material.R0, 0, 1).fill(0, 27, 34, 3, Material.R0, 0, 2)).add(new Material(stripped_log, 16).fill(54, 54, 10, 10, Material.R0, 2, 0)).add(new Material(log, 16).fill(0, 0, 54, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(stone)).add(new AssembledTexture(AstikorHelpers.identifier("textures/entity/seed_drill/" + wood.getSerializedName() + ".png"), 64, 64).add(new Material(planks, 16).fill(0, 0, 64, 32, Material.R90).fill(0, 8, 64, 3, Material.R0, 0, 1).fill(0, 27, 34, 3, Material.R0, 0, 2)).add(new Material(stripped_log, 16).fill(54, 54, 10, 10, Material.R0, 2, 0)).add(new Material(log, 16).fill(0, 0, 64, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(new Material(WoodRegistryHelper.getBlockResource((Block)((Block)((TFCBlocks.Id)((Map)TFCBlocks.ROCK_BLOCKS.get(Rock.ANDESITE)).get(Rock.BlockType.RAW)).get())), 16).fill(62, 55, 2, 9).fill(0, 57, 8, 7, Material.R0))).add(new AssembledTexture(AstikorHelpers.identifier("textures/entity/reaper/" + wood.getSerializedName() + ".png"), 64, 64).add(new Material(planks, 16).fill(0, 0, 64, 32, Material.R90).fill(0, 8, 46, 4, Material.R0, 0, 1).fill(0, 27, 34, 3, Material.R0, 0, 2)).add(new Material(stripped_log, 16).fill(54, 54, 10, 10, Material.R0, 2, 0)).add(new Material(log, 16).fill(0, 0, 64, 4, Material.R90).fill(32, 12, 8, 17, Material.R0).fill(46, 60, 8, 4, Material.R90)).add(new Material(WoodRegistryHelper.getBlockResource((Block)((Block)((TFCBlocks.Id)((Map)TFCBlocks.ROCK_BLOCKS.get(Rock.ANDESITE)).get(Rock.BlockType.RAW)).get())), 16).fill(62, 55, 2, 9).fill(0, 32, 64, 16))).add(new AssembledTexture(AstikorHelpers.identifier("textures/entity/supply_cart/" + wood.getSerializedName() + ".png"), 64, 64).add(new Material(planks, 16).fill(0, 0, 60, 45, Material.R0, 0, 2).fill(0, 27, 60, 8, Material.R0, 0, 1)).add(new Material(stripped_log, 16).fill(54, 54, 10, 10, Material.R0, 0, 2)).add(new Material(log, 16).fill(0, 23, 54, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(stone).add(composterSide).add(composterTop).add(dirt)).add(new AssembledTexture(AstikorHelpers.identifier("textures/entity/hand_cart/" + wood.getSerializedName() + ".png"), 64, 64).add(new Material(planks, 16).fill(0, 0, 52, 43, Material.R0, 0, 2).fill(0, 24, 42, 4, Material.R0, 0, 1)).add(new Material(stripped_log, 16).fill(54, 54, 10, 10, Material.R0, 0, 2)).add(new Material(log, 16).fill(0, 20, 46, 4, Material.R90).fill(46, 60, 8, 4, Material.R90)).add(stone).add(composterSide).add(composterTop).add(dirt));
        });
        factory.bake();
    }
}

