/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;

public class GeneratedPackResources
implements PackResources {
    private final PackLocationInfo info;
    private final Map<ResourceLocation, byte[]> assets;

    public GeneratedPackResources(PackLocationInfo info, Map<ResourceLocation, byte[]> assets) {
        this.info = info;
        this.assets = assets;
    }

    public PackLocationInfo location() {
        return this.info;
    }

    public void close() {
    }

    public Set<String> getNamespaces(PackType type) {
        HashSet<String> namespaces = new HashSet<String>();
        for (ResourceLocation loc : this.assets.keySet()) {
            namespaces.add(loc.getNamespace());
        }
        return namespaces;
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... path) {
        if (path.length == 1 && "pack.mcmeta".equals(path[0])) {
            String metaJson = "{\n  \"pack\": {\n    \"description\": \"Auto-generated TFC AstikorCarts assets\",\n    \"pack_format\": %d\n  }\n}\n".formatted(34);
            byte[] data = metaJson.getBytes();
            return () -> new ByteArrayInputStream(data);
        }
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        byte[] data = this.assets.get(location);
        if (data != null) {
            return () -> new ByteArrayInputStream(data);
        }
        return null;
    }

    public void listResources(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        for (Map.Entry<ResourceLocation, byte[]> entry : this.assets.entrySet()) {
            ResourceLocation loc = entry.getKey();
            if (!loc.getNamespace().equals(namespace) || !loc.getPath().startsWith(path)) continue;
            output.accept((Object)loc, () -> new ByteArrayInputStream((byte[])entry.getValue()));
        }
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> serializer) throws IOException {
        if (serializer == PackMetadataSection.TYPE) {
            return (T)new PackMetadataSection((Component)Component.literal((String)"Auto-generated TFC AstikorCarts assets"), 34);
        }
        return null;
    }
}

