/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.client.renderer.entity;

import com.jusipat.astikorcartsredux.client.renderer.entity.DrawnRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tfcastikorcarts.client.TFCAstikorCartsModelLayers;
import tfcastikorcarts.client.renderer.entity.model.TFCSeedDrillModel;
import tfcastikorcarts.common.entities.carts.TFCSeedDrillEntity;
import tfcastikorcarts.util.AstikorHelpers;

public class TFCSeedDrillRenderer
extends DrawnRenderer<TFCSeedDrillEntity, TFCSeedDrillModel> {
    public final Random random = new Random();

    public TFCSeedDrillRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (EntityModel)new TFCSeedDrillModel(renderManager.bakeLayer(TFCAstikorCartsModelLayers.SEED_DRILL)));
        this.shadowRadius = 1.0f;
    }

    @NotNull
    public ResourceLocation getTextureLocation(TFCSeedDrillEntity entity) {
        return AstikorHelpers.identifier("textures/entity/seed_drill/" + entity.getTFCWoodType().getSerializedName() + ".png");
    }

    protected void renderContents(TFCSeedDrillEntity entity, float delta, PoseStack stack, MultiBufferSource source, int packedLight) {
        for (int i = 0; i < entity.getItemStacks().size(); ++i) {
            ItemStack itemStack = entity.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            int finalI = i;
            this.random.setSeed(32L * (long)i + (long)Objects.hashCode(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem())));
            int j = 0;
            while (j < itemStack.getCount() / 4) {
                int finalJ = j++;
                this.attach(((TFCSeedDrillModel)this.model).getBody(), ((TFCSeedDrillModel)this.model).getBody(), s -> {
                    float f = (float)finalI - 4.5f;
                    s.translate((double)f / 6.5 + 0.0625, (double)(-0.125f - (float)finalJ / 32.0f) + (double)(finalI % 4) * 0.001, (double)(this.random.nextFloat(0.375f) - 0.1875f));
                    s.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    s.scale(0.6f, 0.6f, 0.6f);
                    s.mulPose(Axis.ZP.rotation(this.random.nextFloat((float)Math.PI * 2)));
                    Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, s, source, entity.level(), 0);
                }, stack);
            }
        }
    }
}

