/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common;

import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.items.AstikorItems;
import tfcregistryapi.util.WoodRegistryHelper;

public class AstikorItemGroup {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"tfcastikorcarts");
    public static final Id CARTS = AstikorItemGroup.register("carts", () -> new ItemStack((ItemLike)AstikorItems.WHEELS.get(Wood.OAK).get()), AstikorItemGroup::fillCartsTab);

    public static Stream<CreativeModeTab.DisplayItemsGenerator> generators() {
        return Stream.of(CARTS).map(holder -> holder.generator);
    }

    public static void fillCartsTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (RegistryWood wood : WoodRegistryHelper.getAllWoodValues()) {
            out.accept((ItemLike)AstikorItems.WHEELS.get(wood));
            for (CartType cartType : CartType.values()) {
                out.accept((ItemLike)cartType.getItem(wood));
            }
        }
    }

    private static Id register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        DeferredHolder holder = CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().icon(icon).title((Component)Component.translatable((String)("tfcastikorcarts.creative_tab." + name))).displayItems(displayItems).build());
        return new Id((DeferredHolder<CreativeModeTab, CreativeModeTab>)holder, displayItems);
    }

    public record Id(DeferredHolder<CreativeModeTab, CreativeModeTab> tab, CreativeModeTab.DisplayItemsGenerator generator) {
    }
}

