/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.loading.FMLPaths;
import tfcastikorcarts.TFCAstikorCarts;
import tfcastikorcarts.common.CartType;
import tfcastikorcarts.common.items.AstikorItems;
import tfcregistryapi.util.WoodRegistryHelper;

public class DatapackGeneratorHandler {
    public static final String DATA_PACK_NAME = "TFC Astikor Carts Data";
    public static final Path DATA_PACK_PATH = FMLPaths.CONFIGDIR.get().resolve("tfcastikorcarts").resolve("TFC Astikor Carts Data");

    public static void initDatapack() {
        try {
            Path dataPath = DATA_PACK_PATH.resolve("data/tfcastikorcarts");
            Files.createDirectories(dataPath.resolve("recipes"), new FileAttribute[0]);
            Files.createDirectories(dataPath.resolve("tags/items"), new FileAttribute[0]);
            Files.createDirectories(dataPath.resolve("loot_tables"), new FileAttribute[0]);
            Path packMeta = DATA_PACK_PATH.resolve("pack.mcmeta");
            if (!Files.exists(packMeta, new LinkOption[0])) {
                int formatVersion = 48;
                Files.writeString(packMeta, (CharSequence)"{\n  \"pack\": {\n    \"description\": \"Auto-generated TFC AstikorCarts datapack\",\n    \"pack_format\": %d\n  }\n}\n".formatted(formatVersion), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            TFCAstikorCarts.LOGGER.error("Failed to create datapack folder", (Throwable)e);
        }
        DatapackGeneratorHandler.generateAllItemTags();
        DatapackGeneratorHandler.generateAllLootTables();
        DatapackGeneratorHandler.generateAllRecipes();
    }

    public static void generateAllLootTables() {
        for (CartType cart : CartType.values()) {
            for (RegistryWood wood : WoodRegistryHelper.getAllWoodValues()) {
                String wheelItem = AstikorItems.WHEELS.get(wood).getId().toString();
                DatapackGeneratorHandler.generateCartLootTable(cart.getSerializedName(), wood.getSerializedName(), wheelItem);
            }
        }
    }

    public static void generateCartLootTable(String type, String wood, String wheelItem) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:entity");
        JsonArray pools = new JsonArray();
        JsonObject wheelPool = new JsonObject();
        wheelPool.addProperty("name", "loot_pool");
        wheelPool.addProperty("rolls", (Number)1);
        JsonArray wheelEntries = new JsonArray();
        JsonObject wheelEntry = new JsonObject();
        wheelEntry.addProperty("type", "minecraft:item");
        wheelEntry.addProperty("name", wheelItem);
        JsonArray wheelFunctions = new JsonArray();
        JsonObject setCount = new JsonObject();
        setCount.addProperty("function", "minecraft:set_count");
        JsonObject count = new JsonObject();
        count.addProperty("type", "minecraft:uniform");
        count.addProperty("min", (Number)1);
        count.addProperty("max", (Number)2);
        setCount.add("count", (JsonElement)count);
        wheelFunctions.add((JsonElement)setCount);
        wheelEntry.add("functions", (JsonElement)wheelFunctions);
        wheelEntries.add((JsonElement)wheelEntry);
        wheelPool.add("entries", (JsonElement)wheelEntries);
        pools.add((JsonElement)wheelPool);
        JsonObject stickPool = new JsonObject();
        stickPool.addProperty("name", "loot_pool");
        stickPool.addProperty("rolls", (Number)1);
        JsonArray stickEntries = new JsonArray();
        JsonObject stickEntry = new JsonObject();
        stickEntry.addProperty("type", "minecraft:item");
        stickEntry.addProperty("name", "minecraft:stick");
        JsonArray stickFunctions = new JsonArray();
        JsonObject stickSetCount = new JsonObject();
        stickSetCount.addProperty("function", "minecraft:set_count");
        JsonObject stickCount = new JsonObject();
        stickCount.addProperty("type", "minecraft:uniform");
        stickCount.addProperty("min", (Number)1);
        stickCount.addProperty("max", (Number)4);
        stickSetCount.add("count", (JsonElement)stickCount);
        stickFunctions.add((JsonElement)stickSetCount);
        stickEntry.add("functions", (JsonElement)stickFunctions);
        stickEntries.add((JsonElement)stickEntry);
        stickPool.add("entries", (JsonElement)stickEntries);
        pools.add((JsonElement)stickPool);
        root.add("pools", (JsonElement)pools);
        DatapackGeneratorHandler.generateLootTable(type + "/" + wood, root);
    }

    public static void generateLootTable(String name, JsonObject recipeJson) {
        Path lootPath = DATA_PACK_PATH.resolve("data/tfcastikorcarts/loot_tables/entities/" + name + ".json");
        try {
            Files.createDirectories(lootPath.getParent(), new FileAttribute[0]);
            Files.writeString(lootPath, (CharSequence)recipeJson.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            TFCAstikorCarts.LOGGER.error("Failed to write loot table {}", (Object)lootPath, (Object)e);
        }
    }

    public static void generateAllRecipes() {
        for (RegistryWood wood : WoodRegistryHelper.getAllWoodValues()) {
            String plankItem = WoodRegistryHelper.getBlockResource((Block)WoodRegistryHelper.getWoodBlock((RegistryWood)wood, (TagKey)BlockTags.PLANKS, (String)"planks", (boolean)true)).toString();
            String slabItem = WoodRegistryHelper.getBlockResource((Block)WoodRegistryHelper.getWoodBlock((RegistryWood)wood, (TagKey)BlockTags.WOODEN_SLABS, (String)"plank", (boolean)true)).toString();
            String wheelItem = AstikorItems.WHEELS.get(wood).getId().toString();
            DatapackGeneratorHandler.generateWheelRecipe(wood, plankItem);
            for (CartType cart : CartType.values()) {
                DatapackGeneratorHandler.generateCartRecipe(cart, wood, plankItem, slabItem, wheelItem);
            }
        }
    }

    public static void generateWheelRecipe(RegistryWood wood, String plankItem) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:crafting_shaped");
        JsonArray pattern = new JsonArray();
        pattern.add("sss");
        pattern.add("sps");
        pattern.add("sss");
        root.add("pattern", (JsonElement)pattern);
        JsonObject key = new JsonObject();
        JsonObject p = new JsonObject();
        p.addProperty("item", plankItem);
        key.add("p", (JsonElement)p);
        JsonObject s = new JsonObject();
        s.addProperty("tag", "c:rods/wooden");
        key.add("s", (JsonElement)s);
        root.add("key", (JsonElement)key);
        JsonObject result = new JsonObject();
        result.addProperty("count", (Number)1);
        result.addProperty("id", AstikorItems.WHEELS.get(wood).getId().toString());
        root.add("result", (JsonElement)result);
        DatapackGeneratorHandler.generateRecipe("wheel/" + String.valueOf(wood), root);
    }

    public static void generateCartRecipe(CartType type, RegistryWood wood, String plankItem, String slabItem, String wheelItem) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:crafting_shaped");
        JsonArray pattern = new JsonArray();
        switch (type) {
            case ANIMAL_CART: {
                pattern.add("ppp");
                pattern.add("ppp");
                pattern.add("wpw");
                break;
            }
            case HAND_CART: {
                pattern.add("pcp");
                pattern.add("wpw");
                break;
            }
            case PLOW: {
                pattern.add("sss");
                pattern.add("psp");
                pattern.add("wpw");
                break;
            }
            case REAPER: {
                pattern.add(" sl");
                pattern.add("spp");
                pattern.add("iww");
                break;
            }
            case SEED_DRILL: {
                pattern.add("pcp");
                pattern.add("php");
                pattern.add("wpw");
                break;
            }
            case SUPPLY_CART: {
                pattern.add("pcp");
                pattern.add("pcp");
                pattern.add("wpw");
            }
        }
        root.add("pattern", (JsonElement)pattern);
        JsonObject key = new JsonObject();
        JsonObject p = new JsonObject();
        p.addProperty("item", plankItem);
        key.add("p", (JsonElement)p);
        JsonObject w = new JsonObject();
        w.addProperty("item", wheelItem);
        key.add("w", (JsonElement)w);
        if (type.equals((Object)CartType.HAND_CART) || type.equals((Object)CartType.SUPPLY_CART) || type.equals((Object)CartType.SEED_DRILL)) {
            JsonObject c = new JsonObject();
            c.addProperty("tag", "c:chests/wooden");
            key.add("c", (JsonElement)c);
        }
        if (type.equals((Object)CartType.PLOW) || type.equals((Object)CartType.REAPER)) {
            JsonObject s = new JsonObject();
            s.addProperty("tag", "c:rods/wooden");
            key.add("s", (JsonElement)s);
        }
        if (type.equals((Object)CartType.REAPER)) {
            JsonObject l = new JsonObject();
            l.addProperty("item", slabItem);
            key.add("l", (JsonElement)l);
            JsonObject i = new JsonObject();
            i.addProperty("tag", "c:double_sheets");
            key.add("i", (JsonElement)i);
        }
        if (type.equals((Object)CartType.SEED_DRILL)) {
            JsonObject h = new JsonObject();
            h.addProperty("item", "minecraft:hopper");
            key.add("h", (JsonElement)h);
        }
        root.add("key", (JsonElement)key);
        JsonObject result = new JsonObject();
        result.addProperty("count", (Number)1);
        result.addProperty("id", AstikorItems.CART_ITEMS.get((Object)type).get(wood).getId().toString());
        root.add("result", (JsonElement)result);
        DatapackGeneratorHandler.generateRecipe(type.getSerializedName() + "/" + wood.getSerializedName(), root);
    }

    public static void generateRecipe(String name, JsonObject recipeJson) {
        Path recipePath = DATA_PACK_PATH.resolve("data/tfcastikorcarts/recipes/" + name + ".json");
        try {
            Files.createDirectories(recipePath.getParent(), new FileAttribute[0]);
            Files.writeString(recipePath, (CharSequence)recipeJson.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            TFCAstikorCarts.LOGGER.error("Failed to write recipe {}", (Object)name, (Object)e);
        }
    }

    public static void generateAllItemTags() {
        List<String> wheels = WoodRegistryHelper.getAllWoodValues().stream().map(wood -> AstikorItems.WHEELS.get(wood).getId().toString()).toList();
        DatapackGeneratorHandler.generateItemTag("cart_wheel", wheels);
        for (CartType type : CartType.values()) {
            List<String> values = WoodRegistryHelper.getAllWoodValues().stream().map(wood -> AstikorItems.CART_ITEMS.get((Object)type).get(wood).getId().toString()).toList();
            DatapackGeneratorHandler.generateItemTag(type.getSerializedName(), values);
        }
    }

    public static void generateItemTag(String tagName, List<String> values) {
        JsonObject root = new JsonObject();
        root.addProperty("replace", Boolean.valueOf(false));
        JsonArray array = new JsonArray();
        for (String v : values) {
            array.add(v);
        }
        root.add("values", (JsonElement)array);
        Path tagPath = DATA_PACK_PATH.resolve("data/tfcastikorcarts/tags/items/" + tagName + ".json");
        try {
            Files.createDirectories(tagPath.getParent(), new FileAttribute[0]);
            Files.writeString(tagPath, (CharSequence)root.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            TFCAstikorCarts.LOGGER.error("Failed to write item tag {}", (Object)tagName, (Object)e);
        }
    }
}

