/*
 * Decompiled with CFR 0.152.
 */
package tfcastikorcarts.common.container;

import java.util.function.Supplier;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tfcastikorcarts.common.AstikorTags;
import tfcastikorcarts.common.container.DynamicGridContainer;
import tfcastikorcarts.config.TFCAstikorCartsConfig;

public class ContainerTypes {
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"tfcastikorcarts");
    public static final Id<DynamicGridContainer> HAND_CART_INVENTORY = ContainerTypes.register("hand_cart_inventory", (windowId, playerInv, buf) -> DynamicGridContainer.create((MenuType)HAND_CART_INVENTORY.get(), windowId, playerInv, ContainerTypes.handCartWidth().get(), ContainerTypes.handCartHeight().get(), ContainerTypes.handCartWhitelist().get(), ContainerTypes.handCartBlacklist().get()));
    public static final Id<DynamicGridContainer> SUPPLY_CART_INVENTORY = ContainerTypes.register("supply_cart_inventory", (windowId, playerInv, buf) -> DynamicGridContainer.create((MenuType)SUPPLY_CART_INVENTORY.get(), windowId, playerInv, ContainerTypes.supplyCartWidth().get(), ContainerTypes.supplyCartHeight().get(), ContainerTypes.supplyCartWhitelist().get(), ContainerTypes.supplyCartBlacklist().get()));

    public static Supplier<Integer> handCartWidth() {
        return TFCAstikorCartsConfig.COMMON.handCartInventoryWidth::get;
    }

    public static Supplier<Integer> handCartHeight() {
        return TFCAstikorCartsConfig.COMMON.handCartInventoryHeight::get;
    }

    public static Supplier<Integer> supplyCartWidth() {
        return TFCAstikorCartsConfig.COMMON.supplyCartInventoryWidth::get;
    }

    public static Supplier<Integer> supplyCartHeight() {
        return TFCAstikorCartsConfig.COMMON.supplyCartInventoryHeight::get;
    }

    public static Supplier<TagKey<Item>> handCartWhitelist() {
        return () -> AstikorTags.Items.HAND_CART_ITEM_WHITELIST;
    }

    public static Supplier<TagKey<Item>> handCartBlacklist() {
        return () -> AstikorTags.Items.HAND_CART_ITEM_BLACKLIST;
    }

    public static Supplier<TagKey<Item>> supplyCartWhitelist() {
        return () -> AstikorTags.Items.SUPPLY_CART_ITEM_WHITELIST;
    }

    public static Supplier<TagKey<Item>> supplyCartBlacklist() {
        return () -> AstikorTags.Items.SUPPLY_CART_ITEM_BLACKLIST;
    }

    public static <C extends AbstractContainerMenu> Id<C> register(String name, IContainerFactory<C> factory) {
        return new Id(RegistrationHelpers.registerContainer(CONTAINERS, (String)name, factory));
    }

    public record Id<T extends AbstractContainerMenu>(DeferredHolder<MenuType<?>, MenuType<T>> holder) implements RegistryHolder<MenuType<?>, MenuType<T>>
    {
    }
}

